/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.media;

import android.media.AudioManager;
import android.net.Uri;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.PluginResult;
import org.apache.cordova.media.AudioPlayer;
import org.apache.cordova.media.FileHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AudioHandler
extends CordovaPlugin {
    public static String TAG = "AudioHandler";
    HashMap<String, AudioPlayer> players = new HashMap();
    ArrayList<AudioPlayer> pausedForPhone = new ArrayList();
    private int origVolumeStream = -1;
    private CallbackContext messageChannel;

    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        CordovaResourceApi resourceApi = this.webView.getResourceApi();
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        if (action.equals("startRecordingAudio")) {
            String fileUriStr;
            String target = args.getString(1);
            try {
                Uri targetUri = resourceApi.remapUri(Uri.parse((String)target));
                fileUriStr = targetUri.toString();
            }
            catch (IllegalArgumentException e) {
                fileUriStr = target;
            }
            this.startRecordingAudio(args.getString(0), FileHelper.stripFileProtocol(fileUriStr));
        } else if (action.equals("stopRecordingAudio")) {
            this.stopRecordingAudio(args.getString(0));
        } else if (action.equals("startPlayingAudio")) {
            String fileUriStr;
            String target = args.getString(1);
            try {
                Uri targetUri = resourceApi.remapUri(Uri.parse((String)target));
                fileUriStr = targetUri.toString();
            }
            catch (IllegalArgumentException e) {
                fileUriStr = target;
            }
            this.startPlayingAudio(args.getString(0), FileHelper.stripFileProtocol(fileUriStr));
        } else if (action.equals("seekToAudio")) {
            this.seekToAudio(args.getString(0), args.getInt(1));
        } else if (action.equals("pausePlayingAudio")) {
            this.pausePlayingAudio(args.getString(0));
        } else if (action.equals("stopPlayingAudio")) {
            this.stopPlayingAudio(args.getString(0));
        } else if (action.equals("setVolume")) {
            try {
                this.setVolume(args.getString(0), Float.parseFloat(args.getString(1)));
            }
            catch (NumberFormatException target) {}
        } else {
            if (action.equals("getCurrentPositionAudio")) {
                float f = this.getCurrentPositionAudio(args.getString(0));
                callbackContext.sendPluginResult(new PluginResult(status, f));
                return true;
            }
            if (action.equals("getDurationAudio")) {
                float f = this.getDurationAudio(args.getString(0), args.getString(1));
                callbackContext.sendPluginResult(new PluginResult(status, f));
                return true;
            }
            if (action.equals("create")) {
                String id2 = args.getString(0);
                String src = FileHelper.stripFileProtocol(args.getString(1));
                this.getOrCreatePlayer(id2, src);
            } else {
                if (action.equals("release")) {
                    boolean b = this.release(args.getString(0));
                    callbackContext.sendPluginResult(new PluginResult(status, b));
                    return true;
                }
                if (action.equals("messageChannel")) {
                    this.messageChannel = callbackContext;
                    return true;
                }
                return false;
            }
        }
        callbackContext.sendPluginResult(new PluginResult(status, result));
        return true;
    }

    @Override
    public void onDestroy() {
        if (!this.players.isEmpty()) {
            this.onLastPlayerReleased();
        }
        for (AudioPlayer audio : this.players.values()) {
            audio.destroy();
        }
        this.players.clear();
    }

    @Override
    public void onReset() {
        this.onDestroy();
    }

    @Override
    public Object onMessage(String id2, Object data) {
        if (id2.equals("telephone")) {
            if ("ringing".equals(data) || "offhook".equals(data)) {
                for (AudioPlayer audio : this.players.values()) {
                    if (audio.getState() != AudioPlayer.STATE.MEDIA_RUNNING.ordinal()) continue;
                    this.pausedForPhone.add(audio);
                    audio.pausePlaying();
                }
            } else if ("idle".equals(data)) {
                for (AudioPlayer audio : this.pausedForPhone) {
                    audio.startPlaying(null);
                }
                this.pausedForPhone.clear();
            }
        }
        return null;
    }

    private AudioPlayer getOrCreatePlayer(String id2, String file) {
        AudioPlayer ret = this.players.get(id2);
        if (ret == null) {
            if (this.players.isEmpty()) {
                this.onFirstPlayerCreated();
            }
            ret = new AudioPlayer(this, id2, file);
            this.players.put(id2, ret);
        }
        return ret;
    }

    private boolean release(String id2) {
        AudioPlayer audio = this.players.remove(id2);
        if (audio == null) {
            return false;
        }
        if (this.players.isEmpty()) {
            this.onLastPlayerReleased();
        }
        audio.destroy();
        return true;
    }

    public void startRecordingAudio(String id2, String file) {
        AudioPlayer audio = this.getOrCreatePlayer(id2, file);
        audio.startRecording(file);
    }

    public void stopRecordingAudio(String id2) {
        AudioPlayer audio = this.players.get(id2);
        if (audio != null) {
            audio.stopRecording();
        }
    }

    public void startPlayingAudio(String id2, String file) {
        AudioPlayer audio = this.getOrCreatePlayer(id2, file);
        audio.startPlaying(file);
    }

    public void seekToAudio(String id2, int milliseconds) {
        AudioPlayer audio = this.players.get(id2);
        if (audio != null) {
            audio.seekToPlaying(milliseconds);
        }
    }

    public void pausePlayingAudio(String id2) {
        AudioPlayer audio = this.players.get(id2);
        if (audio != null) {
            audio.pausePlaying();
        }
    }

    public void stopPlayingAudio(String id2) {
        AudioPlayer audio = this.players.get(id2);
        if (audio != null) {
            audio.stopPlaying();
        }
    }

    public float getCurrentPositionAudio(String id2) {
        AudioPlayer audio = this.players.get(id2);
        if (audio != null) {
            return (float)audio.getCurrentPosition() / 1000.0f;
        }
        return -1.0f;
    }

    public float getDurationAudio(String id2, String file) {
        AudioPlayer audio = this.getOrCreatePlayer(id2, file);
        return audio.getDuration(file);
    }

    public void setAudioOutputDevice(int output) {
        AudioManager audiMgr = (AudioManager)this.cordova.getActivity().getSystemService("audio");
        if (output == 2) {
            audiMgr.setRouting(0, 2, -1);
        } else if (output == 1) {
            audiMgr.setRouting(0, 1, -1);
        } else {
            System.out.println("AudioHandler.setAudioOutputDevice() Error: Unknown output device.");
        }
    }

    public int getAudioOutputDevice() {
        AudioManager audiMgr = (AudioManager)this.cordova.getActivity().getSystemService("audio");
        if (audiMgr.getRouting(0) == 1) {
            return 1;
        }
        if (audiMgr.getRouting(0) == 2) {
            return 2;
        }
        return -1;
    }

    public void setVolume(String id2, float volume) {
        AudioPlayer audio = this.players.get(id2);
        if (audio != null) {
            audio.setVolume(volume);
        } else {
            System.out.println("AudioHandler.setVolume() Error: Unknown Audio Player " + id2);
        }
    }

    private void onFirstPlayerCreated() {
        this.origVolumeStream = this.cordova.getActivity().getVolumeControlStream();
        this.cordova.getActivity().setVolumeControlStream(3);
    }

    private void onLastPlayerReleased() {
        if (this.origVolumeStream != -1) {
            this.cordova.getActivity().setVolumeControlStream(this.origVolumeStream);
            this.origVolumeStream = -1;
        }
    }

    void sendEventMessage(String action, JSONObject actionData) {
        JSONObject message = new JSONObject();
        try {
            message.put("action", (Object)action);
            if (actionData != null) {
                message.put(action, (Object)actionData);
            }
        }
        catch (JSONException e) {
            Log.e((String)TAG, (String)"Failed to create event message", (Throwable)e);
        }
        PluginResult pluginResult = new PluginResult(PluginResult.Status.OK, message);
        pluginResult.setKeepCallback(true);
        if (this.messageChannel != null) {
            this.messageChannel.sendPluginResult(pluginResult);
        }
    }
}

