/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova.file;

import android.net.Uri;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.file.EncodingException;
import org.apache.cordova.file.FileExistsException;
import org.apache.cordova.file.InvalidModificationException;
import org.apache.cordova.file.LocalFilesystemURL;
import org.apache.cordova.file.NoModificationAllowedException;
import org.apache.cordova.file.TypeMismatchException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class Filesystem {
    protected final Uri rootUri;
    protected final CordovaResourceApi resourceApi;
    public final String name;
    private JSONObject rootEntry;

    public Filesystem(Uri rootUri, String name, CordovaResourceApi resourceApi) {
        this.rootUri = rootUri;
        this.name = name;
        this.resourceApi = resourceApi;
    }

    public static JSONObject makeEntryForURL(LocalFilesystemURL inputURL, Uri nativeURL) {
        try {
            String path = inputURL.path;
            int end = path.endsWith("/") ? 1 : 0;
            String[] parts = path.substring(0, path.length() - end).split("/+");
            String fileName = parts[parts.length - 1];
            JSONObject entry = new JSONObject();
            entry.put("isFile", !inputURL.isDirectory);
            entry.put("isDirectory", inputURL.isDirectory);
            entry.put("name", (Object)fileName);
            entry.put("fullPath", (Object)path);
            entry.put("filesystemName", (Object)inputURL.fsName);
            entry.put("filesystem", "temporary".equals(inputURL.fsName) ? 0 : 1);
            String nativeUrlStr = nativeURL.toString();
            if (inputURL.isDirectory && !nativeUrlStr.endsWith("/")) {
                nativeUrlStr = nativeUrlStr + "/";
            }
            entry.put("nativeURL", (Object)nativeUrlStr);
            return entry;
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public JSONObject makeEntryForURL(LocalFilesystemURL inputURL) {
        Uri nativeUri = this.toNativeUri(inputURL);
        return nativeUri == null ? null : Filesystem.makeEntryForURL(inputURL, nativeUri);
    }

    public JSONObject makeEntryForNativeUri(Uri nativeUri) {
        LocalFilesystemURL inputUrl = this.toLocalUri(nativeUri);
        return inputUrl == null ? null : Filesystem.makeEntryForURL(inputUrl, nativeUri);
    }

    public JSONObject getEntryForLocalURL(LocalFilesystemURL inputURL) throws IOException {
        return this.makeEntryForURL(inputURL);
    }

    public JSONObject makeEntryForFile(File file) {
        return this.makeEntryForNativeUri(Uri.fromFile((File)file));
    }

    abstract JSONObject getFileForLocalURL(LocalFilesystemURL var1, String var2, JSONObject var3, boolean var4) throws FileExistsException, IOException, TypeMismatchException, EncodingException, JSONException;

    abstract boolean removeFileAtLocalURL(LocalFilesystemURL var1) throws InvalidModificationException, NoModificationAllowedException;

    abstract boolean recursiveRemoveFileAtLocalURL(LocalFilesystemURL var1) throws FileExistsException, NoModificationAllowedException;

    abstract LocalFilesystemURL[] listChildren(LocalFilesystemURL var1) throws FileNotFoundException;

    public final JSONArray readEntriesAtLocalURL(LocalFilesystemURL inputURL) throws FileNotFoundException {
        LocalFilesystemURL[] children = this.listChildren(inputURL);
        JSONArray entries = new JSONArray();
        if (children != null) {
            for (LocalFilesystemURL url : children) {
                entries.put((Object)this.makeEntryForURL(url));
            }
        }
        return entries;
    }

    abstract JSONObject getFileMetadataForLocalURL(LocalFilesystemURL var1) throws FileNotFoundException;

    public Uri getRootUri() {
        return this.rootUri;
    }

    public boolean exists(LocalFilesystemURL inputURL) {
        try {
            this.getFileMetadataForLocalURL(inputURL);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        return true;
    }

    public Uri nativeUriForFullPath(String fullPath) {
        Uri ret = null;
        if (fullPath != null) {
            String encodedPath = Uri.fromFile((File)new File(fullPath)).getEncodedPath();
            if (encodedPath.startsWith("/")) {
                encodedPath = encodedPath.substring(1);
            }
            ret = this.rootUri.buildUpon().appendEncodedPath(encodedPath).build();
        }
        return ret;
    }

    public LocalFilesystemURL localUrlforFullPath(String fullPath) {
        Uri nativeUri = this.nativeUriForFullPath(fullPath);
        if (nativeUri != null) {
            return this.toLocalUri(nativeUri);
        }
        return null;
    }

    protected static String normalizePath(String rawPath) {
        boolean isAbsolutePath = rawPath.startsWith("/");
        if (isAbsolutePath) {
            rawPath = rawPath.replaceFirst("/+", "");
        }
        ArrayList<String> components = new ArrayList<String>(Arrays.asList(rawPath.split("/+")));
        for (int index = 0; index < components.size(); ++index) {
            if (!components.get(index).equals("..")) continue;
            components.remove(index);
            if (index <= 0) continue;
            components.remove(index - 1);
            --index;
        }
        StringBuilder normalizedPath = new StringBuilder();
        for (String component : components) {
            normalizedPath.append("/");
            normalizedPath.append(component);
        }
        if (isAbsolutePath) {
            return normalizedPath.toString();
        }
        return normalizedPath.toString().substring(1);
    }

    public abstract Uri toNativeUri(LocalFilesystemURL var1);

    public abstract LocalFilesystemURL toLocalUri(Uri var1);

    public JSONObject getRootEntry() {
        if (this.rootEntry == null) {
            this.rootEntry = this.makeEntryForNativeUri(this.rootUri);
        }
        return this.rootEntry;
    }

    public JSONObject getParentForLocalURL(LocalFilesystemURL inputURL) throws IOException {
        Uri parentUri = inputURL.uri;
        String parentPath = new File(inputURL.uri.getPath()).getParent();
        if (!"/".equals(parentPath)) {
            parentUri = inputURL.uri.buildUpon().path(parentPath + '/').build();
        }
        return this.getEntryForLocalURL(LocalFilesystemURL.parse(parentUri));
    }

    protected LocalFilesystemURL makeDestinationURL(String newName, LocalFilesystemURL srcURL, LocalFilesystemURL destURL, boolean isDirectory) {
        String newDest;
        if ("null".equals(newName) || "".equals(newName)) {
            newName = srcURL.uri.getLastPathSegment();
        }
        newDest = (newDest = destURL.uri.toString()).endsWith("/") ? newDest + newName : newDest + "/" + newName;
        if (isDirectory) {
            newDest = newDest + '/';
        }
        return LocalFilesystemURL.parse(newDest);
    }

    public JSONObject copyFileToURL(LocalFilesystemURL destURL, String newName, Filesystem srcFs, LocalFilesystemURL srcURL, boolean move) throws IOException, InvalidModificationException, JSONException, NoModificationAllowedException, FileExistsException {
        if (move && !srcFs.canRemoveFileAtLocalURL(srcURL)) {
            throw new NoModificationAllowedException("Cannot move file at source URL");
        }
        LocalFilesystemURL destination = this.makeDestinationURL(newName, srcURL, destURL, srcURL.isDirectory);
        Uri srcNativeUri = srcFs.toNativeUri(srcURL);
        CordovaResourceApi.OpenForReadResult ofrr = this.resourceApi.openForRead(srcNativeUri);
        OutputStream os = null;
        try {
            os = this.getOutputStreamForURL(destination);
        }
        catch (IOException e) {
            ofrr.inputStream.close();
            throw e;
        }
        this.resourceApi.copyResource(ofrr, os);
        if (move) {
            srcFs.removeFileAtLocalURL(srcURL);
        }
        return this.getEntryForLocalURL(destination);
    }

    public OutputStream getOutputStreamForURL(LocalFilesystemURL inputURL) throws IOException {
        return this.resourceApi.openOutputStream(this.toNativeUri(inputURL));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFileAtURL(LocalFilesystemURL inputURL, long start, long end, ReadFileCallback readFileCallback) throws IOException {
        CordovaResourceApi.OpenForReadResult ofrr = this.resourceApi.openForRead(this.toNativeUri(inputURL));
        if (end < 0L) {
            end = ofrr.length;
        }
        long numBytesToRead = end - start;
        try {
            if (start > 0L) {
                ofrr.inputStream.skip(start);
            }
            InputStream inputStream = ofrr.inputStream;
            if (end < ofrr.length) {
                inputStream = new LimitedInputStream(inputStream, numBytesToRead);
            }
            readFileCallback.handleData(inputStream, ofrr.mimeType);
        }
        finally {
            ofrr.inputStream.close();
        }
    }

    abstract long writeToFileAtURL(LocalFilesystemURL var1, String var2, int var3, boolean var4) throws NoModificationAllowedException, IOException;

    abstract long truncateFileAtURL(LocalFilesystemURL var1, long var2) throws IOException, NoModificationAllowedException;

    abstract String filesystemPathForURL(LocalFilesystemURL var1);

    abstract LocalFilesystemURL URLforFilesystemPath(String var1);

    abstract boolean canRemoveFileAtLocalURL(LocalFilesystemURL var1);

    protected class LimitedInputStream
    extends FilterInputStream {
        long numBytesToRead;

        public LimitedInputStream(InputStream in, long numBytesToRead) {
            super(in);
            this.numBytesToRead = numBytesToRead;
        }

        @Override
        public int read() throws IOException {
            if (this.numBytesToRead <= 0L) {
                return -1;
            }
            --this.numBytesToRead;
            return this.in.read();
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            if (this.numBytesToRead <= 0L) {
                return -1;
            }
            int bytesToRead = byteCount;
            if ((long)byteCount > this.numBytesToRead) {
                bytesToRead = (int)this.numBytesToRead;
            }
            int numBytesRead = this.in.read(buffer, byteOffset, bytesToRead);
            this.numBytesToRead -= (long)numBytesRead;
            return numBytesRead;
        }
    }

    public static interface ReadFileCallback {
        public void handleData(InputStream var1, String var2) throws IOException;
    }
}

