/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.net.Uri;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cordova.LOG;

public class Whitelist {
    private ArrayList<URLPattern> whiteList = new ArrayList();
    public static final String TAG = "Whitelist";

    public void addWhiteListEntry(String origin, boolean subdomains) {
        if (this.whiteList != null) {
            try {
                if (origin.compareTo("*") == 0) {
                    LOG.d(TAG, "Unlimited access to network resources");
                    this.whiteList = null;
                } else {
                    Pattern parts = Pattern.compile("^((\\*|[A-Za-z-]+):(//)?)?(\\*|((\\*\\.)?[^*/:]+))?(:(\\d+))?(/.*)?");
                    Matcher m = parts.matcher(origin);
                    if (m.matches()) {
                        String scheme = m.group(2);
                        String host = m.group(4);
                        if (("file".equals(scheme) || "content".equals(scheme)) && host == null) {
                            host = "*";
                        }
                        String port = m.group(8);
                        String path = m.group(9);
                        if (scheme == null) {
                            this.whiteList.add(new URLPattern("http", host, port, path));
                            this.whiteList.add(new URLPattern("https", host, port, path));
                        } else {
                            this.whiteList.add(new URLPattern(scheme, host, port, path));
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.d(TAG, "Failed to add origin %s", origin);
            }
        }
    }

    public boolean isUrlWhiteListed(String uri) {
        if (this.whiteList == null) {
            return true;
        }
        Uri parsedUri = Uri.parse((String)uri);
        for (URLPattern p : this.whiteList) {
            if (!p.matches(parsedUri)) continue;
            return true;
        }
        return false;
    }

    private static class URLPattern {
        public Pattern scheme;
        public Pattern host;
        public Integer port;
        public Pattern path;

        private String regexFromPattern(String pattern, boolean allowWildcards) {
            String toReplace = "\\.[]{}()^$?+|";
            StringBuilder regex = new StringBuilder();
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c == '*' && allowWildcards) {
                    regex.append("");
                } else if ("\\.[]{}()^$?+|".indexOf(c) > -1) {
                    regex.append('\\');
                }
                regex.append(c);
            }
            return regex.toString();
        }

        public URLPattern(String scheme, String host, String port, String path) throws MalformedURLException {
            try {
                this.scheme = scheme == null || "*".equals(scheme) ? null : Pattern.compile(this.regexFromPattern(scheme, false), 2);
                this.host = "*".equals(host) ? null : (host.startsWith("*.") ? Pattern.compile("([a-z0-9.-]*\\.)?" + this.regexFromPattern(host.substring(2), false), 2) : Pattern.compile(this.regexFromPattern(host, false), 2));
                this.port = port == null || "*".equals(port) ? null : Integer.valueOf(Integer.parseInt(port, 10));
                this.path = path == null || "/*".equals(path) ? null : Pattern.compile(this.regexFromPattern(path, true));
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException("Port must be a number");
            }
        }

        public boolean matches(Uri uri) {
            try {
                return !(this.scheme != null && !this.scheme.matcher(uri.getScheme()).matches() || this.host != null && !this.host.matcher(uri.getHost()).matches() || this.port != null && !this.port.equals(uri.getPort()) || this.path != null && !this.path.matcher(uri.getPath()).matches());
            }
            catch (Exception e) {
                LOG.d(Whitelist.TAG, e.toString());
                return false;
            }
        }
    }
}

