/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.wifi;

import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.util.Log;
import com.google.zxing.client.android.wifi.NetworkType;
import com.google.zxing.client.result.WifiParsedResult;
import java.util.List;
import java.util.regex.Pattern;

public final class WifiConfigManager
extends AsyncTask<WifiParsedResult, Object, Object> {
    private static final String TAG = WifiConfigManager.class.getSimpleName();
    private static final Pattern HEX_DIGITS = Pattern.compile("[0-9A-Fa-f]+");
    private final WifiManager wifiManager;

    public WifiConfigManager(WifiManager wifiManager) {
        this.wifiManager = wifiManager;
    }

    protected Object doInBackground(WifiParsedResult ... args) {
        NetworkType networkType;
        WifiParsedResult theWifiResult = args[0];
        if (!this.wifiManager.isWifiEnabled()) {
            Log.i((String)TAG, (String)"Enabling wi-fi...");
            if (!this.wifiManager.setWifiEnabled(true)) {
                Log.w((String)TAG, (String)"Wi-fi could not be enabled!");
                return null;
            }
            Log.i((String)TAG, (String)"Wi-fi enabled");
            int count = 0;
            while (!this.wifiManager.isWifiEnabled()) {
                if (count >= 10) {
                    Log.i((String)TAG, (String)"Took too long to enable wi-fi, quitting");
                    return null;
                }
                Log.i((String)TAG, (String)"Still waiting for wi-fi to enable...");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++count;
            }
        }
        String networkTypeString = theWifiResult.getNetworkEncryption();
        try {
            networkType = NetworkType.forIntentValue(networkTypeString);
        }
        catch (IllegalArgumentException ignored) {
            Log.w((String)TAG, (String)("Bad network type; see NetworkType values: " + networkTypeString));
            return null;
        }
        if (networkType == NetworkType.NO_PASSWORD) {
            WifiConfigManager.changeNetworkUnEncrypted(this.wifiManager, theWifiResult);
        } else {
            String password = theWifiResult.getPassword();
            if (password != null && !password.isEmpty()) {
                if (networkType == NetworkType.WEP) {
                    WifiConfigManager.changeNetworkWEP(this.wifiManager, theWifiResult);
                } else if (networkType == NetworkType.WPA) {
                    WifiConfigManager.changeNetworkWPA(this.wifiManager, theWifiResult);
                }
            }
        }
        return null;
    }

    private static void updateNetwork(WifiManager wifiManager, WifiConfiguration config) {
        int networkId;
        Integer foundNetworkID = WifiConfigManager.findNetworkInExistingConfig(wifiManager, config.SSID);
        if (foundNetworkID != null) {
            Log.i((String)TAG, (String)("Removing old configuration for network " + config.SSID));
            wifiManager.removeNetwork(foundNetworkID.intValue());
            wifiManager.saveConfiguration();
        }
        if ((networkId = wifiManager.addNetwork(config)) >= 0) {
            if (wifiManager.enableNetwork(networkId, true)) {
                Log.i((String)TAG, (String)("Associating to network " + config.SSID));
                wifiManager.saveConfiguration();
            } else {
                Log.w((String)TAG, (String)("Failed to enable network " + config.SSID));
            }
        } else {
            Log.w((String)TAG, (String)("Unable to add network " + config.SSID));
        }
    }

    private static WifiConfiguration changeNetworkCommon(WifiParsedResult wifiResult) {
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = WifiConfigManager.quoteNonHex(wifiResult.getSsid(), new int[0]);
        config.hiddenSSID = wifiResult.isHidden();
        return config;
    }

    private static void changeNetworkWEP(WifiManager wifiManager, WifiParsedResult wifiResult) {
        WifiConfiguration config = WifiConfigManager.changeNetworkCommon(wifiResult);
        config.wepKeys[0] = WifiConfigManager.quoteNonHex(wifiResult.getPassword(), 10, 26, 58);
        config.wepTxKeyIndex = 0;
        config.allowedAuthAlgorithms.set(1);
        config.allowedKeyManagement.set(0);
        config.allowedGroupCiphers.set(2);
        config.allowedGroupCiphers.set(3);
        config.allowedGroupCiphers.set(0);
        config.allowedGroupCiphers.set(1);
        WifiConfigManager.updateNetwork(wifiManager, config);
    }

    private static void changeNetworkWPA(WifiManager wifiManager, WifiParsedResult wifiResult) {
        WifiConfiguration config = WifiConfigManager.changeNetworkCommon(wifiResult);
        config.preSharedKey = WifiConfigManager.quoteNonHex(wifiResult.getPassword(), 64);
        config.allowedAuthAlgorithms.set(0);
        config.allowedProtocols.set(0);
        config.allowedProtocols.set(1);
        config.allowedKeyManagement.set(1);
        config.allowedKeyManagement.set(2);
        config.allowedPairwiseCiphers.set(1);
        config.allowedPairwiseCiphers.set(2);
        config.allowedGroupCiphers.set(2);
        config.allowedGroupCiphers.set(3);
        WifiConfigManager.updateNetwork(wifiManager, config);
    }

    private static void changeNetworkUnEncrypted(WifiManager wifiManager, WifiParsedResult wifiResult) {
        WifiConfiguration config = WifiConfigManager.changeNetworkCommon(wifiResult);
        config.allowedKeyManagement.set(0);
        WifiConfigManager.updateNetwork(wifiManager, config);
    }

    private static Integer findNetworkInExistingConfig(WifiManager wifiManager, String ssid) {
        List existingConfigs = wifiManager.getConfiguredNetworks();
        if (existingConfigs != null) {
            for (WifiConfiguration existingConfig : existingConfigs) {
                String existingSSID = existingConfig.SSID;
                if (existingSSID == null || !existingSSID.equals(ssid)) continue;
                return existingConfig.networkId;
            }
        }
        return null;
    }

    private static String quoteNonHex(String value, int ... allowedLengths) {
        return WifiConfigManager.isHexOfLength(value, allowedLengths) ? value : WifiConfigManager.convertToQuotedString(value);
    }

    private static String convertToQuotedString(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            return s;
        }
        return '\"' + s + '\"';
    }

    private static boolean isHexOfLength(CharSequence value, int ... allowedLengths) {
        if (value == null || !HEX_DIGITS.matcher(value).matches()) {
            return false;
        }
        if (allowedLengths.length == 0) {
            return true;
        }
        for (int length : allowedLengths) {
            if (value.length() != length) continue;
            return true;
        }
        return false;
    }
}

