/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.share;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import com.google.zxing.FakeR;
import com.google.zxing.client.android.share.AppInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class LoadPackagesAsyncTask
extends AsyncTask<Object, Object, List<AppInfo>> {
    private static final String[] PKG_PREFIX_WHITELIST = new String[]{"com.google.android.apps."};
    private static final String[] PKG_PREFIX_BLACKLIST = new String[]{"com.android.", "android", "com.google.android.", "com.htc"};
    private static FakeR fakeR;
    private final ListActivity activity;

    LoadPackagesAsyncTask(ListActivity activity) {
        this.activity = activity;
        fakeR = new FakeR((Activity)activity);
    }

    protected List<AppInfo> doInBackground(Object ... objects) {
        ArrayList<AppInfo> labelsPackages = new ArrayList<AppInfo>();
        PackageManager packageManager = this.activity.getPackageManager();
        List appInfos = packageManager.getInstalledApplications(0);
        for (PackageItemInfo appInfo : appInfos) {
            String packageName = appInfo.packageName;
            if (LoadPackagesAsyncTask.isHidden(packageName)) continue;
            CharSequence label = appInfo.loadLabel(packageManager);
            Drawable icon = appInfo.loadIcon(packageManager);
            if (label == null) continue;
            labelsPackages.add(new AppInfo(packageName, label.toString(), icon));
        }
        Collections.sort(labelsPackages);
        return labelsPackages;
    }

    private static boolean isHidden(String packageName) {
        if (packageName == null) {
            return true;
        }
        for (String prefix : PKG_PREFIX_WHITELIST) {
            if (!packageName.startsWith(prefix)) continue;
            return false;
        }
        for (String prefix : PKG_PREFIX_BLACKLIST) {
            if (!packageName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    protected void onPostExecute(final List<AppInfo> results) {
        ArrayAdapter<AppInfo> listAdapter = new ArrayAdapter<AppInfo>((Context)this.activity, fakeR.getId("layout", "app_picker_list_item"), fakeR.getId("id", "app_picker_list_item_label"), results){

            public View getView(int position, View convertView, ViewGroup parent) {
                View view = super.getView(position, convertView, parent);
                Drawable icon = ((AppInfo)results.get(position)).getIcon();
                if (icon != null) {
                    ((ImageView)view.findViewById(fakeR.getId("id", "app_picker_list_item_icon"))).setImageDrawable(icon);
                }
                return view;
            }
        };
        this.activity.setListAdapter((ListAdapter)listAdapter);
    }
}

