/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.share;

import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.google.zxing.client.android.share.BookmarkAdapter;
import java.util.ArrayList;
import java.util.List;

public final class BookmarkPickerActivity
extends ListActivity {
    private static final String TAG = BookmarkPickerActivity.class.getSimpleName();
    private static final String[] BOOKMARK_PROJECTION = new String[]{"title", "url"};
    private static final Uri BOOKMARKS_URI = Uri.parse((String)"content://browser/bookmarks");
    private static final String BOOKMARK_SELECTION = "bookmark = 1 AND url IS NOT NULL";
    private final List<String[]> titleURLs = new ArrayList<String[]>();

    protected void onResume() {
        super.onResume();
        this.titleURLs.clear();
        Cursor cursor = this.getContentResolver().query(BOOKMARKS_URI, BOOKMARK_PROJECTION, BOOKMARK_SELECTION, null, null);
        if (cursor == null) {
            Log.w((String)TAG, (String)"No cursor returned for bookmark query");
            this.finish();
            return;
        }
        try {
            while (cursor.moveToNext()) {
                this.titleURLs.add(new String[]{cursor.getString(0), cursor.getString(1)});
            }
        }
        finally {
            cursor.close();
        }
        this.setListAdapter((ListAdapter)new BookmarkAdapter((Context)this, this.titleURLs));
    }

    protected void onListItemClick(ListView l, View view, int position, long id2) {
        String[] titleURL = this.titleURLs.get(position);
        Intent intent = new Intent();
        intent.addFlags(524288);
        intent.putExtra("title", titleURL[0]);
        intent.putExtra("url", titleURL[1]);
        this.setResult(-1, intent);
        this.finish();
    }
}

