/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.result;

import android.app.Activity;
import com.google.zxing.Result;
import com.google.zxing.client.android.result.ResultHandler;
import com.google.zxing.client.result.ExpandedProductParsedResult;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ProductParsedResult;

public final class ProductResultHandler
extends ResultHandler {
    private static int[] buttons;

    public ProductResultHandler(Activity activity, ParsedResult result, Result rawResult) {
        super(activity, result, rawResult);
        buttons = new int[]{fakeR.getId("string", "button_product_search"), fakeR.getId("string", "button_web_search"), fakeR.getId("string", "button_custom_product_search")};
    }

    @Override
    public int getButtonCount() {
        return this.hasCustomProductSearch() ? buttons.length : buttons.length - 1;
    }

    @Override
    public int getButtonText(int index) {
        return buttons[index];
    }

    @Override
    public void handleButtonPress(int index) {
        String productID = ProductResultHandler.getProductIDFromResult(this.getResult());
        switch (index) {
            case 0: {
                this.openProductSearch(productID);
                break;
            }
            case 1: {
                this.webSearch(productID);
                break;
            }
            case 2: {
                this.openURL(this.fillInCustomSearchURL(productID));
            }
        }
    }

    private static String getProductIDFromResult(ParsedResult rawResult) {
        if (rawResult instanceof ProductParsedResult) {
            return ((ProductParsedResult)rawResult).getNormalizedProductID();
        }
        if (rawResult instanceof ExpandedProductParsedResult) {
            return ((ExpandedProductParsedResult)rawResult).getRawText();
        }
        throw new IllegalArgumentException(rawResult.getClass().toString());
    }

    @Override
    public int getDisplayTitle() {
        return fakeR.getId("string", "result_product");
    }
}

