/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.history;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.google.zxing.FakeR;
import com.google.zxing.client.android.CaptureActivity;
import com.google.zxing.client.android.history.HistoryItem;
import com.google.zxing.client.android.history.HistoryItemAdapter;
import com.google.zxing.client.android.history.HistoryManager;
import java.util.List;

public final class HistoryActivity
extends ListActivity {
    private static final String TAG = HistoryActivity.class.getSimpleName();
    private HistoryManager historyManager;
    private ArrayAdapter<HistoryItem> adapter;
    private CharSequence originalTitle;
    private static FakeR fakeR;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        fakeR = new FakeR((Activity)this);
        this.historyManager = new HistoryManager((Activity)this);
        this.adapter = new HistoryItemAdapter((Context)this);
        this.setListAdapter((ListAdapter)this.adapter);
        ListView listview = this.getListView();
        this.registerForContextMenu((View)listview);
        this.originalTitle = this.getTitle();
    }

    protected void onResume() {
        super.onResume();
        this.reloadHistoryItems();
    }

    private void reloadHistoryItems() {
        List<HistoryItem> items = this.historyManager.buildHistoryItems();
        this.adapter.clear();
        for (HistoryItem item : items) {
            this.adapter.add((Object)item);
        }
        this.setTitle(this.originalTitle + " (" + this.adapter.getCount() + ')');
        if (this.adapter.isEmpty()) {
            this.adapter.add((Object)new HistoryItem(null, null, null));
        }
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        if (((HistoryItem)this.adapter.getItem(position)).getResult() != null) {
            Intent intent = new Intent((Context)this, CaptureActivity.class);
            intent.putExtra("ITEM_NUMBER", position);
            this.setResult(-1, intent);
            this.finish();
        }
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        int position = ((AdapterView.AdapterContextMenuInfo)menuInfo).position;
        if (position >= this.adapter.getCount() || ((HistoryItem)this.adapter.getItem(position)).getResult() != null) {
            menu2.add(0, position, position, fakeR.getId("string", "history_clear_one_history_text"));
        }
    }

    public boolean onContextItemSelected(MenuItem item) {
        int position = item.getItemId();
        this.historyManager.deleteHistoryItem(position);
        this.reloadHistoryItems();
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (this.historyManager.hasHistoryItems()) {
            MenuInflater menuInflater = this.getMenuInflater();
            menuInflater.inflate(fakeR.getId("menu", "history"), menu2);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == fakeR.getId("id", "menu_history_send")) {
            CharSequence builder = this.historyManager.buildHistory();
            Uri historyFile = HistoryManager.saveHistory(builder.toString());
            if (historyFile == null) {
                AlertDialog.Builder intent = new AlertDialog.Builder((Context)this);
                intent.setMessage(fakeR.getId("string", "msg_unmount_usb"));
                intent.setPositiveButton(fakeR.getId("string", "button_ok"), (DialogInterface.OnClickListener)null);
                intent.show();
            } else {
                Intent intent1 = new Intent("android.intent.action.SEND", Uri.parse((String)"mailto:"));
                intent1.addFlags(524288);
                String subject = this.getResources().getString(fakeR.getId("string", "history_email_title"));
                intent1.putExtra("android.intent.extra.SUBJECT", subject);
                intent1.putExtra("android.intent.extra.TEXT", subject);
                intent1.putExtra("android.intent.extra.STREAM", (Parcelable)historyFile);
                intent1.setType("text/csv");
                try {
                    this.startActivity(intent1);
                }
                catch (ActivityNotFoundException var8) {
                    Log.w((String)TAG, (String)var8.toString());
                }
            }
        } else {
            if (itemId != fakeR.getId("id", "menu_history_clear_text")) {
                return super.onOptionsItemSelected(item);
            }
            AlertDialog.Builder builder1 = new AlertDialog.Builder((Context)this);
            builder1.setMessage(fakeR.getId("string", "msg_sure"));
            builder1.setCancelable(true);
            builder1.setPositiveButton(fakeR.getId("string", "button_ok"), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int i2) {
                    HistoryActivity.this.historyManager.clearHistory();
                    dialog.dismiss();
                    HistoryActivity.this.finish();
                }
            });
            builder1.setNegativeButton(fakeR.getId("string", "button_cancel"), (DialogInterface.OnClickListener)null);
            builder1.show();
        }
        return true;
    }
}

