/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.android.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Camera;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;

final class AutoFocusManager
implements Camera.AutoFocusCallback {
    private static final String TAG = AutoFocusManager.class.getSimpleName();
    private static final long AUTO_FOCUS_INTERVAL_MS = 2000L;
    private static final Collection<String> FOCUS_MODES_CALLING_AF = new ArrayList<String>(2);
    private boolean stopped;
    private boolean focusing;
    private final boolean useAutoFocus;
    private final Camera camera;
    private AsyncTask<?, ?, ?> outstandingTask;

    AutoFocusManager(Context context, Camera camera) {
        this.camera = camera;
        SharedPreferences sharedPrefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String currentFocusMode = camera.getParameters().getFocusMode();
        this.useAutoFocus = sharedPrefs.getBoolean("preferences_auto_focus", true) && FOCUS_MODES_CALLING_AF.contains(currentFocusMode);
        Log.i((String)TAG, (String)("Current focus mode '" + currentFocusMode + "'; use auto focus? " + this.useAutoFocus));
        this.start();
    }

    public synchronized void onAutoFocus(boolean success, Camera theCamera) {
        this.focusing = false;
        this.autoFocusAgainLater();
    }

    private synchronized void autoFocusAgainLater() {
        if (!this.stopped && this.outstandingTask == null) {
            AutoFocusTask newTask = new AutoFocusTask();
            try {
                newTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Object[0]);
                this.outstandingTask = newTask;
            }
            catch (RejectedExecutionException ree) {
                Log.w((String)TAG, (String)"Could not request auto focus", (Throwable)ree);
            }
        }
    }

    synchronized void start() {
        if (this.useAutoFocus) {
            this.outstandingTask = null;
            if (!this.stopped && !this.focusing) {
                try {
                    this.camera.autoFocus((Camera.AutoFocusCallback)this);
                    this.focusing = true;
                }
                catch (RuntimeException re) {
                    Log.w((String)TAG, (String)"Unexpected exception while focusing", (Throwable)re);
                    this.autoFocusAgainLater();
                }
            }
        }
    }

    private synchronized void cancelOutstandingTask() {
        if (this.outstandingTask != null) {
            if (this.outstandingTask.getStatus() != AsyncTask.Status.FINISHED) {
                this.outstandingTask.cancel(true);
            }
            this.outstandingTask = null;
        }
    }

    synchronized void stop() {
        this.stopped = true;
        if (this.useAutoFocus) {
            this.cancelOutstandingTask();
            try {
                this.camera.cancelAutoFocus();
            }
            catch (RuntimeException re) {
                Log.w((String)TAG, (String)"Unexpected exception while cancelling focusing", (Throwable)re);
            }
        }
    }

    static {
        FOCUS_MODES_CALLING_AF.add("auto");
        FOCUS_MODES_CALLING_AF.add("macro");
    }

    private final class AutoFocusTask
    extends AsyncTask<Object, Object, Object> {
        private AutoFocusTask() {
        }

        protected Object doInBackground(Object ... voids) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AutoFocusManager.this.start();
            return null;
        }
    }
}

