/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.scope.services.ums;

import com.google.protobuf.AbstractMessage;
import com.opera.core.systems.ScopeServices;
import com.opera.core.systems.scope.AbstractService;
import com.opera.core.systems.scope.WindowManagerCommand;
import com.opera.core.systems.scope.exceptions.WindowNotFoundException;
import com.opera.core.systems.scope.protos.UmsProtos;
import com.opera.core.systems.scope.protos.WmProtos;
import com.opera.core.systems.scope.services.IWindowManager;
import com.opera.core.systems.util.StackHashMap;
import com.opera.core.systems.util.VersionUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.JXPathContext;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriverException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowManager
extends AbstractService
implements IWindowManager {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final StackHashMap<Integer, WmProtos.WindowInfo> windows = new StackHashMap();
    private final CompiledExpression windowFinder;
    private final AtomicInteger lastHttpResponseCode = new AtomicInteger();

    @Override
    public AtomicInteger getLastHttpResponseCode() {
        return this.lastHttpResponseCode;
    }

    public WindowManager(ScopeServices services, String version) {
        super(services, version);
        String serviceName = "window-manager";
        if (!this.isVersionInRange(version, "3.0", serviceName)) {
            throw new UnsupportedOperationException(serviceName + " version " + version + " is not supported");
        }
        services.setWindowManager(this);
        this.windowFinder = JXPathContext.compile((String)"/.[windowType='normal']/windowID");
    }

    @Override
    public int getOpenWindowCount() {
        return this.windows.size();
    }

    @Override
    public void setActiveWindowId(Integer windowId) {
        this.windows.putIfAbsent(windowId, null);
    }

    @Override
    public int getActiveWindowId() {
        Integer windowID = this.windows.peekKey();
        if (windowID == null) {
            return this.findActiveWindow().getWindowID();
        }
        return windowID;
    }

    @Override
    public void addWindow(WmProtos.WindowInfo info) {
        this.windows.put(info.getWindowID(), info);
    }

    @Override
    public void removeWindow(Integer windowId) {
        this.windows.remove(windowId);
    }

    @Override
    public void init() {
        this.initializeWindows();
        this.findDriverWindow();
    }

    @Override
    public void findDriverWindow() {
        JXPathContext pathContext = JXPathContext.newContext(this.windows.values());
        WmProtos.WindowInfo window = this.windows.peek();
        if (window == null || !window.getWindowType().equals("normal")) {
            Integer windowId = (Integer)this.windowFinder.getValue(pathContext);
            if (windowId == null) {
                throw new WindowNotFoundException("No window is available for driving");
            }
            this.setActiveWindowId(windowId);
            this.filterActiveWindow();
        }
    }

    private WmProtos.WindowID findActiveWindow() {
        UmsProtos.Response response = this.executeCommand(WindowManagerCommand.GET_ACTIVE_WINDOW, null);
        WmProtos.WindowID.Builder builder = WmProtos.WindowID.newBuilder();
        WindowManager.buildPayload(response, builder);
        return builder.build();
    }

    @Override
    public void filterActiveWindow() {
        WmProtos.WindowFilter.Builder filterBuilder = WmProtos.WindowFilter.newBuilder();
        filterBuilder.setClearFilter(true);
        filterBuilder.addIncludeIDList(this.getActiveWindowId());
        this.executeCommand(WindowManagerCommand.MODIFY_FILTER, (AbstractMessage.Builder<?>)filterBuilder);
    }

    private void initializeWindows() {
        this.clearFilter();
        UmsProtos.Response response = this.executeCommand(WindowManagerCommand.LIST_WINDOWS, null);
        WmProtos.WindowList.Builder builder = WmProtos.WindowList.newBuilder();
        WindowManager.buildPayload(response, builder);
        WmProtos.WindowList list = builder.build();
        List<WmProtos.WindowInfo> windowsList = list.getWindowListList();
        this.windows.clear();
        for (WmProtos.WindowInfo window : windowsList) {
            this.windows.put(window.getWindowID(), window);
        }
        this.windows.putIfAbsent(this.findActiveWindow().getWindowID(), null);
    }

    @Override
    public void setActiveWindow(String title) {
        Integer windowId = (Integer)this.xpathPointer(this.windows.values(), "/.[title='" + title + "']/windowID").getValue();
        if (windowId == null) {
            throw new NoSuchWindowException("No such window : " + title);
        }
        this.setActiveWindowId(windowId);
    }

    @Override
    public void closeAllWindows() {
        LinkedList<Integer> list = new LinkedList<Integer>(this.windows.asStack());
        boolean canCloseAll = this.services.getExec().getActionList().contains("Close all pages");
        if (canCloseAll) {
            this.services.getExec().action("Close all pages", new String[0]);
        } else {
            while (!list.isEmpty()) {
                this.closeWindow(list.removeFirst());
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.logger.warning("Bad hack: sleeping 10ms between closing of windows, to prevent opera from crashing!");
            }
        }
    }

    @Override
    public List<Integer> getWindowHandles() {
        return new LinkedList<Integer>(this.windows.asStack());
    }

    @Override
    public void resetWindowsList() {
        this.initializeWindows();
    }

    @Override
    public void clearFilter() {
        WmProtos.WindowFilter.Builder filterBuilder = WmProtos.WindowFilter.newBuilder();
        filterBuilder.setClearFilter(true);
        filterBuilder.addIncludePatternList("*");
        this.executeCommand(WindowManagerCommand.MODIFY_FILTER, (AbstractMessage.Builder<?>)filterBuilder);
    }

    @Override
    public void filterWindow(Integer windowId) {
        WmProtos.WindowFilter.Builder filterBuilder = WmProtos.WindowFilter.newBuilder();
        filterBuilder.setClearFilter(true);
        filterBuilder.addIncludeIDList(windowId);
        this.executeCommand(WindowManagerCommand.MODIFY_FILTER, (AbstractMessage.Builder<?>)filterBuilder);
    }

    public String getActiveWindowTitle() {
        return this.windows.peek().getTitle();
    }

    @Override
    public void openUrl(int windowId, String url) {
        if (VersionUtil.compare(this.getVersion(), "2.1") < 0) {
            this.services.getExec().action("Go", url);
            return;
        }
        WmProtos.OpenURLArg.Builder openUrlBuilder = WmProtos.OpenURLArg.newBuilder();
        openUrlBuilder.setWindowID(windowId);
        openUrlBuilder.setUrl(url);
        UmsProtos.Response response = this.executeCommand(WindowManagerCommand.OPEN_URL, (AbstractMessage.Builder<?>)openUrlBuilder);
        if (response == null) {
            throw new WebDriverException("Internal error while opening " + url);
        }
    }

    @Override
    public void closeWindow(int windowId) {
        if (VersionUtil.compare(this.getVersion(), "2.1") < 0) {
            throw new UnsupportedOperationException("Window Manager version " + this.getVersion() + "does not support this method");
        }
        WmProtos.CloseWindowArg.Builder closeWindowBuilder = WmProtos.CloseWindowArg.newBuilder();
        closeWindowBuilder.setWindowID(windowId);
        UmsProtos.Response response = this.executeCommand(WindowManagerCommand.CLOSE_WINDOW, (AbstractMessage.Builder<?>)closeWindowBuilder);
        this.removeWindow(windowId);
        if (response == null) {
            throw new WebDriverException("Internal error while closing window");
        }
    }
}

