/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.runner.launcher;

import com.google.protobuf.GeneratedMessage;
import com.opera.core.systems.model.ScreenShotReply;
import com.opera.core.systems.runner.OperaRunner;
import com.opera.core.systems.runner.OperaRunnerException;
import com.opera.core.systems.runner.launcher.OperaLauncherBinary;
import com.opera.core.systems.runner.launcher.OperaLauncherProtocol;
import com.opera.core.systems.runner.launcher.OperaLauncherProtos;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.settings.OperaDriverSettings;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.DesiredCapabilities;

public class OperaLauncherRunner
implements OperaRunner {
    private static Logger logger = Logger.getLogger(OperaLauncherRunner.class.getName());
    private OperaLauncherBinary launcherRunner = null;
    private DesiredCapabilities capabilities;
    private OperaLauncherProtocol launcherProtocol = null;
    private String crashlog = null;

    @Deprecated
    public OperaLauncherRunner(OperaDriverSettings settings) {
        this((DesiredCapabilities)settings.getCapabilities());
    }

    public OperaLauncherRunner(DesiredCapabilities capabilities) {
        String environmentArguments;
        String binaryArguments;
        String profile;
        String product;
        this.capabilities = capabilities;
        if (this.capabilities.getCapability("opera.launcher") == null) {
            throw new WebDriverException("launcher path not set");
        }
        if (this.capabilities.getCapability("opera.binary") == null) {
            throw new WebDriverException("You need to set Opera's path to use the launcher");
        }
        Integer launcherPort = PortProber.findFreePort();
        ArrayList<String> stringArray = new ArrayList<String>();
        stringArray.add("-host");
        stringArray.add("127.0.0.1");
        stringArray.add("-port");
        stringArray.add(launcherPort.toString());
        if (this.capabilities.getCapability("opera.display") != null) {
            stringArray.add("-display");
            stringArray.add(":" + Integer.toString((Integer)this.capabilities.getCapability("opera.display")));
        }
        if (logger.isLoggable(Level.FINEST)) {
            stringArray.add("-console");
            stringArray.add("-verbosity");
            stringArray.add("FINEST");
        }
        if ((product = (String)capabilities.getCapability("opera.product")) != null && !product.isEmpty()) {
            stringArray.add("-profile");
            stringArray.add(product);
        }
        if (((Boolean)this.capabilities.getCapability("opera.no_quit")).booleanValue()) {
            stringArray.add("-noquit");
        }
        stringArray.add("-bin");
        stringArray.add((String)this.capabilities.getCapability("opera.binary"));
        if (!stringArray.contains("-autotestmode")) {
            stringArray.add("-autotestmode");
        }
        if ((profile = (String)this.capabilities.getCapability("opera.profile")) == null) {
            profile = TemporaryFilesystem.getDefaultTmpFS().createTempDir("opera-profile", "").getAbsolutePath();
            capabilities.setCapability("opera.profile", profile);
            stringArray.add("-pd");
            stringArray.add(profile);
        } else if (!profile.isEmpty()) {
            stringArray.add("-pd");
            stringArray.add(profile);
        }
        int port = (Integer)this.capabilities.getCapability("opera.port");
        if (port != -1) {
            String host = (String)this.capabilities.getCapability("opera.host");
            stringArray.add("-debugproxy");
            stringArray.add(host + ":" + port);
        }
        if ((binaryArguments = (String)this.capabilities.getCapability("opera.arguments")) == null) {
            binaryArguments = "";
        }
        if ((environmentArguments = System.getenv("OPERA_ARGS")) != null && environmentArguments.length() > 0) {
            binaryArguments = environmentArguments + " " + binaryArguments;
        }
        StringTokenizer tokenizer = new StringTokenizer(binaryArguments, " ");
        while (tokenizer.hasMoreTokens()) {
            stringArray.add(tokenizer.nextToken());
        }
        logger.config("launcher arguments: " + ((Object)stringArray).toString());
        this.launcherRunner = new OperaLauncherBinary((String)this.capabilities.getCapability("opera.launcher"), stringArray.toArray(new String[stringArray.size()]));
        logger.fine("Waiting for launcher connection on port " + launcherPort);
        try {
            ServerSocket listenerServer = new ServerSocket(launcherPort);
            listenerServer.setSoTimeout((int)OperaIntervals.LAUNCHER_TIMEOUT.getValue());
            this.launcherProtocol = new OperaLauncherProtocol(listenerServer.accept());
            logger.fine("Connected with launcher on port " + launcherPort);
            listenerServer.close();
            OperaLauncherProtos.LauncherHandshakeRequest.Builder request = OperaLauncherProtos.LauncherHandshakeRequest.newBuilder();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_HELLO, request.build().toByteArray());
            if (!res.isSuccess()) {
                throw new OperaRunnerException("Did not get launcher handshake: " + res.getResponse().toString());
            }
            logger.finer("Got launcher handshake: " + res.getResponse().toString());
        }
        catch (SocketTimeoutException e) {
            throw new OperaRunnerException("Timeout waiting for launcher to connect on port " + launcherPort, e);
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to listen to launcher port " + launcherPort, e);
        }
    }

    public void startOpera() {
        logger.fine("Instructing launcher to start Opera...");
        try {
            byte[] request = OperaLauncherProtos.LauncherStartRequest.newBuilder().build().toByteArray();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_START, request);
            if (this.handleStatusMessage(res.getResponse()) != OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new OperaRunnerException("Could not start Opera");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STATUS, request);
            if (this.handleStatusMessage(res.getResponse()) != OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new OperaRunnerException("Opera exited immediately; possibly incorrect arguments?  Command: " + this.launcherRunner.getCommand());
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not start Opera", e);
        }
        logger.fine("Opera launched through launcher");
    }

    public void stopOpera() {
        logger.fine("Instructing launcher to stop Opera...");
        try {
            OperaLauncherProtos.LauncherStopRequest.Builder request = OperaLauncherProtos.LauncherStopRequest.newBuilder();
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STOP, request.build().toByteArray());
            if (this.handleStatusMessage(res.getResponse()) == OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING) {
                throw new OperaRunnerException("Could not stop Opera");
            }
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not stop Opera", e);
        }
        logger.fine("Opera stopped through launcher");
    }

    public boolean isOperaRunning() {
        return this.isOperaRunning(0);
    }

    public boolean isOperaRunning(int processId) {
        logger.finer("Getting Opera's status from launcher");
        try {
            OperaLauncherProtocol.ResponseEncapsulation res;
            OperaLauncherProtos.LauncherStatusRequest.Builder request = OperaLauncherProtos.LauncherStatusRequest.newBuilder();
            if (processId > 0) {
                request.setProcessid(processId);
            }
            return this.handleStatusMessage((res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_STATUS, request.build().toByteArray())).getResponse()) == OperaLauncherProtos.LauncherStatusResponse.StatusType.RUNNING;
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not get state of Opera", e);
        }
    }

    public boolean hasOperaCrashed() {
        return this.crashlog != null;
    }

    public String getOperaCrashlog() {
        return this.crashlog;
    }

    public void shutdown() {
        logger.fine("Shutting down launcher");
        try {
            try {
                this.launcherProtocol.sendRequestWithoutResponse(OperaLauncherProtocol.MessageType.MSG_SHUTDOWN, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.launcherProtocol.shutdown();
        }
        catch (IOException e) {
            throw new OperaRunnerException("Unable to shut down launcher", e);
        }
        if (this.launcherRunner != null) {
            this.launcherRunner.shutdown();
            this.launcherRunner = null;
        }
    }

    private OperaLauncherProtos.LauncherStatusResponse.StatusType handleStatusMessage(GeneratedMessage msg) {
        OperaLauncherProtos.LauncherStatusResponse response = (OperaLauncherProtos.LauncherStatusResponse)msg;
        logger.finest("[LAUNCHER] Status: " + response.getStatus().toString());
        if (response.hasExitcode()) {
            logger.finest("[LAUNCHER] Status: exitCode=" + response.getExitcode());
        }
        if (response.hasCrashlog()) {
            logger.finest("[LAUNCHER] Status: crashLog=yes");
        } else {
            logger.finest("[LAUNCHER] Status: crashLog=no");
        }
        if (response.getLogmessagesCount() > 0) {
            for (String message : response.getLogmessagesList()) {
                logger.finest("[LAUNCHER LOG] " + message);
            }
        } else {
            logger.finest("[LAUNCHER LOG] No log...");
        }
        OperaLauncherProtos.LauncherStatusResponse.StatusType status = response.getStatus();
        this.crashlog = status == OperaLauncherProtos.LauncherStatusResponse.StatusType.CRASHED ? (response.hasCrashlog() ? response.getCrashlog().toStringUtf8() : "") : null;
        return status;
    }

    public ScreenShotReply saveScreenshot(long timeout, String ... hashes) {
        String resultMd5 = null;
        byte[] resultBytes = null;
        boolean blank = false;
        logger.fine("Instructing launcher to take screenshot");
        try {
            OperaLauncherProtos.LauncherScreenshotRequest.Builder request = OperaLauncherProtos.LauncherScreenshotRequest.newBuilder();
            for (int i = 0; i < hashes.length; ++i) {
                request.addKnownMD5S(hashes[i]);
            }
            request.setKnownMD5STimeoutMs((int)timeout);
            OperaLauncherProtocol.ResponseEncapsulation res = this.launcherProtocol.sendRequest(OperaLauncherProtocol.MessageType.MSG_SCREENSHOT, request.build().toByteArray());
            OperaLauncherProtos.LauncherScreenshotResponse response = (OperaLauncherProtos.LauncherScreenshotResponse)res.getResponse();
            resultMd5 = response.getMd5();
            resultBytes = response.getImagedata().toByteArray();
            if (response.hasBlank()) {
                blank = response.getBlank();
            }
        }
        catch (SocketTimeoutException e) {
            throw new OperaRunnerException("Could not get screenshot from launcher (Socket Timeout)", e);
        }
        catch (IOException e) {
            throw new OperaRunnerException("Could not get screenshot from launcher with exception:" + e, e);
        }
        this.isOperaRunning();
        ScreenShotReply screenshotreply = new ScreenShotReply(resultMd5, resultBytes);
        screenshotreply.setBlank(blank);
        screenshotreply.setCrashed(this.hasOperaCrashed());
        return screenshotreply;
    }
}

