/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems;

import com.opera.core.systems.OperaDriver;
import com.opera.core.systems.QuickMenu;
import com.opera.core.systems.QuickMenuItem;
import com.opera.core.systems.QuickWidget;
import com.opera.core.systems.QuickWindow;
import com.opera.core.systems.runner.launcher.OperaLauncherRunner;
import com.opera.core.systems.scope.exceptions.CommunicationException;
import com.opera.core.systems.scope.internal.OperaIntervals;
import com.opera.core.systems.scope.protos.DesktopWmProtos;
import com.opera.core.systems.scope.protos.SystemInputProtos;
import com.opera.core.systems.scope.services.IDesktopUtils;
import com.opera.core.systems.scope.services.IDesktopWindowManager;
import com.opera.core.systems.scope.services.ISystemInput;
import com.opera.core.systems.settings.OperaDriverSettings;
import com.opera.core.systems.util.ProfileUtils;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.Capabilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperaDesktopDriver
extends OperaDriver {
    private IDesktopWindowManager desktopWindowManager;
    private ISystemInput systemInputManager;
    private IDesktopUtils desktopUtils;
    private ProfileUtils profileUtils;
    private boolean firstTestRun = true;
    private String largePreferencesPath;
    private String smallPreferencesPath;
    private String cachePreferencesPath;

    public OperaDesktopDriver() {
        this.initDesktopDriver();
    }

    @Deprecated
    public OperaDesktopDriver(OperaDriverSettings settings) {
        this(settings.getCapabilities());
    }

    public OperaDesktopDriver(Capabilities c) {
        super(c);
        this.initDesktopDriver();
    }

    private void setPrefsPaths() {
        this.largePreferencesPath = this.getLargePreferencesPath();
        this.smallPreferencesPath = this.getSmallPreferencesPath();
        this.cachePreferencesPath = this.getCachePreferencesPath();
        this.profileUtils = new ProfileUtils(this.largePreferencesPath, this.smallPreferencesPath, this.cachePreferencesPath, (Capabilities)this.capabilities);
    }

    private void setServices() {
        this.desktopWindowManager = this.services.getDesktopWindowManager();
        this.systemInputManager = this.services.getSystemInputManager();
        this.desktopUtils = this.services.getDesktopUtils();
    }

    private void startOpera() {
        super.init();
        this.setServices();
        this.setPrefsPaths();
    }

    private void initDesktopDriver() {
        this.setServices();
        this.setPrefsPaths();
        if (this.capabilities != null && this.capabilities.getCapability("opera.binary") == null && !((Boolean)this.capabilities.getCapability("opera.no_restart")).booleanValue()) {
            String operaPath = this.getOperaPath();
            this.logger.info("OperaBinaryLocation retrieved from Opera: " + operaPath);
            if (operaPath.length() > 0) {
                this.capabilities.setCapability("opera.binary", operaPath);
                int pid = this.desktopUtils.getOperaPid();
                this.operaRunner = new OperaLauncherRunner(this.capabilities);
                this.services.quit(this.operaRunner, pid);
                this.profileUtils.deleteProfile();
                this.startOpera();
            }
        }
    }

    @Override
    protected Map<String, String> getServicesList() {
        Map<String, String> versions = super.getServicesList();
        versions.put("desktop-window-manager", "2.0");
        versions.put("system-input", "1.0");
        versions.put("desktop-utils", "2.0");
        return versions;
    }

    public void quitDriver() {
        this.logger.fine("Opera Desktop Driver shutting down");
        this.services.shutdown();
        if (this.operaRunner != null) {
            this.operaRunner.shutdown();
        }
    }

    public void quitOpera() {
        if (this.operaRunner != null) {
            if (this.operaRunner.isOperaRunning() || this.operaRunner.hasOperaCrashed()) {
                this.services.shutdown();
                this.operaRunner.stopOpera();
            }
        } else {
            String operaPath = this.desktopUtils.getOperaPath();
            this.logger.info("OperaBinaryLocation retrieved from Opera: " + operaPath);
            int pid = 0;
            if (operaPath.length() > 0) {
                this.capabilities.setCapability("opera.binary", operaPath);
                pid = this.desktopUtils.getOperaPid();
            }
            this.operaRunner = new OperaLauncherRunner(this.capabilities);
            this.services.quit(this.operaRunner, pid);
        }
    }

    public int getActiveQuickWindowID() {
        return this.desktopWindowManager.getActiveQuickWindowId();
    }

    public List<QuickWidget> getQuickWidgetList(String windowName) {
        int id = this.getQuickWindowID(windowName);
        if (id >= 0 || windowName.isEmpty()) {
            return this.getQuickWidgetList(id);
        }
        return Collections.emptyList();
    }

    public List<QuickWidget> getQuickWidgetList(int windowId) {
        return this.desktopWindowManager.getQuickWidgetList(windowId);
    }

    public List<QuickWindow> getQuickWindowList() {
        return this.desktopWindowManager.getQuickWindowList();
    }

    public QuickMenu getQuickMenu(String menuName) {
        return this.desktopWindowManager.getQuickMenu(menuName);
    }

    public QuickMenu getQuickMenu(String menuName, int windowId) {
        return this.desktopWindowManager.getQuickMenu(menuName, windowId);
    }

    public List<QuickMenu> getQuickMenuList() {
        return this.desktopWindowManager.getQuickMenuList();
    }

    public List<QuickMenuItem> getQuickMenuItemList() {
        return this.desktopWindowManager.getQuickMenuItemList();
    }

    public int getQuickWindowID(String windowName) {
        return this.desktopWindowManager.getQuickWindowID(windowName);
    }

    public QuickWindow getQuickWindow(String windowName) {
        return this.desktopWindowManager.getQuickWindowByName(windowName);
    }

    public QuickWidget findWidgetByName(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String widgetName) {
        return this.desktopWindowManager.getQuickWidget(type, windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.NAME, widgetName);
    }

    public QuickWidget findWidgetByName(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String widgetName, String parentName) {
        return this.desktopWindowManager.getQuickWidget(type, windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.NAME, widgetName, parentName);
    }

    public QuickWidget findWidgetByText(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String text) {
        return this.desktopWindowManager.getQuickWidget(type, windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.TEXT, text);
    }

    public QuickWidget findWidgetByText(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String text, String parentName) {
        return this.desktopWindowManager.getQuickWidget(type, windowId, DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.TEXT, text, parentName);
    }

    public QuickWidget findWidgetByStringId(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String stringId) {
        String text = this.desktopUtils.getString(stringId, true);
        return this.findWidgetByText(type, windowId, text);
    }

    public QuickWidget findWidgetByStringId(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, String stringId, String parentName) {
        String text = this.desktopUtils.getString(stringId, true);
        return this.findWidgetByText(type, windowId, text, parentName);
    }

    public QuickWidget findWidgetByPosition(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, int row, int column) {
        return this.desktopWindowManager.getQuickWidgetByPos(type, windowId, row, column);
    }

    public QuickWidget findWidgetByPosition(DesktopWmProtos.QuickWidgetInfo.QuickWidgetType type, int windowId, int row, int column, String parentName) {
        return this.desktopWindowManager.getQuickWidgetByPos(type, windowId, row, column, parentName);
    }

    public void pressQuickMenuItem(String menuItemText, boolean popMenu) {
        this.desktopWindowManager.pressQuickMenuItem(menuItemText, popMenu);
    }

    public QuickMenuItem getQuickMenuItemByAction(String action) {
        return this.desktopWindowManager.getQuickMenuItemByAction(action);
    }

    public QuickMenuItem getQuickMenuItemBySubmenu(String submenu) {
        return this.desktopWindowManager.getQuickMenuItemBySubmenu(submenu);
    }

    public QuickMenuItem getQuickMenuItemByName(String name) {
        return this.desktopWindowManager.getQuickMenuItemByName(name);
    }

    public QuickMenuItem getQuickMenuItemByName(String name, int window_id) {
        return this.desktopWindowManager.getQuickMenuItemByName(name, window_id);
    }

    public QuickMenuItem getQuickMenuItemByText(String text) {
        return this.desktopWindowManager.getQuickMenuItemByText(text);
    }

    public QuickMenuItem getQuickMenuItemByPosition(int row, String menuName) {
        return this.desktopWindowManager.getQuickMenuItemByPosition(row, menuName);
    }

    public QuickMenuItem getQuickMenuItemByAccKey(String key, String menuName) {
        return this.desktopWindowManager.getQuickMenuItemByAccKey(key, menuName);
    }

    public QuickMenuItem getQuickMenuItemByShortcut(String shortcut) {
        return this.desktopWindowManager.getQuickMenuItemByShortcut(shortcut);
    }

    public QuickMenuItem getQuickMenuItemByStringId(String stringId) {
        String text = this.desktopUtils.getString(stringId, true);
        return this.desktopWindowManager.getQuickMenuItemByText(text);
    }

    public QuickWindow findWindowByName(String windowName) {
        return this.desktopWindowManager.getQuickWindow(DesktopWmProtos.QuickWidgetSearch.QuickWidgetSearchType.NAME, windowName);
    }

    public QuickWindow findWindowById(int windowId) {
        return this.desktopWindowManager.getQuickWindowById(windowId);
    }

    public String getQuickWindowName(int windowId) {
        return this.desktopWindowManager.getQuickWindowName(windowId);
    }

    public String getString(String enumText, boolean stripAmpersand) {
        return this.desktopUtils.getString(enumText, stripAmpersand);
    }

    public String getOperaPath() {
        return this.desktopUtils.getOperaPath();
    }

    public String getLargePreferencesPath() {
        return this.desktopUtils.getLargePreferencesPath();
    }

    public String getSmallPreferencesPath() {
        return this.desktopUtils.getSmallPreferencesPath();
    }

    public String getCachePreferencesPath() {
        return this.desktopUtils.getCachePreferencesPath();
    }

    public void keyPress(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        this.systemInputManager.keyPress(key, modifiers);
    }

    public void keyUp(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        this.systemInputManager.keyUp(key, modifiers);
    }

    public void keyDown(String key, List<SystemInputProtos.ModifierPressed> modifiers) {
        this.systemInputManager.keyDown(key, modifiers);
    }

    public int getQuickWindowCount() {
        return this.desktopWindowManager.getOpenQuickWindowCount();
    }

    public void operaDesktopAction(String using, int data, String dataString, String dataStringParam) {
        this.exec.action(using, data, dataString, dataStringParam);
    }

    public void waitStart() {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        this.services.waitStart();
    }

    public void waitForWindowUpdated() {
        this.waitForWindowUpdated("");
    }

    public void waitForWindowActivated() {
        this.waitForWindowActivated("");
    }

    public void waitForWindowClose() {
        this.waitForWindowClose("");
    }

    public int waitForWindowShown(String windowName) {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.services.waitForDesktopWindowShown(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getValue());
    }

    public int waitForWindowUpdated(String windowName) {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.services.waitForDesktopWindowUpdated(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getValue());
    }

    public int waitForWindowActivated(String windowName) {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.services.waitForDesktopWindowActivated(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getValue());
    }

    public int waitForWindowClose(String windowName) {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.services.waitForDesktopWindowClosed(windowName, OperaIntervals.WINDOW_EVENT_TIMEOUT.getValue());
    }

    public int waitForWindowLoaded(String windowName) {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.services.waitForDesktopWindowLoaded(windowName, OperaIntervals.PAGE_LOAD_TIMEOUT.getValue());
    }

    public String waitForMenuShown(String menuName) {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.services.waitForMenuShown(menuName, OperaIntervals.MENU_EVENT_TIMEOUT.getValue());
    }

    public String waitForMenuClosed(String menuName) {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a window failed because Opera is not connected.");
        }
        return this.services.waitForMenuClosed(menuName, OperaIntervals.MENU_EVENT_TIMEOUT.getValue());
    }

    public String waitForMenuItemPressed(String menuItemText) {
        if (this.services.getConnection() == null) {
            throw new CommunicationException("waiting for a menu item to be pressed failed because Opera is not connected.");
        }
        return this.services.waitForMenuItemPressed(menuItemText, OperaIntervals.MENU_EVENT_TIMEOUT.getValue());
    }

    public void resetOperaPrefs(String newPrefs) {
        if (!this.firstTestRun || new File(newPrefs).exists()) {
            if (!(this.profileUtils.isMainProfile(this.smallPreferencesPath) || this.profileUtils.isMainProfile(this.largePreferencesPath) || this.profileUtils.isMainProfile(this.cachePreferencesPath))) {
                this.quitOpera();
                this.profileUtils.deleteProfile();
                this.profileUtils.copyProfile(newPrefs);
                this.startOpera();
            } else {
                this.logger.warning("Running tests in main user profile");
            }
        }
        this.firstTestRun = false;
    }

    public void deleteOperaPrefs() {
        if (this.operaRunner != null && !this.operaRunner.isOperaRunning()) {
            this.profileUtils.deleteProfile();
        } else {
            this.logger.warning("Cannot delete profile while Opera is running");
        }
    }

    public int getPid() {
        return this.desktopUtils.getOperaPid();
    }

    public boolean isOperaRunning() {
        return this.operaRunner != null && this.isOperaRunning();
    }
}

