/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.Logging;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.audio.JavaAudioDeviceModule;
import org.otwebrtc.audio.VolumeLogger;
import org.otwebrtc.audio.WebRtcAudioUtils;

class WebRtcAudioTrack {
    private static final String TAG = "WebRtcAudioTrackExternal";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final long AUDIO_TRACK_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_USAGE = WebRtcAudioTrack.getDefaultUsageAttribute();
    private static final int AUDIO_TRACK_START = 0;
    private static final int AUDIO_TRACK_STOP = 1;
    private long nativeAudioTrack;
    private final Context context;
    private final AudioManager audioManager;
    private final ThreadUtils.ThreadChecker threadChecker;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioTrack audioTrack;
    @Nullable
    private AudioTrackThread audioThread;
    private final VolumeLogger volumeLogger;
    private volatile boolean speakerMute;
    private byte[] emptyBytes;
    @Nullable
    private final JavaAudioDeviceModule.AudioTrackErrorCallback errorCallback;
    @Nullable
    private final JavaAudioDeviceModule.AudioTrackStateCallback stateCallback;

    private static int getDefaultUsageAttribute() {
        if (Build.VERSION.SDK_INT >= 21) {
            return 2;
        }
        return 0;
    }

    @CalledByNative
    WebRtcAudioTrack(Context context, AudioManager audioManager) {
        this(context, audioManager, null, null);
    }

    WebRtcAudioTrack(Context context, AudioManager audioManager, @Nullable JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback, @Nullable JavaAudioDeviceModule.AudioTrackStateCallback audioTrackStateCallback) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        this.threadChecker = new ThreadUtils.ThreadChecker();
        this.threadChecker.detachThread();
        this.context = context;
        this.audioManager = audioManager;
        this.errorCallback = audioTrackErrorCallback;
        webRtcAudioTrack.stateCallback = audioTrackStateCallback;
        webRtcAudioTrack.volumeLogger = new VolumeLogger(audioManager);
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CalledByNative
    private boolean initPlayout(int n, int n2, double d2) {
        block7: {
            AudioTrack audioTrack;
            WebRtcAudioTrack webRtcAudioTrack = this;
            this.threadChecker.checkIsOnValidThread();
            Logging.d(TAG, "initPlayout(sampleRate=" + n + ", channels=" + n2 + ", bufferSizeFactor=" + d2 + ")");
            webRtcAudioTrack.byteBuffer = ByteBuffer.allocateDirect(n2 * 2 * (n / 100));
            Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
            webRtcAudioTrack.emptyBytes = new byte[webRtcAudioTrack.byteBuffer.capacity()];
            WebRtcAudioTrack.nativeCacheDirectBufferAddress(webRtcAudioTrack.nativeAudioTrack, this.byteBuffer);
            n2 = this.channelCountToConfiguration(n2);
            int n3 = (int)((double)AudioTrack.getMinBufferSize((int)n, (int)n2, (int)2) * d2);
            Logging.d(TAG, "minBufferSizeInBytes: " + n3);
            if (n3 < this.byteBuffer.capacity()) {
                this.reportWebRtcAudioTrackInitError("AudioTrack.getMinBufferSize returns an invalid value.");
                return false;
            }
            if (this.audioTrack != null) {
                this.reportWebRtcAudioTrackInitError("Conflict with existing AudioTrack.");
                return false;
            }
            try {
                AudioTrack audioTrack2;
                WebRtcAudioTrack webRtcAudioTrack2;
                if (Build.VERSION.SDK_INT >= 21) {
                    webRtcAudioTrack2 = this;
                    audioTrack2 = WebRtcAudioTrack.createAudioTrackOnLollipopOrHigher(n, n2, n3);
                } else {
                    webRtcAudioTrack2 = this;
                    audioTrack2 = WebRtcAudioTrack.createAudioTrackOnLowerThanLollipop(n, n2, n3);
                }
                webRtcAudioTrack2.audioTrack = audioTrack2;
                audioTrack = this.audioTrack;
                if (audioTrack == null) break block7;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = illegalArgumentException.getMessage();
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.reportWebRtcAudioTrackInitError(string);
                webRtcAudioTrack3.releaseAudioResources();
                return false;
            }
            if (audioTrack.getState() == 1) {
                WebRtcAudioTrack webRtcAudioTrack4 = this;
                webRtcAudioTrack4.logMainParameters();
                webRtcAudioTrack4.logMainParametersExtended();
                return true;
            }
        }
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.reportWebRtcAudioTrackInitError("Initialization of audio track failed.");
        webRtcAudioTrack.releaseAudioResources();
        return false;
    }

    @CalledByNative
    private boolean startPlayout() {
        AudioTrackThread audioTrackThread;
        block2: {
            WebRtcAudioTrack webRtcAudioTrack;
            WebRtcAudioTrack webRtcAudioTrack2 = this;
            webRtcAudioTrack2.threadChecker.checkIsOnValidThread();
            webRtcAudioTrack2.volumeLogger.start();
            Logging.d(TAG, "startPlayout");
            WebRtcAudioTrack.assertTrue(webRtcAudioTrack2.audioTrack != null);
            WebRtcAudioTrack.assertTrue(this.audioThread == null);
            try {
                WebRtcAudioTrack webRtcAudioTrack3 = this;
                webRtcAudioTrack3.audioTrack.play();
                if (webRtcAudioTrack3.audioTrack.getPlayState() == 3) break block2;
                webRtcAudioTrack = this;
            }
            catch (IllegalStateException illegalStateException) {
                WebRtcAudioTrack webRtcAudioTrack4 = this;
                webRtcAudioTrack4.reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode.AUDIO_TRACK_START_EXCEPTION, "AudioTrack.play failed: " + illegalStateException.getMessage());
                webRtcAudioTrack4.releaseAudioResources();
                return false;
            }
            webRtcAudioTrack.reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode.AUDIO_TRACK_START_STATE_MISMATCH, "AudioTrack.play failed - incorrect state :" + this.audioTrack.getPlayState());
            webRtcAudioTrack.releaseAudioResources();
            return false;
        }
        AudioTrackThread audioTrackThread2 = audioTrackThread;
        audioTrackThread2("AudioTrackJavaThread");
        this.audioThread = audioTrackThread2;
        audioTrackThread.start();
        return true;
    }

    @CalledByNative
    private boolean stopPlayout() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        webRtcAudioTrack.volumeLogger.stop();
        Logging.d(TAG, "stopPlayout");
        WebRtcAudioTrack.assertTrue(webRtcAudioTrack.audioThread != null);
        WebRtcAudioTrack webRtcAudioTrack2 = this;
        webRtcAudioTrack2.logUnderrunCount();
        webRtcAudioTrack2.audioThread.stopThread();
        Logging.d(TAG, "Stopping the AudioTrackThread...");
        webRtcAudioTrack2.audioThread.interrupt();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioTrack2.audioThread, 2000L)) {
            WebRtcAudioTrack webRtcAudioTrack3 = this;
            Logging.e(TAG, "Join of AudioTrackThread timed out.");
            Context context = webRtcAudioTrack3.context;
            AudioManager audioManager = webRtcAudioTrack3.audioManager;
            WebRtcAudioUtils.logAudioState(TAG, context, audioManager);
        }
        Logging.d(TAG, "AudioTrackThread has now been stopped.");
        this.audioThread = null;
        if (this.audioTrack != null) {
            WebRtcAudioTrack webRtcAudioTrack4 = this;
            Logging.d(TAG, "Calling AudioTrack.stop...");
            try {
                webRtcAudioTrack4.audioTrack.stop();
                Logging.d(TAG, "AudioTrack.stop is done.");
                webRtcAudioTrack4.doAudioTrackStateCallback(1);
            }
            catch (IllegalStateException illegalStateException) {
                Logging.e(TAG, "AudioTrack.stop failed: " + illegalStateException.getMessage());
            }
        }
        this.releaseAudioResources();
        return true;
    }

    @CalledByNative
    private int getStreamMaxVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamMaxVolume");
        return webRtcAudioTrack.audioManager.getStreamMaxVolume(0);
    }

    @CalledByNative
    private boolean setStreamVolume(int n) {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "setStreamVolume(" + n + ")");
        if (webRtcAudioTrack.isVolumeFixed()) {
            Logging.e(TAG, "The device implements a fixed volume policy.");
            return false;
        }
        this.audioManager.setStreamVolume(0, n, 0);
        return true;
    }

    private boolean isVolumeFixed() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        return this.audioManager.isVolumeFixed();
    }

    @CalledByNative
    private int getStreamVolume() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.threadChecker.checkIsOnValidThread();
        Logging.d(TAG, "getStreamVolume");
        return webRtcAudioTrack.audioManager.getStreamVolume(0);
    }

    @CalledByNative
    private int GetPlayoutUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            WebRtcAudioTrack webRtcAudioTrack = webRtcAudioTrack.audioTrack;
            if (webRtcAudioTrack != null) {
                return webRtcAudioTrack.getUnderrunCount();
            }
            return -1;
        }
        return -2;
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioTrack: session ID: " + this.audioTrack.getAudioSessionId() + ", channels: " + this.audioTrack.getChannelCount() + ", sample rate: " + this.audioTrack.getSampleRate() + ", max gain: " + AudioTrack.getMaxVolume());
    }

    @TargetApi(value=21)
    private static AudioTrack createAudioTrackOnLollipopOrHigher(int n, int n2, int n3) {
        Logging.d(TAG, "createAudioTrackOnLollipopOrHigher");
        int n4 = AudioTrack.getNativeOutputSampleRate((int)0);
        Logging.d(TAG, "nativeOutputSampleRate: " + n4);
        if (n != n4) {
            Logging.w(TAG, "Unable to use fast mode since requested sample rate is not native");
        }
        return new AudioTrack(new AudioAttributes.Builder().setUsage(DEFAULT_USAGE).setContentType(1).build(), new AudioFormat.Builder().setEncoding(2).setSampleRate(n).setChannelMask(n2).build(), n3, 1, 0);
    }

    private static AudioTrack createAudioTrackOnLowerThanLollipop(int n, int n2, int n3) {
        return new AudioTrack(0, n, n2, 2, n3, 1);
    }

    private void logBufferSizeInFrames() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioTrack: buffer size in frames: " + this.audioTrack.getBufferSizeInFrames());
        }
    }

    private void logBufferCapacityInFrames() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "AudioTrack: buffer capacity in frames: " + this.audioTrack.getBufferCapacityInFrames());
        }
    }

    private void logMainParametersExtended() {
        WebRtcAudioTrack webRtcAudioTrack = this;
        webRtcAudioTrack.logBufferSizeInFrames();
        webRtcAudioTrack.logBufferCapacityInFrames();
    }

    private void logUnderrunCount() {
        if (Build.VERSION.SDK_INT >= 24) {
            Logging.d(TAG, "underrun count: " + this.audioTrack.getUnderrunCount());
        }
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n) {
        return n == 1 ? 4 : 12;
    }

    private static native void nativeCacheDirectBufferAddress(long var0, ByteBuffer var2);

    private static native void nativeGetPlayoutData(long var0, int var2);

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        AudioTrack audioTrack = this.audioTrack;
        if (audioTrack != null) {
            audioTrack.release();
            this.audioTrack = null;
        }
    }

    private void reportWebRtcAudioTrackInitError(String string) {
        WebRtcAudioTrack webRtcAudioTrack = object;
        Logging.e(TAG, "Init playout error: " + string);
        Object object = webRtcAudioTrack.context;
        AudioManager audioManager = webRtcAudioTrack.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioTrack.errorCallback;
        if (object != null) {
            object.onWebRtcAudioTrackInitError(string);
        }
    }

    private void reportWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode audioTrackStartErrorCode, String string) {
        WebRtcAudioTrack webRtcAudioTrack = object;
        Logging.e(TAG, "Start playout error: " + (Object)((Object)audioTrackStartErrorCode) + ". " + string);
        Object object = webRtcAudioTrack.context;
        AudioManager audioManager = webRtcAudioTrack.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioTrack.errorCallback;
        if (object != null) {
            object.onWebRtcAudioTrackStartError(audioTrackStartErrorCode, string);
        }
    }

    private void reportWebRtcAudioTrackError(String string) {
        WebRtcAudioTrack webRtcAudioTrack = object;
        Logging.e(TAG, "Run-time playback error: " + string);
        Object object = webRtcAudioTrack.context;
        AudioManager audioManager = webRtcAudioTrack.audioManager;
        WebRtcAudioUtils.logAudioState(TAG, (Context)object, audioManager);
        object = webRtcAudioTrack.errorCallback;
        if (object != null) {
            object.onWebRtcAudioTrackError(string);
        }
    }

    private void doAudioTrackStateCallback(int n) {
        Logging.d(TAG, "doAudioTrackStateCallback: " + n);
        JavaAudioDeviceModule.AudioTrackStateCallback audioTrackStateCallback = ((WebRtcAudioTrack)((Object)audioTrackStateCallback)).stateCallback;
        if (audioTrackStateCallback != null) {
            if (n == 0) {
                audioTrackStateCallback.onWebRtcAudioTrackStart();
            } else if (n == 1) {
                audioTrackStateCallback.onWebRtcAudioTrackStop();
            } else {
                Logging.e(TAG, "Invalid audio state");
            }
        }
    }

    @CalledByNative
    public void setNativeAudioTrack(long l) {
        this.nativeAudioTrack = l;
    }

    public void setSpeakerMute(boolean bl) {
        Logging.w(TAG, "setSpeakerMute(" + bl + ")");
        this.speakerMute = bl;
    }

    private class AudioTrackThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioTrackThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        private int writeBytes(AudioTrack audioTrack, ByteBuffer byteBuffer, int n) {
            if (Build.VERSION.SDK_INT >= 21) {
                return audioTrack.write(byteBuffer, n, 0);
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            Object object = byteBuffer2.array();
            return audioTrack.write((byte[])object, byteBuffer2.arrayOffset(), n);
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            Logging.d(WebRtcAudioTrack.TAG, "AudioTrackThread" + WebRtcAudioUtils.getThreadInfo());
            WebRtcAudioTrack.assertTrue(WebRtcAudioTrack.this.audioTrack.getPlayState() == 3);
            AudioTrackThread audioTrackThread = this;
            audioTrackThread.WebRtcAudioTrack.this.doAudioTrackStateCallback(0);
            int n = audioTrackThread.WebRtcAudioTrack.this.byteBuffer.capacity();
            while (this.keepAlive) {
                AudioTrackThread audioTrackThread2 = this;
                WebRtcAudioTrack.nativeGetPlayoutData(audioTrackThread2.WebRtcAudioTrack.this.nativeAudioTrack, n);
                WebRtcAudioTrack.assertTrue(n <= audioTrackThread2.WebRtcAudioTrack.this.byteBuffer.remaining());
                if (WebRtcAudioTrack.this.speakerMute) {
                    AudioTrackThread audioTrackThread3 = this;
                    audioTrackThread3.WebRtcAudioTrack.this.byteBuffer.clear();
                    audioTrackThread3.WebRtcAudioTrack.this.byteBuffer.put(WebRtcAudioTrack.this.emptyBytes);
                    audioTrackThread3.WebRtcAudioTrack.this.byteBuffer.position(0);
                }
                AudioTrackThread audioTrackThread4 = this;
                int n2 = audioTrackThread4.writeBytes(audioTrackThread4.WebRtcAudioTrack.this.audioTrack, WebRtcAudioTrack.this.byteBuffer, n);
                if (n2 != n) {
                    Logging.e(WebRtcAudioTrack.TAG, "AudioTrack.write played invalid number of bytes: " + n2);
                    if (n2 < 0) {
                        this.keepAlive = false;
                        WebRtcAudioTrack.this.reportWebRtcAudioTrackError("AudioTrack.write failed: " + n2);
                    }
                }
                WebRtcAudioTrack.this.byteBuffer.rewind();
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioTrack.TAG, "stopThread");
            this.keepAlive = false;
        }
    }
}

