/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc.audio;

import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.support.annotation.RequiresApi;
import org.otwebrtc.JniCommon;
import org.otwebrtc.Logging;
import org.otwebrtc.audio.AudioDeviceModule;
import org.otwebrtc.audio.WebRtcAudioEffects;
import org.otwebrtc.audio.WebRtcAudioManager;
import org.otwebrtc.audio.WebRtcAudioRecord;
import org.otwebrtc.audio.WebRtcAudioTrack;

public class JavaAudioDeviceModule
implements AudioDeviceModule {
    private static final String TAG = "JavaAudioDeviceModule";
    private final Context context;
    private final AudioManager audioManager;
    private final WebRtcAudioRecord audioInput;
    private final WebRtcAudioTrack audioOutput;
    private final int inputSampleRate;
    private final int outputSampleRate;
    private final boolean useStereoInput;
    private final boolean useStereoOutput;
    private final Object nativeLock;
    private long nativeAudioDeviceModule;

    public static Builder builder(Context context) {
        return new Builder(context);
    }

    public static boolean isBuiltInAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.isAcousticEchoCancelerSupported();
    }

    public static boolean isBuiltInNoiseSuppressorSupported() {
        return WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private JavaAudioDeviceModule(Context context, AudioManager audioManager, WebRtcAudioRecord webRtcAudioRecord, WebRtcAudioTrack webRtcAudioTrack, int n, int n2, boolean bl, boolean bl2) {
        Object object;
        Object object2 = object;
        object = new Object();
        v1.nativeLock = object2;
        v1.context = context;
        v1.audioManager = audioManager;
        v1.audioInput = webRtcAudioRecord;
        v1.audioOutput = webRtcAudioTrack;
        v1.inputSampleRate = n;
        v1.outputSampleRate = n2;
        v1.useStereoInput = bl;
        v1.useStereoOutput = bl2;
    }

    private static native long nativeCreateAudioDeviceModule(Context var0, AudioManager var1, WebRtcAudioRecord var2, WebRtcAudioTrack var3, int var4, int var5, boolean var6, boolean var7);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getNativeAudioDeviceModulePointer() {
        JavaAudioDeviceModule javaAudioDeviceModule = this;
        Object object = javaAudioDeviceModule.nativeLock;
        synchronized (object) {
            if (javaAudioDeviceModule.nativeAudioDeviceModule == 0L) {
                JavaAudioDeviceModule javaAudioDeviceModule2 = this;
                AudioManager audioManager = javaAudioDeviceModule2.audioManager;
                WebRtcAudioRecord webRtcAudioRecord = javaAudioDeviceModule2.audioInput;
                WebRtcAudioTrack webRtcAudioTrack = javaAudioDeviceModule2.audioOutput;
                int n = javaAudioDeviceModule2.inputSampleRate;
                int n2 = javaAudioDeviceModule2.outputSampleRate;
                boolean bl = javaAudioDeviceModule2.useStereoInput;
                boolean bl2 = javaAudioDeviceModule2.useStereoOutput;
                this.nativeAudioDeviceModule = JavaAudioDeviceModule.nativeCreateAudioDeviceModule(this.context, audioManager, webRtcAudioRecord, webRtcAudioTrack, n, n2, bl, bl2);
            }
            return this.nativeAudioDeviceModule;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void release() {
        JavaAudioDeviceModule javaAudioDeviceModule = this;
        Object object = javaAudioDeviceModule.nativeLock;
        synchronized (object) {
            if (javaAudioDeviceModule.nativeAudioDeviceModule != 0L) {
                JniCommon.nativeReleaseRef(this.nativeAudioDeviceModule);
                this.nativeAudioDeviceModule = 0L;
            }
            return;
        }
    }

    @Override
    public void setSpeakerMute(boolean bl) {
        Logging.d(TAG, "setSpeakerMute: " + bl);
        this.audioOutput.setSpeakerMute(bl);
    }

    @Override
    public void setMicrophoneMute(boolean bl) {
        Logging.d(TAG, "setMicrophoneMute: " + bl);
        this.audioInput.setMicrophoneMute(bl);
    }

    @RequiresApi(value=23)
    public void setPreferredInputDevice(AudioDeviceInfo audioDeviceInfo) {
        Logging.d(TAG, "setPreferredInputDevice: " + audioDeviceInfo);
        this.audioInput.setPreferredDevice(audioDeviceInfo);
    }

    public static interface AudioTrackStateCallback {
        public void onWebRtcAudioTrackStart();

        public void onWebRtcAudioTrackStop();
    }

    public static interface AudioTrackErrorCallback {
        public void onWebRtcAudioTrackInitError(String var1);

        public void onWebRtcAudioTrackStartError(AudioTrackStartErrorCode var1, String var2);

        public void onWebRtcAudioTrackError(String var1);
    }

    public static final class AudioTrackStartErrorCode
    extends Enum<AudioTrackStartErrorCode> {
        public static final /* enum */ AudioTrackStartErrorCode AUDIO_TRACK_START_EXCEPTION;
        public static final /* enum */ AudioTrackStartErrorCode AUDIO_TRACK_START_STATE_MISMATCH;
        private static final /* synthetic */ AudioTrackStartErrorCode[] $VALUES;

        public static AudioTrackStartErrorCode[] values() {
            return (AudioTrackStartErrorCode[])$VALUES.clone();
        }

        public static AudioTrackStartErrorCode valueOf(String string) {
            return Enum.valueOf(AudioTrackStartErrorCode.class, string);
        }

        static {
            AudioTrackStartErrorCode audioTrackStartErrorCode;
            AUDIO_TRACK_START_EXCEPTION = new AudioTrackStartErrorCode();
            AudioTrackStartErrorCode audioTrackStartErrorCode2 = audioTrackStartErrorCode;
            AUDIO_TRACK_START_STATE_MISMATCH = new AudioTrackStartErrorCode();
            $VALUES = new AudioTrackStartErrorCode[]{AUDIO_TRACK_START_EXCEPTION, audioTrackStartErrorCode2};
        }
    }

    public static interface SamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        public AudioSamples(int n, int n2, int n3, byte[] byArray) {
            this.audioFormat = n;
            this.channelCount = n2;
            this.sampleRate = n3;
            this.data = byArray;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface AudioRecordStateCallback {
        public void onWebRtcAudioRecordStart();

        public void onWebRtcAudioRecordStop();
    }

    public static interface AudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static final class AudioRecordStartErrorCode
    extends Enum<AudioRecordStartErrorCode> {
        public static final /* enum */ AudioRecordStartErrorCode AUDIO_RECORD_START_EXCEPTION;
        public static final /* enum */ AudioRecordStartErrorCode AUDIO_RECORD_START_STATE_MISMATCH;
        private static final /* synthetic */ AudioRecordStartErrorCode[] $VALUES;

        public static AudioRecordStartErrorCode[] values() {
            return (AudioRecordStartErrorCode[])$VALUES.clone();
        }

        public static AudioRecordStartErrorCode valueOf(String string) {
            return Enum.valueOf(AudioRecordStartErrorCode.class, string);
        }

        static {
            AudioRecordStartErrorCode audioRecordStartErrorCode;
            AUDIO_RECORD_START_EXCEPTION = new AudioRecordStartErrorCode();
            AudioRecordStartErrorCode audioRecordStartErrorCode2 = audioRecordStartErrorCode;
            AUDIO_RECORD_START_STATE_MISMATCH = new AudioRecordStartErrorCode();
            $VALUES = new AudioRecordStartErrorCode[]{AUDIO_RECORD_START_EXCEPTION, audioRecordStartErrorCode2};
        }
    }

    public static class Builder {
        private final Context context;
        private final AudioManager audioManager;
        private int inputSampleRate;
        private int outputSampleRate;
        private int audioSource;
        private int audioFormat;
        private AudioTrackErrorCallback audioTrackErrorCallback;
        private AudioRecordErrorCallback audioRecordErrorCallback;
        private SamplesReadyCallback samplesReadyCallback;
        private AudioTrackStateCallback audioTrackStateCallback;
        private AudioRecordStateCallback audioRecordStateCallback;
        private boolean useHardwareAcousticEchoCanceler;
        private boolean useHardwareNoiseSuppressor;
        private boolean useStereoInput;
        private boolean useStereoOutput;

        private Builder(Context context) {
            Builder builder = builder2;
            builder2.audioSource = 7;
            builder2.audioFormat = 2;
            builder2.useHardwareAcousticEchoCanceler = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
            builder2.useHardwareNoiseSuppressor = JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported();
            builder2.context = context;
            Builder builder2 = (AudioManager)context.getSystemService("audio");
            builder.audioManager = builder2;
            builder.inputSampleRate = WebRtcAudioManager.getSampleRate((AudioManager)builder2);
            builder.outputSampleRate = WebRtcAudioManager.getSampleRate(builder.audioManager);
        }

        public Builder setSampleRate(int n) {
            Logging.d(JavaAudioDeviceModule.TAG, "Input/Output sample rate overridden to: " + n);
            this.inputSampleRate = n;
            this.outputSampleRate = n;
            return this;
        }

        public Builder setInputSampleRate(int n) {
            Logging.d(JavaAudioDeviceModule.TAG, "Input sample rate overridden to: " + n);
            this.inputSampleRate = n;
            return this;
        }

        public Builder setOutputSampleRate(int n) {
            Logging.d(JavaAudioDeviceModule.TAG, "Output sample rate overridden to: " + n);
            this.outputSampleRate = n;
            return this;
        }

        public Builder setAudioSource(int n) {
            this.audioSource = n;
            return this;
        }

        public Builder setAudioFormat(int n) {
            this.audioFormat = n;
            return this;
        }

        public Builder setAudioTrackErrorCallback(AudioTrackErrorCallback audioTrackErrorCallback) {
            this.audioTrackErrorCallback = audioTrackErrorCallback;
            return this;
        }

        public Builder setAudioRecordErrorCallback(AudioRecordErrorCallback audioRecordErrorCallback) {
            this.audioRecordErrorCallback = audioRecordErrorCallback;
            return this;
        }

        public Builder setSamplesReadyCallback(SamplesReadyCallback samplesReadyCallback) {
            this.samplesReadyCallback = samplesReadyCallback;
            return this;
        }

        public Builder setAudioTrackStateCallback(AudioTrackStateCallback audioTrackStateCallback) {
            this.audioTrackStateCallback = audioTrackStateCallback;
            return this;
        }

        public Builder setAudioRecordStateCallback(AudioRecordStateCallback audioRecordStateCallback) {
            this.audioRecordStateCallback = audioRecordStateCallback;
            return this;
        }

        public Builder setUseHardwareNoiseSuppressor(boolean bl) {
            if (bl && !JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported()) {
                Logging.e(JavaAudioDeviceModule.TAG, "HW NS not supported");
                bl = false;
            }
            this.useHardwareNoiseSuppressor = bl;
            return this;
        }

        public Builder setUseHardwareAcousticEchoCanceler(boolean bl) {
            if (bl && !JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported()) {
                Logging.e(JavaAudioDeviceModule.TAG, "HW AEC not supported");
                bl = false;
            }
            this.useHardwareAcousticEchoCanceler = bl;
            return this;
        }

        public Builder setUseStereoInput(boolean bl) {
            this.useStereoInput = bl;
            return this;
        }

        public Builder setUseStereoOutput(boolean bl) {
            this.useStereoOutput = bl;
            return this;
        }

        public AudioDeviceModule createAudioDeviceModule() {
            WebRtcAudioTrack webRtcAudioTrack;
            WebRtcAudioRecord webRtcAudioRecord;
            Logging.d(JavaAudioDeviceModule.TAG, "createAudioDeviceModule");
            if (builder4.useHardwareNoiseSuppressor) {
                Logging.d(JavaAudioDeviceModule.TAG, "HW NS will be used.");
            } else {
                if (JavaAudioDeviceModule.isBuiltInNoiseSuppressorSupported()) {
                    Logging.d(JavaAudioDeviceModule.TAG, "Overriding default behavior; now using WebRTC NS!");
                }
                Logging.d(JavaAudioDeviceModule.TAG, "HW NS will not be used.");
            }
            if (builder4.useHardwareAcousticEchoCanceler) {
                Logging.d(JavaAudioDeviceModule.TAG, "HW AEC will be used.");
            } else {
                if (JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported()) {
                    Logging.d(JavaAudioDeviceModule.TAG, "Overriding default behavior; now using WebRTC AEC!");
                }
                Logging.d(JavaAudioDeviceModule.TAG, "HW AEC will not be used.");
            }
            WebRtcAudioRecord webRtcAudioRecord2 = webRtcAudioRecord;
            Builder builder = builder4;
            Object object = builder.context;
            AudioManager audioManager = builder.audioManager;
            int n = builder.audioSource;
            int n2 = builder.audioFormat;
            Object object2 = builder.audioRecordErrorCallback;
            AudioRecordStateCallback audioRecordStateCallback = builder.audioRecordStateCallback;
            SamplesReadyCallback samplesReadyCallback = builder.samplesReadyCallback;
            boolean bl = builder.useHardwareAcousticEchoCanceler;
            boolean bl2 = builder.useHardwareNoiseSuppressor;
            webRtcAudioRecord = new WebRtcAudioRecord((Context)object, audioManager, n, n2, (AudioRecordErrorCallback)object2, audioRecordStateCallback, samplesReadyCallback, bl, bl2);
            object = webRtcAudioTrack;
            Builder builder2 = builder4;
            audioManager = builder2.context;
            AudioManager audioManager2 = builder2.audioManager;
            AudioTrackErrorCallback audioTrackErrorCallback = builder2.audioTrackErrorCallback;
            object2 = builder2.audioTrackStateCallback;
            webRtcAudioTrack = new WebRtcAudioTrack((Context)audioManager, audioManager2, audioTrackErrorCallback, (AudioTrackStateCallback)object2);
            Builder builder3 = builder4;
            Builder builder4 = builder3.context;
            audioManager = builder3.audioManager;
            int n3 = builder3.inputSampleRate;
            int n4 = builder3.outputSampleRate;
            boolean bl3 = builder3.useStereoInput;
            boolean bl4 = builder3.useStereoOutput;
            return new JavaAudioDeviceModule((Context)builder4, audioManager, webRtcAudioRecord2, (WebRtcAudioTrack)object, n3, n4, bl3, bl4);
        }
    }
}

