/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.EncodedImage;
import org.otwebrtc.VideoCodecStatus;
import org.otwebrtc.VideoFrame;

public interface VideoEncoder {
    @CalledByNative
    default public long createNativeVideoEncoder() {
        return 0L;
    }

    @CalledByNative
    default public boolean isHardwareEncoder() {
        return true;
    }

    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, EncodeInfo var2);

    @CalledByNative
    public VideoCodecStatus setRateAllocation(BitrateAllocation var1, int var2);

    @CalledByNative
    public ScalingSettings getScalingSettings();

    @CalledByNative
    default public ResolutionBitrateLimits[] getResolutionBitrateLimits() {
        return new ResolutionBitrateLimits[0];
    }

    @CalledByNative
    public String getImplementationName();

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);
    }

    public static class ResolutionBitrateLimits {
        public final int frameSizePixels;
        public final int minStartBitrateBps;
        public final int minBitrateBps;
        public final int maxBitrateBps;

        public ResolutionBitrateLimits(int n, int n2, int n3, int n4) {
            this.frameSizePixels = n;
            this.minStartBitrateBps = n2;
            this.minBitrateBps = n3;
            this.maxBitrateBps = n4;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getFrameSizePixels() {
            return this.frameSizePixels;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMinStartBitrateBps() {
            return this.minStartBitrateBps;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMinBitrateBps() {
            return this.minBitrateBps;
        }

        @CalledByNative(value="ResolutionBitrateLimits")
        public int getMaxBitrateBps() {
            return this.maxBitrateBps;
        }
    }

    public static class ScalingSettings {
        public static final ScalingSettings OFF = new ScalingSettings();
        public final boolean on;
        @Nullable
        public final Integer low;
        @Nullable
        public final Integer high;

        public ScalingSettings(int n, int n2) {
            this.on = true;
            this.low = n;
            this.high = n2;
        }

        private ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl) {
            this.on = bl;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean bl, int n, int n2) {
            this.on = bl;
            this.low = n;
            this.high = n2;
        }

        public String toString() {
            return this.on ? "[ " + this.low + ", " + this.high + " ]" : "OFF";
        }
    }

    public static class BitrateAllocation {
        public final int[][] bitratesBbs;

        @CalledByNative(value="BitrateAllocation")
        public BitrateAllocation(int[][] nArray) {
            this.bitratesBbs = nArray;
        }

        public int getSum() {
            int n = 0;
            int[][] nArray = this.bitratesBbs;
            int n2 = this.bitratesBbs.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int[] nArray2 = nArray[i2];
                int n3 = nArray2.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    n += nArray2[i3];
                }
            }
            return n;
        }
    }

    public static class CodecSpecificInfoH264
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP9
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfoVP8
    extends CodecSpecificInfo {
    }

    public static class CodecSpecificInfo {
    }

    public static class EncodeInfo {
        public final EncodedImage.FrameType[] frameTypes;

        @CalledByNative(value="EncodeInfo")
        public EncodeInfo(EncodedImage.FrameType[] frameTypeArray) {
            this.frameTypes = frameTypeArray;
        }
    }

    public static class Capabilities {
        public final boolean lossNotification;

        @CalledByNative(value="Capabilities")
        public Capabilities(boolean bl) {
            this.lossNotification = bl;
        }
    }

    public static class Settings {
        public final int numberOfCores;
        public final int width;
        public final int height;
        public final int startBitrate;
        public final int maxFramerate;
        public final int numberOfSimulcastStreams;
        public final boolean automaticResizeOn;
        public final Capabilities capabilities;

        @Deprecated
        public Settings(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            Capabilities capabilities;
            Settings settings = capabilities2;
            Capabilities capabilities2 = capabilities;
            capabilities = new Capabilities(false);
            settings(n, n2, n3, n4, n5, n6, bl, capabilities2);
        }

        @CalledByNative(value="Settings")
        public Settings(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Capabilities capabilities) {
            this.numberOfCores = n;
            this.width = n2;
            this.height = n3;
            this.startBitrate = n4;
            this.maxFramerate = n5;
            this.numberOfSimulcastStreams = n6;
            this.automaticResizeOn = bl;
            this.capabilities = capabilities;
        }
    }
}

