/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import org.otwebrtc.EglBase;
import org.otwebrtc.EglRenderer;
import org.otwebrtc.GlRectDrawer;
import org.otwebrtc.Logging;
import org.otwebrtc.RendererCommon;
import org.otwebrtc.SurfaceEglRenderer;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoFrame;
import org.otwebrtc.VideoSink;

public class SurfaceViewRenderer
extends SurfaceView
implements SurfaceHolder.Callback,
VideoSink,
RendererCommon.RendererEvents {
    private static final String TAG = "SurfaceViewRenderer";
    private final String resourceName;
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure;
    private final SurfaceEglRenderer eglRenderer;
    private RendererCommon.RendererEvents rendererEvents;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private boolean enableFixedSize;
    private int surfaceWidth;
    private int surfaceHeight;

    public SurfaceViewRenderer(Context object) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        super(object);
        surfaceViewRenderer.videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        object = surfaceViewRenderer.getResourceName();
        surfaceViewRenderer.resourceName = object;
        surfaceViewRenderer.eglRenderer = new SurfaceEglRenderer((String)object);
        surfaceViewRenderer.getHolder().addCallback((SurfaceHolder.Callback)this);
        surfaceViewRenderer.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    public SurfaceViewRenderer(Context object, AttributeSet attributeSet) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        super(object, attributeSet);
        surfaceViewRenderer.videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
        object = surfaceViewRenderer.getResourceName();
        surfaceViewRenderer.resourceName = object;
        surfaceViewRenderer.eglRenderer = new SurfaceEglRenderer((String)object);
        surfaceViewRenderer.getHolder().addCallback((SurfaceHolder.Callback)this);
        surfaceViewRenderer.getHolder().addCallback((SurfaceHolder.Callback)this.eglRenderer);
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
            int n;
            int n2;
            SurfaceViewRenderer surfaceViewRenderer = this;
            float f2 = (float)surfaceViewRenderer.getWidth() / (float)this.getHeight();
            int n3 = surfaceViewRenderer.rotatedFrameWidth;
            int n4 = this.rotatedFrameHeight;
            if ((float)n2 / (float)n > f2) {
                n3 = (int)((float)n4 * f2);
            } else {
                n4 = (int)((float)n3 / f2);
            }
            int n5 = Math.min(this.getWidth(), n3);
            SurfaceViewRenderer surfaceViewRenderer2 = this;
            n3 = Math.min(surfaceViewRenderer2.getHeight(), n4);
            surfaceViewRenderer2.logD("updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + n5 + "x" + n3 + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
            if (n5 != surfaceViewRenderer2.surfaceWidth || n3 != this.surfaceHeight) {
                this.surfaceWidth = n5;
                this.surfaceHeight = n3;
                this.getHolder().setFixedSize(n5, n3);
            }
        } else {
            this.surfaceHeight = 0;
            this.surfaceWidth = 0;
            this.getHolder().setSizeFromLayout();
        }
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId());
        }
        catch (Resources.NotFoundException notFoundException) {
            return "";
        }
    }

    private void postOrRun(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            this.post(runnable);
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.resourceName + ": " + string);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents) {
        GlRectDrawer glRectDrawer;
        SurfaceViewRenderer surfaceViewRenderer = object;
        Object object = EglBase.CONFIG_PLAIN;
        GlRectDrawer glRectDrawer2 = glRectDrawer;
        glRectDrawer = new GlRectDrawer();
        surfaceViewRenderer.init(context, rendererEvents, (int[])object, glRectDrawer2);
    }

    public void init(EglBase.Context context, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        this.rotatedFrameWidth = 0;
        this.rotatedFrameHeight = 0;
        this.eglRenderer.init(context, this, nArray, glDrawer);
    }

    public void release() {
        this.eglRenderer.release();
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f2, RendererCommon.GlDrawer glDrawer) {
        this.eglRenderer.addFrameListener(frameListener, f2, glDrawer);
    }

    public void addFrameListener(EglRenderer.FrameListener frameListener, float f2) {
        this.eglRenderer.addFrameListener(frameListener, f2);
    }

    public void removeFrameListener(EglRenderer.FrameListener frameListener) {
        this.eglRenderer.removeFrameListener(frameListener);
    }

    public void setEnableHardwareScaler(boolean bl) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = bl;
        this.updateSurfaceSize();
    }

    public void setMirror(boolean bl) {
        this.eglRenderer.setMirror(bl);
    }

    public void setScalingType(RendererCommon.ScalingType scalingType) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        surfaceViewRenderer.videoLayoutMeasure.setScalingType(scalingType);
        surfaceViewRenderer.requestLayout();
    }

    public void setScalingType(RendererCommon.ScalingType scalingType, RendererCommon.ScalingType scalingType2) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        surfaceViewRenderer.videoLayoutMeasure.setScalingType(scalingType, scalingType2);
        surfaceViewRenderer.requestLayout();
    }

    public void setFpsReduction(float f2) {
        this.eglRenderer.setFpsReduction(f2);
    }

    public void disableFpsReduction() {
        this.eglRenderer.disableFpsReduction();
    }

    public void pauseVideo() {
        this.eglRenderer.pauseVideo();
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        this.eglRenderer.onFrame(videoFrame);
    }

    protected void onMeasure(int n, int n2) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        int n3 = n;
        SurfaceViewRenderer surfaceViewRenderer2 = this;
        int n4 = surfaceViewRenderer2.rotatedFrameWidth;
        n = surfaceViewRenderer2.rotatedFrameHeight;
        Point point = surfaceViewRenderer.videoLayoutMeasure.measure(n3, n2, n4, n);
        n = point.x;
        surfaceViewRenderer.setMeasuredDimension(n, point.y);
        surfaceViewRenderer.logD("onMeasure(). New size: " + point.x + "x" + point.y);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        SurfaceViewRenderer surfaceViewRenderer = this;
        ThreadUtils.checkIsOnMainThread();
        surfaceViewRenderer.eglRenderer.setLayoutAspectRatio((float)(n3 - n) / (float)(n4 - n2));
        surfaceViewRenderer.updateSurfaceSize();
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.surfaceHeight = 0;
        this.surfaceWidth = 0;
        this.updateSurfaceSize();
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
    }

    public void clearImage() {
        this.eglRenderer.clearImage();
    }

    @Override
    public void onFirstFrameRendered() {
        RendererCommon.RendererEvents rendererEvents = ((SurfaceViewRenderer)rendererEvents).rendererEvents;
        if (rendererEvents != null) {
            rendererEvents.onFirstFrameRendered();
        }
    }

    @Override
    public void onFrameResolutionChanged(int n, int n2, int n3) {
        RendererCommon.RendererEvents rendererEvents = this.rendererEvents;
        if (rendererEvents != null) {
            rendererEvents.onFrameResolutionChanged(n, n2, n3);
        }
        int n4 = n3 != 0 && n3 != 180 ? n2 : n;
        if (n3 != 0 && n3 != 180) {
            n2 = n;
        }
        SurfaceViewRenderer surfaceViewRenderer = this;
        surfaceViewRenderer.postOrRun(() -> {
            SurfaceViewRenderer surfaceViewRenderer = this;
            surfaceViewRenderer.rotatedFrameWidth = n4;
            surfaceViewRenderer.rotatedFrameHeight = n2;
            surfaceViewRenderer.updateSurfaceSize();
            surfaceViewRenderer.requestLayout();
        });
    }
}

