/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.view.SurfaceHolder;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.otwebrtc.EglBase;
import org.otwebrtc.EglRenderer;
import org.otwebrtc.Logging;
import org.otwebrtc.RendererCommon;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.VideoFrame;

public class SurfaceEglRenderer
extends EglRenderer
implements SurfaceHolder.Callback {
    private static final String TAG = "SurfaceEglRenderer";
    private RendererCommon.RendererEvents rendererEvents;
    private final Object layoutLock;
    private boolean isRenderingPaused;
    private boolean isFirstFrameRendered;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;

    public SurfaceEglRenderer(String string) {
        super(string);
        Object object;
        Object object2 = object;
        object = new Object();
        v1.layoutLock = object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateFrameDimensionsAndReportEvents(VideoFrame videoFrame) {
        SurfaceEglRenderer surfaceEglRenderer = this;
        Object object = surfaceEglRenderer.layoutLock;
        synchronized (object) {
            if (surfaceEglRenderer.isRenderingPaused) {
                return;
            }
            if (!this.isFirstFrameRendered) {
                SurfaceEglRenderer surfaceEglRenderer2 = this;
                surfaceEglRenderer2.isFirstFrameRendered = true;
                surfaceEglRenderer2.logD("Reporting first rendered frame.");
                if (surfaceEglRenderer2.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != videoFrame.getRotatedWidth() || this.rotatedFrameHeight != videoFrame.getRotatedHeight() || this.frameRotation != videoFrame.getRotation()) {
                SurfaceEglRenderer surfaceEglRenderer3 = this;
                surfaceEglRenderer3.logD("Reporting frame resolution changed to " + videoFrame.getBuffer().getWidth() + "x" + videoFrame.getBuffer().getHeight() + " with rotation " + videoFrame.getRotation());
                if (surfaceEglRenderer3.rendererEvents != null) {
                    VideoFrame videoFrame2 = videoFrame;
                    int n = videoFrame2.getBuffer().getWidth();
                    int n2 = videoFrame2.getBuffer().getHeight();
                    int n3 = videoFrame2.getRotation();
                    this.rendererEvents.onFrameResolutionChanged(n, n2, n3);
                }
                this.rotatedFrameWidth = videoFrame.getRotatedWidth();
                this.rotatedFrameHeight = videoFrame.getRotatedHeight();
                this.frameRotation = videoFrame.getRotation();
            }
            return;
        }
    }

    private void logD(String string) {
        Logging.d(TAG, this.name + ": " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context object, RendererCommon.RendererEvents rendererEvents, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        EglBase.Context context = object;
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        object = this.layoutLock;
        SurfaceEglRenderer surfaceEglRenderer = this;
        synchronized (object) {
            surfaceEglRenderer.isFirstFrameRendered = false;
            surfaceEglRenderer.rotatedFrameWidth = 0;
            surfaceEglRenderer.rotatedFrameHeight = 0;
            surfaceEglRenderer.frameRotation = 0;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
            super.init(context, nArray, glDrawer);
            return;
        }
    }

    @Override
    public void init(EglBase.Context context, int[] nArray, RendererCommon.GlDrawer glDrawer) {
        this.init(context, null, nArray, glDrawer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFpsReduction(float f2) {
        Object object = this.layoutLock;
        synchronized (object) {
            boolean bl = f2 == 0.0f;
            this.isRenderingPaused = bl;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var2_2
            super.setFpsReduction(f2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableFpsReduction() {
        SurfaceEglRenderer surfaceEglRenderer = this;
        Object object = surfaceEglRenderer.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = false;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            super.disableFpsReduction();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseVideo() {
        SurfaceEglRenderer surfaceEglRenderer = this;
        Object object = surfaceEglRenderer.layoutLock;
        synchronized (object) {
            this.isRenderingPaused = true;
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var1_1
            super.pauseVideo();
            return;
        }
    }

    @Override
    public void onFrame(VideoFrame videoFrame) {
        SurfaceEglRenderer surfaceEglRenderer = this;
        surfaceEglRenderer.updateFrameDimensionsAndReportEvents(videoFrame);
        super.onFrame(videoFrame);
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        this.createEglSurface(surfaceHolder.getSurface());
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Objects.requireNonNull(countDownLatch);
        this.releaseEglSurface(countDownLatch::countDown);
        ThreadUtils.awaitUninterruptibly(countDownLatch);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
        ThreadUtils.checkIsOnMainThread();
        this.logD("surfaceChanged: format: " + n + " size: " + n2 + "x" + n3);
    }
}

