/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.support.annotation.Nullable;
import java.util.List;
import java.util.Map;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.MediaStreamTrack;

public class RtpParameters {
    public final String transactionId;
    @Nullable
    public DegradationPreference degradationPreference;
    private final Rtcp rtcp;
    private final List<HeaderExtension> headerExtensions;
    public final List<Encoding> encodings;
    public final List<Codec> codecs;

    @CalledByNative
    RtpParameters(String string, DegradationPreference degradationPreference, Rtcp rtcp, List<HeaderExtension> list, List<Encoding> list2, List<Codec> list3) {
        this.transactionId = string;
        this.degradationPreference = degradationPreference;
        this.rtcp = rtcp;
        this.headerExtensions = list;
        this.encodings = list2;
        this.codecs = list3;
    }

    @CalledByNative
    String getTransactionId() {
        return this.transactionId;
    }

    @CalledByNative
    DegradationPreference getDegradationPreference() {
        return this.degradationPreference;
    }

    @CalledByNative
    public Rtcp getRtcp() {
        return this.rtcp;
    }

    @CalledByNative
    public List<HeaderExtension> getHeaderExtensions() {
        return this.headerExtensions;
    }

    @CalledByNative
    List<Encoding> getEncodings() {
        return this.encodings;
    }

    @CalledByNative
    List<Codec> getCodecs() {
        return this.codecs;
    }

    public static class HeaderExtension {
        private final String uri;
        private final int id;
        private final boolean encrypted;

        @CalledByNative(value="HeaderExtension")
        HeaderExtension(String string, int n, boolean bl) {
            this.uri = string;
            this.id = n;
            this.encrypted = bl;
        }

        @CalledByNative(value="HeaderExtension")
        public String getUri() {
            return this.uri;
        }

        @CalledByNative(value="HeaderExtension")
        public int getId() {
            return this.id;
        }

        @CalledByNative(value="HeaderExtension")
        public boolean getEncrypted() {
            return this.encrypted;
        }
    }

    public static class Rtcp {
        private final String cname;
        private final boolean reducedSize;

        @CalledByNative(value="Rtcp")
        Rtcp(String string, boolean bl) {
            this.cname = string;
            this.reducedSize = bl;
        }

        @CalledByNative(value="Rtcp")
        public String getCname() {
            return this.cname;
        }

        @CalledByNative(value="Rtcp")
        public boolean getReducedSize() {
            return this.reducedSize;
        }
    }

    public static class Codec {
        public int payloadType;
        public String name;
        MediaStreamTrack.MediaType kind;
        public Integer clockRate;
        public Integer numChannels;
        public Map<String, String> parameters;

        @CalledByNative(value="Codec")
        Codec(int n, String string, MediaStreamTrack.MediaType mediaType, Integer n2, Integer n3, Map<String, String> map) {
            this.payloadType = n;
            this.name = string;
            this.kind = mediaType;
            this.clockRate = n2;
            this.numChannels = n3;
            this.parameters = map;
        }

        @CalledByNative(value="Codec")
        int getPayloadType() {
            return this.payloadType;
        }

        @CalledByNative(value="Codec")
        String getName() {
            return this.name;
        }

        @CalledByNative(value="Codec")
        MediaStreamTrack.MediaType getKind() {
            return this.kind;
        }

        @CalledByNative(value="Codec")
        Integer getClockRate() {
            return this.clockRate;
        }

        @CalledByNative(value="Codec")
        Integer getNumChannels() {
            return this.numChannels;
        }

        @CalledByNative(value="Codec")
        Map getParameters() {
            return this.parameters;
        }
    }

    public static class Encoding {
        @Nullable
        public String rid;
        public boolean active = true;
        public double bitratePriority = 1.0;
        public int networkPriority = 1;
        @Nullable
        public Integer maxBitrateBps;
        @Nullable
        public Integer minBitrateBps;
        @Nullable
        public Integer maxFramerate;
        @Nullable
        public Integer numTemporalLayers;
        @Nullable
        public Double scaleResolutionDownBy;
        public Long ssrc;

        public Encoding(String string, boolean bl, Double d2) {
            this.rid = string;
            this.active = bl;
            this.scaleResolutionDownBy = d2;
        }

        @CalledByNative(value="Encoding")
        Encoding(String string, boolean bl, double d2, int n, Integer n2, Integer n3, Integer n4, Integer n5, Double d3, Long l) {
            this.rid = string;
            this.active = bl;
            this.bitratePriority = d2;
            this.networkPriority = n;
            this.maxBitrateBps = n2;
            this.minBitrateBps = n3;
            this.maxFramerate = n4;
            this.numTemporalLayers = n5;
            this.scaleResolutionDownBy = d3;
            this.ssrc = l;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        String getRid() {
            return this.rid;
        }

        @CalledByNative(value="Encoding")
        boolean getActive() {
            return this.active;
        }

        @CalledByNative(value="Encoding")
        double getBitratePriority() {
            return this.bitratePriority;
        }

        @CalledByNative(value="Encoding")
        int getNetworkPriority() {
            return this.networkPriority;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getMaxBitrateBps() {
            return this.maxBitrateBps;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getMinBitrateBps() {
            return this.minBitrateBps;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getMaxFramerate() {
            return this.maxFramerate;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getNumTemporalLayers() {
            return this.numTemporalLayers;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Double getScaleResolutionDownBy() {
            return this.scaleResolutionDownBy;
        }

        @CalledByNative(value="Encoding")
        Long getSsrc() {
            return this.ssrc;
        }
    }

    public static final class DegradationPreference
    extends Enum<DegradationPreference> {
        public static final /* enum */ DegradationPreference DISABLED;
        public static final /* enum */ DegradationPreference MAINTAIN_FRAMERATE;
        public static final /* enum */ DegradationPreference MAINTAIN_RESOLUTION;
        public static final /* enum */ DegradationPreference BALANCED;
        private static final /* synthetic */ DegradationPreference[] $VALUES;

        public static DegradationPreference[] values() {
            return (DegradationPreference[])$VALUES.clone();
        }

        public static DegradationPreference valueOf(String string) {
            return Enum.valueOf(DegradationPreference.class, string);
        }

        @CalledByNative(value="DegradationPreference")
        static DegradationPreference fromNativeIndex(int n) {
            return DegradationPreference.values()[n];
        }

        static {
            DegradationPreference degradationPreference;
            DISABLED = new DegradationPreference();
            MAINTAIN_FRAMERATE = new DegradationPreference();
            MAINTAIN_RESOLUTION = new DegradationPreference();
            DegradationPreference degradationPreference2 = degradationPreference;
            BALANCED = new DegradationPreference();
            $VALUES = new DegradationPreference[]{DISABLED, MAINTAIN_FRAMERATE, MAINTAIN_RESOLUTION, degradationPreference2};
        }
    }
}

