/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.media.MediaCodecInfo;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import org.otwebrtc.H264Utils;
import org.otwebrtc.VideoCodecMimeType;

class MediaCodecUtils {
    private static final String TAG = "MediaCodecUtils";
    static final String EXYNOS_PREFIX = "OMX.Exynos.";
    static final String INTEL_PREFIX = "OMX.Intel.";
    static final String NVIDIA_PREFIX = "OMX.Nvidia.";
    static final String QCOM_PREFIX = "OMX.qcom.";
    static final String[] SOFTWARE_IMPLEMENTATION_PREFIXES = new String[]{"OMX.google.", "OMX.SEC."};
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar32m4ka = 2141391873;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar16m4ka = 2141391874;
    static final int COLOR_QCOM_FORMATYVU420PackedSemiPlanar64x32Tile2m8ka = 2141391875;
    static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    static final int[] DECODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391873, 2141391874, 2141391875, 2141391876};
    static final int[] ENCODER_COLOR_FORMATS = new int[]{19, 21, 2141391872, 2141391876};
    static final int[] TEXTURE_COLOR_FORMATS = MediaCodecUtils.getTextureColorFormats();

    private static int[] getTextureColorFormats() {
        if (Build.VERSION.SDK_INT >= 18) {
            return new int[]{2130708361};
        }
        return new int[0];
    }

    @Nullable
    static Integer selectColorFormat(int[] nArray, MediaCodecInfo.CodecCapabilities codecCapabilities) {
        for (int n : nArray) {
            int[] nArray2 = codecCapabilities.colorFormats;
            int n2 = codecCapabilities.colorFormats.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = nArray2[i2];
                if (n3 != n) continue;
                return n3;
            }
        }
        return null;
    }

    static boolean codecSupportsType(MediaCodecInfo stringArray, VideoCodecMimeType videoCodecMimeType) {
        for (String string : stringArray.getSupportedTypes()) {
            if (!videoCodecMimeType.mimeType().equals(string)) continue;
            return true;
        }
        return false;
    }

    static Map<String, String> getCodecProperties(VideoCodecMimeType videoCodecMimeType, boolean bl) {
        int n = 1.$SwitchMap$org$otwebrtc$VideoCodecMimeType[videoCodecMimeType.ordinal()];
        if (n != 1 && n != 2) {
            if (n == 3) {
                return H264Utils.getDefaultH264Params(bl);
            }
            throw new IllegalArgumentException("Unsupported codec: " + (Object)((Object)videoCodecMimeType));
        }
        return new HashMap<String, String>();
    }

    private MediaCodecUtils() {
    }
}

