/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.media.MediaRecorder;
import org.otwebrtc.Logging;
import org.otwebrtc.SurfaceTextureHelper;
import org.otwebrtc.VideoCapturer;

public interface CameraVideoCapturer
extends VideoCapturer {
    public void switchCamera(CameraSwitchHandler var1);

    public void switchCamera(CameraSwitchHandler var1, String var2);

    @Deprecated
    default public void addMediaRecorderToCamera(MediaRecorder mediaRecorder, MediaRecorderHandler mediaRecorderHandler) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }

    @Deprecated
    default public void removeMediaRecorderFromCamera(MediaRecorderHandler mediaRecorderHandler) {
        throw new UnsupportedOperationException("Deprecated and not implemented.");
    }

    public static class CameraStatistics {
        private static final String TAG = "CameraStatistics";
        private static final int CAMERA_OBSERVER_PERIOD_MS = 2000;
        private static final int CAMERA_FREEZE_REPORT_TIMOUT_MS = 4000;
        private final SurfaceTextureHelper surfaceTextureHelper;
        private final CameraEventsHandler eventsHandler;
        private int frameCount;
        private int freezePeriodCount;
        private final Runnable cameraObserver;

        public CameraStatistics(SurfaceTextureHelper surfaceTextureHelper, CameraEventsHandler cameraEventsHandler) {
            Runnable runnable;
            Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    Logging.d(CameraStatistics.TAG, "Camera fps: " + Math.round((float)frameCount * 1000.0f / 2000.0f) + ".");
                    if (frameCount == 0) {
                        1 v1 = this;
                        ++freezePeriodCount;
                        if (freezePeriodCount * 2000 >= 4000 && eventsHandler != null) {
                            Logging.e(CameraStatistics.TAG, "Camera freezed.");
                            if (surfaceTextureHelper.isTextureInUse()) {
                                eventsHandler.onCameraFreezed("Camera failure. Client must return video buffers.");
                            } else {
                                eventsHandler.onCameraFreezed("Camera failure.");
                            }
                            return;
                        }
                    } else {
                        CameraStatistics.access$102(this, 0);
                    }
                    1 v2 = this;
                    CameraStatistics.access$002(v2.this, 0);
                    surfaceTextureHelper.getHandler().postDelayed((Runnable)this, 2000L);
                }
            };
            this.cameraObserver = runnable2;
            if (surfaceTextureHelper != null) {
                CameraStatistics cameraStatistics = this;
                this.surfaceTextureHelper = surfaceTextureHelper;
                cameraStatistics.eventsHandler = cameraEventsHandler;
                cameraStatistics.frameCount = 0;
                cameraStatistics.freezePeriodCount = 0;
                surfaceTextureHelper.getHandler().postDelayed(this.cameraObserver, 2000L);
                return;
            }
            throw new IllegalArgumentException("SurfaceTextureHelper is null");
        }

        private void checkThread() {
            if (Thread.currentThread() == this.surfaceTextureHelper.getHandler().getLooper().getThread()) {
                return;
            }
            throw new IllegalStateException("Wrong thread");
        }

        static /* synthetic */ int access$102(CameraStatistics cameraStatistics, int n) {
            cameraStatistics.freezePeriodCount = n;
            return n;
        }

        static /* synthetic */ int access$002(CameraStatistics cameraStatistics, int n) {
            cameraStatistics.frameCount = n;
            return n;
        }

        public void addFrame() {
            CameraStatistics cameraStatistics = this;
            cameraStatistics.checkThread();
            ++cameraStatistics.frameCount;
        }

        public void release() {
            this.surfaceTextureHelper.getHandler().removeCallbacks(this.cameraObserver);
        }
    }

    @Deprecated
    public static interface MediaRecorderHandler {
        public void onMediaRecorderSuccess();

        public void onMediaRecorderError(String var1);
    }

    public static interface CameraSwitchHandler {
        public void onCameraSwitchDone(boolean var1);

        public void onCameraSwitchError(String var1);
    }

    public static interface CameraEventsHandler {
        public void onCameraError(String var1);

        public void onCameraDisconnected();

        public void onCameraFreezed(String var1);

        public void onCameraOpening(String var1);

        public void onFirstFrameAvailable();

        public void onCameraClosed();
    }
}

