/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.List;
import org.otwebrtc.CameraEnumerator;
import org.otwebrtc.CameraSession;
import org.otwebrtc.CameraVideoCapturer;
import org.otwebrtc.CapturerObserver;
import org.otwebrtc.Logging;
import org.otwebrtc.SurfaceTextureHelper;
import org.otwebrtc.VideoFrame;

abstract class CameraCapturer
implements CameraVideoCapturer {
    private static final String TAG = "CameraCapturer";
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private static final int OPEN_CAMERA_TIMEOUT = 10000;
    private final CameraEnumerator cameraEnumerator;
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private final Handler uiThreadHandler;
    @Nullable
    private final CameraSession.CreateSessionCallback createSessionCallback = new CameraSession.CreateSessionCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void onDone(CameraSession var1_1) {
            v0 = this;
            CameraCapturer.access$000(v0.CameraCapturer.this);
            Logging.d("CameraCapturer", "Create session done. Switch state: " + (Object)CameraCapturer.access$100(CameraCapturer.this));
            CameraCapturer.access$300(v0.CameraCapturer.this).removeCallbacks(CameraCapturer.access$200(CameraCapturer.this));
            var2_2 = CameraCapturer.access$400(v0.CameraCapturer.this);
            synchronized (var2_2) {
                block16: {
                    CameraCapturer.access$500(v0.CameraCapturer.this).onCapturerStarted(true);
                    CameraCapturer.access$602(v0.CameraCapturer.this, false);
                    CameraCapturer.access$702(v0.CameraCapturer.this, (CameraSession)var1_1);
                    CameraCapturer.access$802(v0.CameraCapturer.this, new CameraVideoCapturer.CameraStatistics(CameraCapturer.access$900(CameraCapturer.this), CameraCapturer.access$1000(CameraCapturer.this)));
                    CameraCapturer.access$1102(v0.CameraCapturer.this, false);
                    CameraCapturer.access$400(v0.CameraCapturer.this).notifyAll();
                    if (CameraCapturer.access$100(v0.CameraCapturer.this) != SwitchState.IN_PROGRESS) break block16;
                    v2 = this;
                    v3 = v2;
                    CameraCapturer.access$102(v2.CameraCapturer.this, SwitchState.IDLE);
                    ** if (CameraCapturer.access$1200((CameraCapturer)v3.CameraCapturer.this) == null) goto lbl37
lbl-1000:
                    // 1 sources

                    {
                        v4 = this;
                        CameraCapturer.access$1200(v4.CameraCapturer.this).onCameraSwitchDone(CameraCapturer.access$1400(CameraCapturer.this).isFrontFacing(CameraCapturer.access$1300(CameraCapturer.this)));
                        CameraCapturer.access$1202(v4.CameraCapturer.this, null);
                    }
lbl37:
                    // 2 sources

                    ** GOTO lbl55
                }
                if (CameraCapturer.access$100(CameraCapturer.this) != SwitchState.PENDING) ** GOTO lbl55
                v5 = this;
                v6 = v5;
                v7 = v5;
                v8 = v5;
                var1_1 = CameraCapturer.access$1500(v5.CameraCapturer.this);
                CameraCapturer.access$1502(v6.CameraCapturer.this, null);
                CameraCapturer.access$102(v7.CameraCapturer.this, SwitchState.IDLE);
                CameraCapturer.access$1600(v8.CameraCapturer.this, CameraCapturer.access$1200(CameraCapturer.this), (String)var1_1);
lbl55:
                // 3 sources

                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void onFailure(CameraSession.FailureType var1_1, String var2_2) {
            v0 = this;
            CameraCapturer.access$000(v0.CameraCapturer.this);
            CameraCapturer.access$300(v0.CameraCapturer.this).removeCallbacks(CameraCapturer.access$200(CameraCapturer.this));
            var3_3 = CameraCapturer.access$400(v0.CameraCapturer.this);
            synchronized (var3_3) {
                block12: {
                    block13: {
                        block14: {
                            CameraCapturer.access$500(v0.CameraCapturer.this).onCapturerStarted(false);
                            CameraCapturer.access$1710(v0.CameraCapturer.this);
                            if (CameraCapturer.access$1700(v0.CameraCapturer.this) > 0) break block12;
                            v2 = this;
                            Logging.w("CameraCapturer", "Opening camera failed, passing: " + var2_2);
                            CameraCapturer.access$602(v2.CameraCapturer.this, false);
                            CameraCapturer.access$400(v2.CameraCapturer.this).notifyAll();
                            if (CameraCapturer.access$100(v2.CameraCapturer.this) == SwitchState.IDLE) break block13;
                            if (CameraCapturer.access$1200(CameraCapturer.this) == null) break block14;
                            v3 = this;
                            CameraCapturer.access$1200(v3.CameraCapturer.this).onCameraSwitchError(var2_2);
                            CameraCapturer.access$1202(v3.CameraCapturer.this, null);
                        }
                        CameraCapturer.access$102(CameraCapturer.this, SwitchState.IDLE);
                    }
                    if (var1_1 != CameraSession.FailureType.DISCONNECTED) ** GOTO lbl39
                    CameraCapturer.access$1000(CameraCapturer.this).onCameraDisconnected();
                    ** GOTO lbl45
lbl39:
                    // 1 sources

                    CameraCapturer.access$1000(CameraCapturer.this).onCameraError(var2_2);
                    ** GOTO lbl45
                }
                Logging.w("CameraCapturer", "Opening camera failed, retry: " + var2_2);
                CameraCapturer.access$1800(CameraCapturer.this, 500);
lbl45:
                // 3 sources

                return;
            }
        }
    };
    @Nullable
    private final CameraSession.Events cameraSessionEventsHandler = new CameraSession.Events(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCameraOpening() {
            2 v0 = this;
            v0.CameraCapturer.this.checkIsOnCameraThread();
            Object object = v0.CameraCapturer.this.stateLock;
            synchronized (object) {
                if (v0.CameraCapturer.this.currentSession != null) {
                    Logging.w(CameraCapturer.TAG, "onCameraOpening while session was open.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraOpening(CameraCapturer.this.cameraName);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCameraError(CameraSession object, String string) {
            Object object2 = object;
            2 v1 = this;
            v1.CameraCapturer.this.checkIsOnCameraThread();
            object = v1.CameraCapturer.this.stateLock;
            synchronized (object) {
                if (object2 != v1.CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraError from another session: " + string);
                    return;
                }
                2 v2 = this;
                v2.CameraCapturer.this.eventsHandler.onCameraError(string);
                v2.CameraCapturer.this.stopCapture();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCameraDisconnected(CameraSession object) {
            Object object2 = object;
            2 v1 = this;
            v1.CameraCapturer.this.checkIsOnCameraThread();
            object = v1.CameraCapturer.this.stateLock;
            synchronized (object) {
                if (object2 != v1.CameraCapturer.this.currentSession) {
                    Logging.w(CameraCapturer.TAG, "onCameraDisconnected from another session.");
                    return;
                }
                2 v2 = this;
                v2.CameraCapturer.this.eventsHandler.onCameraDisconnected();
                v2.CameraCapturer.this.stopCapture();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onCameraClosed(CameraSession object) {
            Object object2 = object;
            2 v1 = this;
            v1.CameraCapturer.this.checkIsOnCameraThread();
            object = v1.CameraCapturer.this.stateLock;
            synchronized (object) {
                if (object2 != v1.CameraCapturer.this.currentSession && CameraCapturer.this.currentSession != null) {
                    Logging.d(CameraCapturer.TAG, "onCameraClosed from another session.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraClosed();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onFrameCaptured(CameraSession object, VideoFrame videoFrame) {
            Object object2 = object;
            2 v1 = this;
            v1.CameraCapturer.this.checkIsOnCameraThread();
            object = v1.CameraCapturer.this.stateLock;
            synchronized (object) {
                block6: {
                    if (object2 != v1.CameraCapturer.this.currentSession) {
                        Logging.w(CameraCapturer.TAG, "onFrameCaptured from another session.");
                        return;
                    }
                    if (CameraCapturer.this.firstFrameObserved) break block6;
                    2 v2 = this;
                    v2.CameraCapturer.this.eventsHandler.onFirstFrameAvailable();
                    CameraCapturer.access$1102(v2.CameraCapturer.this, true);
                }
                2 v4 = this;
                v4.CameraCapturer.this.cameraStatistics.addFrame();
                v4.CameraCapturer.this.capturerObserver.onFrameCaptured(videoFrame);
                return;
            }
        }
    };
    private final Runnable openCameraTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            CameraCapturer.this.eventsHandler.onCameraError("Camera failed to start within timeout.");
        }
    };
    private Handler cameraThreadHandler;
    private Context applicationContext;
    private CapturerObserver capturerObserver;
    private SurfaceTextureHelper surfaceHelper;
    private final Object stateLock = new Object();
    private boolean sessionOpening;
    @Nullable
    private CameraSession currentSession;
    private String cameraName;
    private String pendingCameraName;
    private int width;
    private int height;
    private int framerate;
    private int openAttemptsRemaining;
    private SwitchState switchState = SwitchState.IDLE;
    @Nullable
    private CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    @Nullable
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private boolean firstFrameObserved;

    public CameraCapturer(String object, @Nullable CameraVideoCapturer.CameraEventsHandler cameraEventsHandler, CameraEnumerator cameraEnumerator) {
        if (cameraEventsHandler == null) {
            CameraVideoCapturer.CameraEventsHandler cameraEventsHandler2;
            cameraEventsHandler = cameraEventsHandler2;
            cameraEventsHandler2 = new CameraVideoCapturer.CameraEventsHandler(){

                @Override
                public void onCameraError(String string) {
                }

                @Override
                public void onCameraDisconnected() {
                }

                @Override
                public void onCameraFreezed(String string) {
                }

                @Override
                public void onCameraOpening(String string) {
                }

                @Override
                public void onFirstFrameAvailable() {
                }

                @Override
                public void onCameraClosed() {
                }
            };
        }
        this.eventsHandler = cameraEventsHandler;
        this.cameraEnumerator = cameraEnumerator;
        this.cameraName = object;
        object = Arrays.asList(cameraEnumerator.getDeviceNames());
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        if (!object.isEmpty()) {
            if (object.contains(this.cameraName)) {
                return;
            }
            throw new IllegalArgumentException("Camera name " + this.cameraName + " does not match any known camera device.");
        }
        throw new RuntimeException("No cameras attached.");
    }

    private void createSessionInternal(int n) {
        Runnable runnable;
        CameraCapturer cameraCapturer = this;
        Runnable runnable2 = this.openCameraTimeoutRunnable;
        long l = n + 10000;
        cameraCapturer.uiThreadHandler.postDelayed(runnable2, l);
        Runnable runnable3 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                CameraCapturer cameraCapturer = events.CameraCapturer.this;
                5 v1 = events;
                CameraSession.Events events = v1.CameraCapturer.this.cameraSessionEventsHandler;
                Context context = v1.CameraCapturer.this.applicationContext;
                SurfaceTextureHelper surfaceTextureHelper = v1.CameraCapturer.this.surfaceHelper;
                String string = v1.CameraCapturer.this.cameraName;
                int n = v1.CameraCapturer.this.width;
                int n2 = v1.CameraCapturer.this.height;
                int n3 = v1.CameraCapturer.this.framerate;
                cameraCapturer.createCameraSession(cameraCapturer.createSessionCallback, events, context, surfaceTextureHelper, string, n, n2, n3);
            }
        };
        long l2 = n;
        cameraCapturer.cameraThreadHandler.postDelayed(runnable3, l2);
    }

    private void reportCameraSwitchError(String string, @Nullable CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.e(TAG, string);
        if (cameraSwitchHandler != null) {
            cameraSwitchHandler.onCameraSwitchError(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void switchCameraInternal(@Nullable CameraVideoCapturer.CameraSwitchHandler object, String string) {
        Logging.d(TAG, "switchCamera internal");
        if (!Arrays.asList(this.cameraEnumerator.getDeviceNames()).contains(string)) {
            this.reportCameraSwitchError("Attempted to switch to unknown camera device " + string, (CameraVideoCapturer.CameraSwitchHandler)object);
            return;
        }
        CameraCapturer cameraCapturer = this;
        Object object2 = cameraCapturer.stateLock;
        synchronized (object2) {
            if (cameraCapturer.switchState != SwitchState.IDLE) {
                this.reportCameraSwitchError("Camera switch already in progress.", (CameraVideoCapturer.CameraSwitchHandler)object);
                return;
            }
            if (!this.sessionOpening && this.currentSession == null) {
                this.reportCameraSwitchError("switchCamera: camera is not running.", (CameraVideoCapturer.CameraSwitchHandler)object);
                return;
            }
            this.switchEventsHandler = object;
            if (this.sessionOpening) {
                this.switchState = SwitchState.PENDING;
                this.pendingCameraName = string;
                return;
            }
            Object object3 = object2;
            CameraCapturer cameraCapturer2 = this;
            CameraCapturer cameraCapturer3 = cameraCapturer2;
            CameraCapturer cameraCapturer4 = cameraCapturer2;
            CameraCapturer cameraCapturer5 = cameraCapturer2;
            CameraCapturer cameraCapturer6 = cameraCapturer2;
            String string2 = string;
            CameraCapturer cameraCapturer7 = this;
            CameraCapturer cameraCapturer8 = cameraCapturer7;
            cameraCapturer7.switchState = SwitchState.IN_PROGRESS;
            Logging.d(TAG, "switchCamera: Stopping session");
            cameraCapturer7.cameraStatistics.release();
            cameraCapturer7.cameraStatistics = null;
            object = cameraCapturer7.currentSession;
            cameraCapturer7.cameraThreadHandler.post(new Runnable((CameraSession)object){
                final /* synthetic */ CameraSession val$oldSession;
                {
                    this.val$oldSession = cameraSession;
                }

                @Override
                public void run() {
                    this.val$oldSession.stop();
                }
            });
            cameraCapturer8.currentSession = null;
            cameraCapturer3.cameraName = string2;
            cameraCapturer4.sessionOpening = true;
            cameraCapturer5.openAttemptsRemaining = 1;
            cameraCapturer6.createSessionInternal(0);
            // ** MonitorExit[v1] (shouldn't be in output)
            Logging.d(TAG, "switchCamera done");
            return;
        }
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread()) {
            return;
        }
        Logging.e(TAG, "Check is on camera thread failed.");
        throw new RuntimeException("Not on camera thread.");
    }

    static /* synthetic */ SwitchState access$100(CameraCapturer cameraCapturer) {
        return cameraCapturer.switchState;
    }

    static /* synthetic */ Runnable access$200(CameraCapturer cameraCapturer) {
        return cameraCapturer.openCameraTimeoutRunnable;
    }

    static /* synthetic */ Handler access$300(CameraCapturer cameraCapturer) {
        return cameraCapturer.uiThreadHandler;
    }

    static /* synthetic */ boolean access$602(CameraCapturer cameraCapturer, boolean bl) {
        cameraCapturer.sessionOpening = bl;
        return bl;
    }

    static /* synthetic */ CameraSession access$702(CameraCapturer cameraCapturer, CameraSession cameraSession) {
        cameraCapturer.currentSession = cameraSession;
        return cameraSession;
    }

    static /* synthetic */ CameraVideoCapturer.CameraStatistics access$802(CameraCapturer cameraCapturer, CameraVideoCapturer.CameraStatistics cameraStatistics) {
        cameraCapturer.cameraStatistics = cameraStatistics;
        return cameraStatistics;
    }

    static /* synthetic */ boolean access$1102(CameraCapturer cameraCapturer, boolean bl) {
        cameraCapturer.firstFrameObserved = bl;
        return bl;
    }

    static /* synthetic */ SwitchState access$102(CameraCapturer cameraCapturer, SwitchState switchState) {
        cameraCapturer.switchState = switchState;
        return switchState;
    }

    static /* synthetic */ CameraVideoCapturer.CameraSwitchHandler access$1200(CameraCapturer cameraCapturer) {
        return cameraCapturer.switchEventsHandler;
    }

    static /* synthetic */ CameraVideoCapturer.CameraSwitchHandler access$1202(CameraCapturer cameraCapturer, CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        cameraCapturer.switchEventsHandler = cameraSwitchHandler;
        return cameraSwitchHandler;
    }

    static /* synthetic */ String access$1500(CameraCapturer cameraCapturer) {
        return cameraCapturer.pendingCameraName;
    }

    static /* synthetic */ String access$1502(CameraCapturer cameraCapturer, String string) {
        cameraCapturer.pendingCameraName = string;
        return string;
    }

    static /* synthetic */ int access$1710(CameraCapturer cameraCapturer) {
        return cameraCapturer.openAttemptsRemaining--;
    }

    static /* synthetic */ int access$1700(CameraCapturer cameraCapturer) {
        return cameraCapturer.openAttemptsRemaining;
    }

    static /* synthetic */ void access$1800(CameraCapturer cameraCapturer, int n) {
        cameraCapturer.createSessionInternal(n);
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context context, CapturerObserver capturerObserver) {
        this.applicationContext = context;
        this.capturerObserver = capturerObserver;
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void startCapture(int n, int n2, int n3) {
        Logging.d(TAG, "startCapture: " + n + "x" + n2 + "@" + n3);
        if (this.applicationContext == null) {
            throw new RuntimeException("CameraCapturer must be initialized before calling startCapture.");
        }
        CameraCapturer cameraCapturer = this;
        Object object = cameraCapturer.stateLock;
        synchronized (object) {
            if (!cameraCapturer.sessionOpening && this.currentSession == null) {
                this.width = n;
                this.height = n2;
                this.framerate = n3;
                this.sessionOpening = true;
                this.openAttemptsRemaining = 3;
                this.createSessionInternal(0);
                return;
            }
            Logging.w(TAG, "Session already open");
            return;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void stopCapture() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCaptureFormat(int n, int n2, int n3) {
        Logging.d(TAG, "changeCaptureFormat: " + n + "x" + n2 + "@" + n3);
        Object object = this.stateLock;
        synchronized (object) {
            this.stopCapture();
            this.startCapture(n, n2, n3);
            return;
        }
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose");
        this.stopCapture();
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler) {
        Logging.d(TAG, "switchCamera");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                List<String> list = Arrays.asList(CameraCapturer.this.cameraEnumerator.getDeviceNames());
                if (list.size() < 2) {
                    CameraCapturer.this.reportCameraSwitchError("No camera to switch to.", cameraSwitchHandler);
                    return;
                }
                List<String> list2 = list;
                list = list2.get((list2.indexOf(CameraCapturer.this.cameraName) + 1) % list.size());
                CameraCapturer.this.switchCameraInternal(cameraSwitchHandler, (String)((Object)list));
            }
        });
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler, final String string) {
        Logging.d(TAG, "switchCamera");
        this.cameraThreadHandler.post(new Runnable(){

            @Override
            public void run() {
                8 v0 = cameraSwitchHandler2;
                CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler2 = v0.cameraSwitchHandler;
                cameraSwitchHandler2.CameraCapturer.this.switchCameraInternal(cameraSwitchHandler2, v0.string);
            }
        });
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public void printStackTrace() {
        CameraCapturer cameraCapturer = stackTraceElementArray;
        StackTraceElement[] stackTraceElementArray = null;
        Handler handler = cameraCapturer.cameraThreadHandler;
        if (handler != null) {
            stackTraceElementArray = handler.getLooper().getThread();
        }
        if (stackTraceElementArray != null && (stackTraceElementArray = stackTraceElementArray.getStackTrace()).length > 0) {
            Logging.d(TAG, "CameraCapturer stack trace:");
            int n = stackTraceElementArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                Logging.d(TAG, stackTraceElementArray[i2].toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCameraName() {
        CameraCapturer cameraCapturer = object;
        Object object = cameraCapturer.stateLock;
        synchronized (object) {
            return cameraCapturer.cameraName;
        }
    }

    protected abstract void createCameraSession(CameraSession.CreateSessionCallback var1, CameraSession.Events var2, Context var3, SurfaceTextureHelper var4, String var5, int var6, int var7, int var8);

    static final class SwitchState
    extends Enum<SwitchState> {
        public static final /* enum */ SwitchState IDLE;
        public static final /* enum */ SwitchState PENDING;
        public static final /* enum */ SwitchState IN_PROGRESS;
        private static final /* synthetic */ SwitchState[] $VALUES;

        public static SwitchState[] values() {
            return (SwitchState[])$VALUES.clone();
        }

        public static SwitchState valueOf(String string) {
            return Enum.valueOf(SwitchState.class, string);
        }

        static {
            SwitchState switchState;
            IDLE = new SwitchState();
            PENDING = new SwitchState();
            SwitchState switchState2 = switchState;
            IN_PROGRESS = new SwitchState();
            $VALUES = new SwitchState[]{IDLE, PENDING, switchState2};
        }
    }
}

