/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import android.os.SystemClock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.otwebrtc.Camera1Enumerator;
import org.otwebrtc.CameraEnumerationAndroid;
import org.otwebrtc.CameraSession;
import org.otwebrtc.Histogram;
import org.otwebrtc.Logging;
import org.otwebrtc.NV21Buffer;
import org.otwebrtc.Size;
import org.otwebrtc.SurfaceTextureHelper;
import org.otwebrtc.TextureBufferImpl;
import org.otwebrtc.VideoFrame;

class Camera1Session
implements CameraSession {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final Histogram camera1StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera1StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera1.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera1ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera1.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Camera camera;
    private final Camera.CameraInfo info;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final long constructionTimeNs;
    private SessionState state;
    private boolean firstFrameReported;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void create(CameraSession.CreateSessionCallback object, CameraSession.Events events, boolean bl, Context context, SurfaceTextureHelper surfaceTextureHelper, int n, int n2, int n3, int n4) {
        void var1_5;
        Camera camera;
        block11: {
            Camera1Session camera1Session;
            CameraEnumerationAndroid.CaptureFormat captureFormat;
            Camera.Parameters parameters;
            Camera.CameraInfo cameraInfo;
            int n5;
            Camera camera2;
            Camera camera3;
            boolean bl2;
            long l;
            block10: {
                l = System.nanoTime();
                Logging.d(TAG, "Open camera " + n);
                events.onCameraOpening();
                try {
                    camera = Camera.open((int)n);
                    if (camera != null) break block10;
                }
                catch (RuntimeException runtimeException) {
                    object = CameraSession.FailureType.ERROR;
                    object.onFailure((CameraSession.FailureType)((Object)object), runtimeException.getMessage());
                    return;
                }
                object.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + n);
                return;
            }
            try {
                bl2 = bl;
                Camera camera4 = camera;
                camera3 = camera4;
                camera2 = camera4;
                n5 = n;
                camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
            }
            catch (RuntimeException runtimeException) {
                break block11;
            }
            catch (IOException iOException) {
                // empty catch block
                break block11;
            }
            Camera.CameraInfo cameraInfo2 = cameraInfo;
            Camera.getCameraInfo((int)n5, (Camera.CameraInfo)new Camera.CameraInfo());
            try {
                parameters = camera3.getParameters();
            }
            catch (RuntimeException runtimeException) {
                CameraSession.CreateSessionCallback createSessionCallback = object;
                camera.release();
                object = CameraSession.FailureType.ERROR;
                createSessionCallback.onFailure((CameraSession.FailureType)((Object)object), runtimeException.getMessage());
                return;
            }
            {
                captureFormat = Camera1Session.findClosestCaptureFormat(parameters, n2, n3, n4);
                Camera1Session.updateCameraParameters(camera2, parameters, captureFormat, Camera1Session.findClosestPictureSize(parameters, n2, n3), bl);
            }
            if (!bl2) {
                n3 = captureFormat.frameSize();
                for (n4 = 0; n4 < 3; ++n4) {
                    camera.addCallbackBuffer(ByteBuffer.allocateDirect(n3).array());
                }
            }
            CameraSession.CreateSessionCallback createSessionCallback = object;
            camera.setDisplayOrientation(0);
            object = camera1Session;
            camera1Session = new Camera1Session(events, bl, context, surfaceTextureHelper, n, camera, cameraInfo2, captureFormat, l);
            createSessionCallback.onDone((CameraSession)object);
            return;
        }
        CameraSession.CreateSessionCallback createSessionCallback = object;
        camera.release();
        object = CameraSession.FailureType.ERROR;
        createSessionCallback.onFailure((CameraSession.FailureType)((Object)object), var1_5.getMessage());
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size object, boolean bl) {
        Object object2 = object;
        CameraEnumerationAndroid.CaptureFormat captureFormat2 = captureFormat;
        object = parameters.getSupportedFocusModes();
        CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange = captureFormat.framerate;
        int n = framerateRange.min;
        parameters.setPreviewFpsRange(n, framerateRange.max);
        int n2 = captureFormat2.width;
        parameters.setPreviewSize(n2, captureFormat2.height);
        int n3 = ((Size)object2).width;
        parameters.setPictureSize(n3, ((Size)object2).height);
        if (!bl) {
            Objects.requireNonNull(captureFormat);
            parameters.setPreviewFormat(17);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (object.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters object, int n, int n2, int n3) {
        Camera.Parameters parameters = object;
        object = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + object);
        object = CameraEnumerationAndroid.getClosestSupportedFramerateRange(object, n3);
        Size size = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes()), n, n2);
        CameraEnumerationAndroid.reportCameraResolution(camera1ResolutionHistogram, size);
        Size size2 = size;
        int n4 = size2.width;
        return new CameraEnumerationAndroid.CaptureFormat(n4, size2.height, (CameraEnumerationAndroid.CaptureFormat.FramerateRange)object);
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int n, int n2) {
        return CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), n, n2);
    }

    private Camera1Session(CameraSession.Events events, boolean bl, Context context, SurfaceTextureHelper surfaceTextureHelper, int n, Camera camera, Camera.CameraInfo cameraInfo, CameraEnumerationAndroid.CaptureFormat captureFormat, long l) {
        CameraEnumerationAndroid.CaptureFormat captureFormat2 = captureFormat;
        Logging.d(TAG, "Create new camera1 session on camera " + n);
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = bl;
        this.applicationContext = context;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = n;
        this.camera = camera;
        this.info = cameraInfo;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = l;
        int n2 = captureFormat2.width;
        surfaceTextureHelper.setTextureSize(n2, captureFormat2.height);
        this.startCapturing();
    }

    private void startCapturing() {
        Camera1Session camera1Session = this;
        Logging.d(TAG, "Start capturing");
        camera1Session.checkIsOnCameraThread();
        camera1Session.state = SessionState.RUNNING;
        camera1Session.camera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int n, Camera object) {
                object = n == 100 ? "Camera server died!" : "Camera error: " + n;
                Logging.e(Camera1Session.TAG, (String)object);
                Camera1Session.this.stopInternal();
                if (n == 2) {
                    Camera1Session.this.events.onCameraDisconnected(Camera1Session.this);
                } else {
                    Camera1Session.this.events.onCameraError(Camera1Session.this, (String)object);
                }
            }
        });
        if (camera1Session.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.camera.startPreview();
        }
        catch (RuntimeException runtimeException) {
            Camera1Session camera1Session2 = this;
            camera1Session2.stopInternal();
            camera1Session2.events.onCameraError(this, runtimeException.getMessage());
        }
    }

    private void stopInternal() {
        Camera1Session camera1Session = this;
        Logging.d(TAG, "Stop internal");
        camera1Session.checkIsOnCameraThread();
        SessionState sessionState = SessionState.STOPPED;
        if (camera1Session.state == sessionState) {
            Logging.d(TAG, "Camera is already stopped");
            return;
        }
        Camera1Session camera1Session2 = this;
        camera1Session2.state = sessionState;
        camera1Session2.surfaceTextureHelper.stopListening();
        camera1Session2.camera.stopPreview();
        camera1Session2.camera.release();
        camera1Session2.events.onCameraClosed(this);
        Logging.d(TAG, "Stop done");
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(refCounted -> {
            Camera1Session camera1Session = this;
            camera1Session.checkIsOnCameraThread();
            if (camera1Session.state != SessionState.RUNNING) {
                Logging.d(TAG, "Texture frame captured but camera is no longer running.");
                return;
            }
            if (!this.firstFrameReported) {
                camera1StartTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.constructionTimeNs));
                this.firstFrameReported = true;
            }
            TextureBufferImpl textureBufferImpl = (TextureBufferImpl)refCounted.getBuffer();
            boolean bl = this.info.facing == 1;
            VideoFrame videoFrame = refCounted;
            refCounted = CameraSession.createTextureBufferWithModifiedTransformMatrix(textureBufferImpl, bl, 0);
            int n = this.getFrameOrientation();
            long l = videoFrame.getTimestampNs();
            VideoFrame videoFrame2 = new VideoFrame((VideoFrame.Buffer)((Object)refCounted), n, l);
            this.events.onFrameCaptured(this, videoFrame2);
            videoFrame2.release();
        });
    }

    private void listenForBytebufferFrames() {
        this.camera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] byArray, Camera object) {
                VideoFrame videoFrame;
                NV21Buffer nV21Buffer;
                2 v0 = this;
                v0.Camera1Session.this.checkIsOnCameraThread();
                if (object != v0.Camera1Session.this.camera) {
                    Logging.e(Camera1Session.TAG, "Callback from a different camera. This should never happen.");
                    return;
                }
                if (Camera1Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera1Session.TAG, "Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                long l = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
                if (!Camera1Session.this.firstFrameReported) {
                    camera1StartTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera1Session.this.constructionTimeNs));
                    Camera1Session.access$502(Camera1Session.this, true);
                }
                object = nV21Buffer;
                2 v2 = this;
                int n = ((Camera1Session)v2.Camera1Session.this).captureFormat.width;
                int n2 = ((Camera1Session)v2.Camera1Session.this).captureFormat.height;
                Runnable runnable = () -> Camera1Session.this.cameraThreadHandler.post(() -> {
                    if (Camera1Session.this.state == SessionState.RUNNING) {
                        Camera1Session.this.camera.addCallbackBuffer(byArray);
                    }
                });
                nV21Buffer = new NV21Buffer(byArray, n, n2, runnable);
                VideoFrame videoFrame2 = videoFrame;
                videoFrame2((VideoFrame.Buffer)object, Camera1Session.this.getFrameOrientation(), l);
                Camera1Session.this.events.onFrameCaptured(Camera1Session.this, videoFrame2);
                videoFrame.release();
            }
        });
    }

    private int getFrameOrientation() {
        Camera1Session camera1Session = this;
        int n = CameraSession.getDeviceOrientation(camera1Session.applicationContext);
        if (camera1Session.info.facing == 0) {
            n = 360 - n;
        }
        return (this.info.orientation + n) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() == this.cameraThreadHandler.getLooper().getThread()) {
            return;
        }
        throw new IllegalStateException("Wrong thread");
    }

    static /* synthetic */ boolean access$502(Camera1Session camera1Session, boolean bl) {
        camera1Session.firstFrameReported = bl;
        return bl;
    }

    @Override
    public void stop() {
        Camera1Session camera1Session = this;
        Logging.d(TAG, "Stop camera1 session on camera " + this.cameraId);
        camera1Session.checkIsOnCameraThread();
        if (camera1Session.state != SessionState.STOPPED) {
            long l = System.nanoTime();
            this.stopInternal();
            camera1StopTimeMsHistogram.addSample((int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l));
        }
    }

    private static final class SessionState
    extends Enum<SessionState> {
        public static final /* enum */ SessionState RUNNING;
        public static final /* enum */ SessionState STOPPED;
        private static final /* synthetic */ SessionState[] $VALUES;

        public static SessionState[] values() {
            return (SessionState[])$VALUES.clone();
        }

        public static SessionState valueOf(String string) {
            return Enum.valueOf(SessionState.class, string);
        }

        static {
            SessionState sessionState;
            RUNNING = new SessionState();
            SessionState sessionState2 = sessionState;
            STOPPED = new SessionState();
            $VALUES = new SessionState[]{RUNNING, sessionState2};
        }
    }
}

