/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.Matrix;
import android.view.TextureView;
import android.view.View;
import com.opentok.android.BaseVideoRenderer;
import com.opentok.android.OtLog;
import com.opentok.android.grafika.gles.EglCore;
import com.opentok.android.grafika.gles.WindowSurface;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.concurrent.locks.ReentrantLock;

class TextureViewRenderer
extends BaseVideoRenderer {
    private final OtLog.LogToken log;
    private final TextureView view;
    private Renderer renderer;
    private boolean videoLastStatus;
    private boolean detached;
    private boolean mEnableVideoFit;

    public TextureViewRenderer(Context object) {
        View.OnAttachStateChangeListener onAttachStateChangeListener;
        Renderer renderer;
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.log = new OtLog.LogToken(this);
        textureViewRenderer.detached = false;
        textureViewRenderer.mEnableVideoFit = false;
        textureViewRenderer.view = new TextureView(object);
        object = renderer;
        textureViewRenderer.renderer = new Renderer();
        textureViewRenderer.view.setSurfaceTextureListener((TextureView.SurfaceTextureListener)object);
        object = onAttachStateChangeListener;
        onAttachStateChangeListener = new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View view) {
                TextureViewRenderer.this.attachView();
            }

            public void onViewDetachedFromWindow(View view) {
                TextureViewRenderer.this.detachView();
            }
        };
        textureViewRenderer.view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)object);
        textureViewRenderer.renderer.start();
    }

    private void restartRenderer() {
        Renderer renderer;
        Renderer renderer2;
        TextureViewRenderer textureViewRenderer = this;
        Renderer renderer3 = renderer2 = renderer;
        renderer3();
        this.renderer = renderer3;
        renderer.enableVideoFit(this.mEnableVideoFit);
        textureViewRenderer.view.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this.renderer);
        textureViewRenderer.renderer.start();
    }

    private void attachView() {
        if (this.detached) {
            this.detached = false;
            this.restartRenderer();
        }
    }

    private void detachView() {
        this.detached = true;
    }

    @Override
    public void onFrame(BaseVideoRenderer.Frame frame) {
        this.renderer.displayFrame(frame);
    }

    @Override
    public void setStyle(String string, String string2) {
        if ("STYLE_VIDEO_SCALE".equals(string)) {
            if ("STYLE_VIDEO_FIT".equals(string2)) {
                this.renderer.enableVideoFit(true);
                this.mEnableVideoFit = true;
            } else if ("STYLE_VIDEO_FILL".equals(string2)) {
                this.renderer.enableVideoFit(false);
                this.mEnableVideoFit = false;
            }
        }
    }

    @Override
    public void onVideoPropertiesChanged(boolean bl) {
        this.renderer.setEnableVideo(bl);
    }

    @Override
    public View getView() {
        return this.view;
    }

    @Override
    public void onPause() {
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.videoLastStatus = textureViewRenderer.renderer.isEnableVideo();
        textureViewRenderer.renderer.setEnableVideo(false);
    }

    @Override
    public void onResume() {
        TextureViewRenderer textureViewRenderer = this;
        textureViewRenderer.renderer.setEnableVideo(this.videoLastStatus);
        if (!textureViewRenderer.renderer.isAlive()) {
            this.restartRenderer();
        }
    }

    private static class Renderer
    extends Thread
    implements TextureView.SurfaceTextureListener {
        static final float[] xyzCoords = new float[]{-1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
        static final float[] uvCoords = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
        static final int COORDS_PER_VERTEX = 3;
        static final int TEXTURECOORDS_PER_VERTEX = 2;
        private final String vertexShaderCode;
        private final String fragmentShaderCode;
        private final OtLog.LogToken log;
        final Object lock;
        EglCore eglCore;
        private boolean videoEnabled;
        private boolean videoFitEnabled;
        SurfaceTexture surfaceTexture;
        int glProgram;
        final int[] textureIds;
        final float[] scaleMatrix;
        private final short[] vertexIndex;
        private final FloatBuffer vertexBuffer;
        private final FloatBuffer textureBuffer;
        private final ShortBuffer drawListBuffer;
        private int textureWidth;
        private int textureHeight;
        private int viewportWidth;
        private int viewportHeight;
        private int previousViewPortHeight;
        private int previousViewPortWidth;
        final ReentrantLock frameLock;
        BaseVideoRenderer.Frame currentFrame;

        private Renderer() {
            ShortBuffer shortBuffer;
            Renderer renderer = this;
            renderer.vertexShaderCode = "uniform mat4 uMVPMatrix;attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = aTextureCoord;\n}\n";
            renderer.fragmentShaderCode = "precision mediump float;\nuniform sampler2D Ytex;\nuniform sampler2D Utex,Vtex;\nvarying vec2 vTextureCoord;\nvoid main(void) {\n  float nx,ny,r,g,b,y,u,v;\n  mediump vec4 txl,ux,vx;  nx=vTextureCoord[0];\n  ny=vTextureCoord[1];\n  y=texture2D(Ytex,vec2(nx,ny)).r;\n  u=texture2D(Utex,vec2(nx,ny)).r;\n  v=texture2D(Vtex,vec2(nx,ny)).r;\n  y=1.1643*(y-0.0625);\n  u=u-0.5;\n  v=v-0.5;\n  r=y+1.5958*v;\n  g=y-0.39173*u-0.81290*v;\n  b=y+2.017*u;\n  gl_FragColor=vec4(r,g,b,1.0);\n}\n";
            renderer.log = new OtLog.LogToken(this);
            renderer.lock = new Object();
            renderer.videoEnabled = true;
            renderer.videoFitEnabled = false;
            renderer.textureIds = new int[3];
            renderer.scaleMatrix = new float[16];
            renderer.vertexIndex = new short[]{0, 1, 2, 0, 2, 3};
            renderer.frameLock = new ReentrantLock();
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(xyzCoords.length * 4);
            byteBuffer.order(ByteOrder.nativeOrder());
            this.vertexBuffer = byteBuffer.asFloatBuffer();
            this.vertexBuffer.put(xyzCoords);
            renderer.vertexBuffer.position(0);
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(uvCoords.length * 4);
            byteBuffer2.order(ByteOrder.nativeOrder());
            this.textureBuffer = byteBuffer2.asFloatBuffer();
            this.textureBuffer.put(uvCoords);
            renderer.textureBuffer.position(0);
            ByteBuffer byteBuffer3 = ByteBuffer.allocateDirect(renderer.vertexIndex.length * 2);
            byteBuffer3.order(ByteOrder.nativeOrder());
            this.drawListBuffer = shortBuffer = byteBuffer3.asShortBuffer();
            shortBuffer.put(this.vertexIndex);
            renderer.drawListBuffer.position(0);
        }

        private void enableVideoFit(boolean bl) {
            this.videoFitEnabled = bl;
        }

        private void setEnableVideo(boolean bl) {
            this.videoEnabled = bl;
        }

        private boolean isEnableVideo() {
            return this.videoEnabled;
        }

        private void displayFrame(BaseVideoRenderer.Frame frame) {
            Renderer renderer = this;
            renderer.frameLock.lock();
            BaseVideoRenderer.Frame frame2 = renderer.currentFrame;
            if (frame2 != null) {
                frame2.destroy();
            }
            this.currentFrame = frame;
            this.frameLock.unlock();
        }

        /*
         * Exception decompiling
         */
        private void waitUntilSurfaceIsReady() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[UNCONDITIONALDOLOOP], 5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void updateViewportSizeIfNeeded() {
            if (this.previousViewPortWidth != this.viewportWidth || this.previousViewPortHeight != this.viewportHeight) {
                Renderer renderer = this;
                int n = renderer.viewportWidth;
                int n2 = renderer.viewportHeight;
                GLES20.glViewport((int)0, (int)0, (int)n, (int)n2);
                renderer.previousViewPortHeight = renderer.viewportHeight;
                renderer.previousViewPortWidth = renderer.viewportWidth;
            }
        }

        private void initializeTexture(int n, int n2, int n3, int n4) {
            GLES20.glActiveTexture((int)n);
            GLES20.glBindTexture((int)3553, (int)n2);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)n3, (int)n4, (int)0, (int)6409, (int)5121, null);
        }

        private void setupTextures(BaseVideoRenderer.Frame frame) {
            int[] nArray = this.textureIds;
            if (this.textureIds[0] != 0) {
                GLES20.glDeleteTextures((int)3, (int[])nArray, (int)0);
            }
            Renderer renderer = this;
            BaseVideoRenderer.Frame frame2 = frame;
            GLES20.glGenTextures((int)3, (int[])this.textureIds, (int)0);
            int n = frame2.getWidth();
            int n2 = frame2.getHeight();
            int n3 = n + 1 >> 1;
            int n4 = n2 + 1 >> 1;
            renderer.initializeTexture(33984, renderer.textureIds[0], n, n2);
            renderer.initializeTexture(33985, renderer.textureIds[1], n3, n4);
            renderer.initializeTexture(33986, renderer.textureIds[2], n3, n4);
            this.textureWidth = frame.getWidth();
            this.textureHeight = frame.getHeight();
        }

        private void updateTextures(BaseVideoRenderer.Frame frame) {
            BaseVideoRenderer.Frame frame2 = frame;
            int n = frame2.getWidth();
            int n2 = frame.getHeight();
            int n3 = n + 1 >> 1;
            int n4 = n2;
            int n5 = n4 + 1 >> 1;
            int n6 = n * n4;
            int n7 = n3 * n5;
            ByteBuffer byteBuffer = frame2.getBuffer();
            byteBuffer.clear();
            if (byteBuffer.remaining() == n6 + n7 * 2) {
                byteBuffer.position(0);
                GLES20.glPixelStorei((int)3317, (int)1);
                GLES20.glPixelStorei((int)3333, (int)1);
                GLES20.glActiveTexture((int)33984);
                GLES20.glBindTexture((int)3553, (int)this.textureIds[0]);
                GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)n, (int)n2, (int)6409, (int)5121, (Buffer)byteBuffer);
                byteBuffer.position(n6);
                GLES20.glActiveTexture((int)33985);
                GLES20.glBindTexture((int)3553, (int)this.textureIds[1]);
                GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)n3, (int)n5, (int)6409, (int)5121, (Buffer)byteBuffer);
                byteBuffer.position(n6 + n7);
                GLES20.glActiveTexture((int)33986);
                GLES20.glBindTexture((int)3553, (int)this.textureIds[2]);
                GLES20.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)n3, (int)n5, (int)6409, (int)5121, (Buffer)byteBuffer);
            } else {
                Renderer renderer = this;
                renderer.textureWidth = 0;
                renderer.textureHeight = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void renderFrameLoop(WindowSurface windowSurface) {
            while (true) {
                block9: {
                    block8: {
                        Renderer renderer;
                        Renderer renderer2 = this;
                        Object object = renderer2.lock;
                        synchronized (object) {
                            if (renderer2.surfaceTexture == null) {
                                return;
                            }
                            Renderer renderer3 = this;
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 3] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                            renderer3.frameLock.lock();
                            if (renderer3.currentFrame == null || !this.videoEnabled) break block8;
                            renderer = this;
                        }
                        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        GLES20.glClear((int)16384);
                        GLES20.glUseProgram((int)renderer.glProgram);
                        renderer.updateViewportSizeIfNeeded();
                        if (renderer.textureWidth != this.currentFrame.getWidth() || this.textureHeight != this.currentFrame.getHeight()) {
                            Renderer renderer4 = this;
                            renderer4.setupTextures(renderer4.currentFrame);
                        }
                        Renderer renderer5 = this;
                        renderer5.updateTextures(renderer5.currentFrame);
                        Matrix.setIdentityM((float[])renderer5.scaleMatrix, (int)0);
                        float f2 = 1.0f;
                        float f3 = 1.0f;
                        float f4 = (float)renderer5.currentFrame.getWidth() / (float)this.currentFrame.getHeight();
                        float f5 = (float)renderer5.viewportWidth / (float)this.viewportHeight;
                        if (renderer5.videoFitEnabled ? f4 > f5 : f4 < f5) {
                            f3 = f5 / f4;
                        } else {
                            f2 = f4 / f5;
                        }
                        Renderer renderer6 = this;
                        float[] fArray = renderer6.scaleMatrix;
                        int n = 0;
                        float f6 = renderer6.currentFrame.isMirroredX() ? -1.0f : 1.0f;
                        Renderer renderer7 = this;
                        Matrix.scaleM((float[])fArray, (int)n, (float)(f2 * f6), (float)f3, (float)1.0f);
                        float[] fArray2 = this.scaleMatrix;
                        GLES20.glUniformMatrix4fv((int)GLES20.glGetUniformLocation((int)renderer7.glProgram, (String)"uMVPMatrix"), (int)1, (boolean)false, (float[])fArray2, (int)0);
                        int n2 = renderer7.vertexIndex.length;
                        ShortBuffer shortBuffer = renderer7.drawListBuffer;
                        GLES20.glDrawElements((int)4, (int)n2, (int)5123, (Buffer)shortBuffer);
                        break block9;
                    }
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GLES20.glClear((int)16384);
                }
                this.frameLock.unlock();
                windowSurface.c();
            }
        }

        private int loadShader(int n, String string) {
            int n2 = GLES20.glCreateShader((int)n);
            GLES20.glShaderSource((int)n2, (String)string);
            GLES20.glCompileShader((int)n2);
            return n2;
        }

        private void setupgl() {
            int n;
            Renderer renderer = object;
            GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GLES20.glClear((int)16384);
            int n2 = renderer.loadShader(35633, "uniform mat4 uMVPMatrix;attribute vec4 aPosition;\nattribute vec2 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = aTextureCoord;\n}\n");
            int n3 = renderer.loadShader(35632, "precision mediump float;\nuniform sampler2D Ytex;\nuniform sampler2D Utex,Vtex;\nvarying vec2 vTextureCoord;\nvoid main(void) {\n  float nx,ny,r,g,b,y,u,v;\n  mediump vec4 txl,ux,vx;  nx=vTextureCoord[0];\n  ny=vTextureCoord[1];\n  y=texture2D(Ytex,vec2(nx,ny)).r;\n  u=texture2D(Utex,vec2(nx,ny)).r;\n  v=texture2D(Vtex,vec2(nx,ny)).r;\n  y=1.1643*(y-0.0625);\n  u=u-0.5;\n  v=v-0.5;\n  r=y+1.5958*v;\n  g=y-0.39173*u-0.81290*v;\n  b=y+2.017*u;\n  gl_FragColor=vec4(r,g,b,1.0);\n}\n");
            ((Renderer)object).glProgram = n = GLES20.glCreateProgram();
            GLES20.glAttachShader((int)n, (int)n2);
            GLES20.glAttachShader((int)renderer.glProgram, (int)n3);
            GLES20.glLinkProgram((int)renderer.glProgram);
            n2 = GLES20.glGetAttribLocation((int)renderer.glProgram, (String)"aPosition");
            int n4 = GLES20.glGetAttribLocation((int)renderer.glProgram, (String)"aTextureCoord");
            Renderer renderer2 = object;
            int n5 = n2;
            Object object = ((Renderer)object).vertexBuffer;
            GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)object);
            GLES20.glEnableVertexAttribArray((int)n5);
            object = renderer2.textureBuffer;
            GLES20.glVertexAttribPointer((int)n4, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)object);
            GLES20.glEnableVertexAttribArray((int)n4);
            GLES20.glUseProgram((int)renderer.glProgram);
            GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)renderer.glProgram, (String)"Ytex"), (int)0);
            GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)renderer.glProgram, (String)"Utex"), (int)1);
            GLES20.glUniform1i((int)GLES20.glGetUniformLocation((int)renderer.glProgram, (String)"Vtex"), (int)2);
            renderer.textureWidth = 0;
            renderer.textureHeight = 0;
        }

        @Override
        public void run() {
            WindowSurface windowSurface;
            WindowSurface windowSurface2;
            EglCore eglCore;
            Renderer renderer = this;
            renderer.waitUntilSurfaceIsReady();
            EglCore eglCore2 = eglCore;
            renderer.eglCore = new EglCore(null, 2);
            WindowSurface windowSurface3 = windowSurface2 = windowSurface;
            windowSurface3(eglCore2, this.surfaceTexture);
            windowSurface3.a();
            this.setupgl();
            this.renderFrameLoop(windowSurface2);
            windowSurface.d();
            renderer.eglCore.a();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            Object object = this.lock;
            synchronized (object) {
                this.surfaceTexture = surfaceTexture;
                this.viewportWidth = n;
                this.viewportHeight = n2;
                this.lock.notify();
                return;
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            Renderer renderer = this;
            renderer.viewportWidth = n;
            renderer.viewportHeight = n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
            object = this.lock;
            synchronized (object) {
                this.surfaceTexture = null;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            Object object = this.lock;
            synchronized (object) {
                this.surfaceTexture = surfaceTexture;
                return;
            }
        }
    }
}

