/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.opentok.android.AudioDeviceManager;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.Connection;
import com.opentok.android.DefaultAudioDevice;
import com.opentok.android.DefaultVideoCapturer;
import com.opentok.android.DefaultVideoRenderer;
import com.opentok.android.Loader;
import com.opentok.android.MuteForcedInfo;
import com.opentok.android.OpenTokConfig;
import com.opentok.android.OpentokError;
import com.opentok.android.OtLog;
import com.opentok.android.PublisherKit;
import com.opentok.android.Stream;
import com.opentok.android.SubscriberKit;
import com.opentok.android.Utils;
import com.opentok.android.VideoCaptureFactory;
import com.opentok.android.VideoRenderFactory;
import com.opentok.impl.a;
import com.opentok.otc.SWIGTYPE_p_otc_session;
import com.opentok.otc.b;
import com.opentok.otc.e;
import com.opentok.otc.g;
import com.opentok.otc.h;
import com.opentok.otc.otc_on_mute_forced_info;
import com.opentok.otc.otc_session_callbacks;
import com.opentok.otc.otc_session_capabilities;
import com.opentok.otc.otc_signal_options;
import com.opentok.otc.otc_stream_video_type;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import org.json.JSONArray;
import org.json.JSONObject;

public class Session
extends Observable {
    private static final String DEFAULT_API_URL = "https://api.opentok.com";
    private static final int VIDEO_TYPE = 0;
    private static final int AUDIO_TYPE = 1;
    protected SessionListener sessionListener;
    protected ConnectionListener connectionListener;
    protected StreamPropertiesListener streamPropertiesListener;
    protected SignalListener signalListener;
    protected ArchiveListener archiveListener;
    protected ReconnectionListener reconnectionListener;
    protected MuteListener muteListener;
    protected String apiKey;
    protected String sessionId;
    protected URL apiUrl;
    private Handler handler;
    private SWIGTYPE_p_otc_session otc_session;
    private swig_otc_session_cb session_cb;
    private boolean shouldDestroyOnFinalize;
    private final OtLog.LogToken log;

    @Deprecated
    public Session(Context context, String string, String string2) {
        SessionOptions sessionOptions;
        Session session = sessionOptions2;
        SessionOptions sessionOptions2 = sessionOptions;
        sessionOptions = new SessionOptions(){};
        session(context, string, string2, sessionOptions2);
    }

    @Deprecated
    public Session(Context context, String string, String string2, SessionOptionsProvider sessionOptionsProvider) {
        ConfigurableSessionOptions configurableSessionOptions;
        Session session = configurableSessionOptions2;
        ConfigurableSessionOptions configurableSessionOptions2 = configurableSessionOptions;
        configurableSessionOptions = new ConfigurableSessionOptions(sessionOptionsProvider.isHwDecodingSupported());
        session(context, string, string2, configurableSessionOptions2);
    }

    @Deprecated
    public Session(Context context, String string, String string2, SessionOptions sessionOptions) {
        Session session = object;
        Object object = Builder.TransportPolicy.All;
        Builder.IncludeServers includeServers = Builder.IncludeServers.All;
        Builder.IceServer[] iceServerArray = new Builder.IceServer[]{};
        session(context, string, string2, false, sessionOptions, (Builder.TransportPolicy)((Object)object), includeServers, iceServerArray, null, false, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Session(Context var1_1, String var2_3, String var3_4, boolean var4_5, SessionOptions var5_8, Builder.TransportPolicy var6_9, Builder.IncludeServers var7_11, Builder.IceServer[] var8_13, URL var9_15, boolean var10_16, String var11_18) {
        super();
        this.shouldDestroyOnFinalize = true;
        this.log = new OtLog.LogToken(this);
        if (AudioDeviceManager.getAudioDevice() == null) {
            var12_19 = v0;
            var13_21 = v1;
            v1 = new BaseAudioDevice.AudioBus(var12_19);
            new DefaultAudioDevice(var1_1 /* !! */ ).setAudioBus(var13_21);
            AudioDeviceManager.setAudioDevice(var12_19);
        }
        Utils.initOtcEngine(var1_1 /* !! */ , AudioDeviceManager.getAudioDevice(), OpenTokConfig.getJNILogs(), OpenTokConfig.getOTKitLogs(), OpenTokConfig.getWebRTCLogs(), OpenTokConfig.getDumpClientLoggingToFile());
        if (OpenTokConfig.getPreferH264Codec() != OpenTokConfig.PreferH264.NOT_SET) {
            var1_2 = OpenTokConfig.getPreferH264Codec() == OpenTokConfig.PreferH264.ENABLE;
            this.set_prefer_h264(var1_2);
        }
        var1_1 /* !! */  = e.c();
        e.a((b)var1_1 /* !! */ , (String)var11_18);
        e.a((b)var1_1 /* !! */ , (int)var4_5);
        e.b((b)var1_1 /* !! */ , (int)var10_16);
        if (var8_13.length > 0) {
            var4_6 = new String[var8_13.length];
            var10_17 = new String[var8_13.length];
            var11_18 = new String[var8_13.length];
            var12_20 = 0;
            var13_22 = var8_13.length;
            for (var14_23 = 0; var14_23 < var13_22; ++var14_23) {
                var15_24 = var8_13[var14_23];
                this.log.d("Using custom ICE server " + var15_24.toString(), new Object[0]);
                var4_6[var12_20] = var15_24.url;
                var10_17[var12_20] = var15_24.user;
                var11_18[var12_20] = var15_24.credential;
                ++var12_20;
            }
            var6_10 = var8_13.length;
            var7_12 = Builder.TransportPolicy.access$000(var6_9);
            var8_14 = Builder.IncludeServers.access$100(var7_11);
            e.a((b)var1_1 /* !! */ , var6_10, var4_6, var10_17, var11_18, var7_12, var8_14);
        }
        var4_7 = v2;
        this.session_cb = new swig_otc_session_cb(this.build_native_session_cb());
        this.otc_session = e.a(var2_3, var3_4, var4_7, (b)var1_1 /* !! */ );
        e.a((b)var1_1 /* !! */ );
        this.handler = new Handler(Looper.myLooper());
        VideoCaptureFactory.enableCamera2api(Build.VERSION.SDK_INT >= 21 && var5_8.isCamera2Capable() != false);
        VideoRenderFactory.useTextureViews(var5_8.useTextureViews());
        this.apiKey = var2_3;
        this.sessionId = var3_4;
        if (var9_15 != null) ** GOTO lbl54
        var9_15 = v3;
        try {
            v3 = new URL("https://api.opentok.com");
lbl54:
            // 2 sources

            this.apiUrl = var9_15;
        }
        catch (MalformedURLException v4) {}
    }

    Session(SWIGTYPE_p_otc_session sWIGTYPE_p_otc_session, boolean bl) {
        OtLog.LogToken logToken;
        this.shouldDestroyOnFinalize = true;
        OtLog.LogToken logToken2 = logToken;
        logToken = new OtLog.LogToken(this);
        this.log = logToken2;
        this.otc_session = sWIGTYPE_p_otc_session;
        this.shouldDestroyOnFinalize = bl;
    }

    static {
        Loader.load();
    }

    boolean isSessionConnected() {
        return e.e(this.otc_session) != null;
    }

    public Connection getConnection() {
        return new Connection(e.e(this.otc_session), true);
    }

    public String getSessionId() {
        return e.f(this.otc_session);
    }

    public void setSessionListener(SessionListener sessionListener) {
        this.sessionListener = sessionListener;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public void setStreamPropertiesListener(StreamPropertiesListener streamPropertiesListener) {
        this.streamPropertiesListener = streamPropertiesListener;
    }

    public void setSignalListener(SignalListener signalListener) {
        this.signalListener = signalListener;
    }

    public void setArchiveListener(ArchiveListener archiveListener) {
        this.archiveListener = archiveListener;
    }

    public void setReconnectionListener(ReconnectionListener reconnectionListener) {
        this.reconnectionListener = reconnectionListener;
    }

    public void setMuteListener(MuteListener muteListener) {
        this.muteListener = muteListener;
    }

    public void connect(String string) {
        Session session = this;
        session.log.d("Connect(...) called", new Object[0]);
        Object object = session.apiKey;
        if (object != null && !((String)object).isEmpty()) {
            object = this.sessionId;
            if (object != null && !((String)object).isEmpty()) {
                int n;
                int n2;
                String string2;
                Session session2 = this;
                object = session2.otc_session;
                String string3 = session2.apiUrl.getHost();
                int n3 = e.a((SWIGTYPE_p_otc_session)object, string3, string2 = session2.apiUrl.getPath(), n2 = session2.apiUrl.getPort() == -1 ? this.apiUrl.getDefaultPort() : this.apiUrl.getPort(), n = Utils.booleanToInt(this.apiUrl.getProtocol().equals("https")), string);
                if (n3 == g.c.a()) {
                    if (!(AudioDeviceManager.getAudioDevice() instanceof DefaultAudioDevice)) {
                        this.reportExternalDeviceUsage(1);
                    }
                    return;
                }
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n3));
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.InvalidSessionId.getErrorCode()));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.AuthorizationFailure.getErrorCode()));
    }

    public void disconnect() {
        Session session = this;
        session.log.d("Disconnect(...) called", new Object[0]);
        int n = e.c(session.otc_session);
        if (n == g.c.a()) {
            this.deleteObservers();
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void onPause() {
        SessionPauseResumeEvent sessionPauseResumeEvent;
        ((Session)((Object)sessionPauseResumeEvent2)).log.d("onPause() called", new Object[0]);
        BaseAudioDevice baseAudioDevice = AudioDeviceManager.getAudioDevice();
        if (baseAudioDevice != null) {
            baseAudioDevice.onPause();
        }
        Session session = sessionPauseResumeEvent2;
        session.setChanged();
        SessionPauseResumeEvent sessionPauseResumeEvent2 = sessionPauseResumeEvent;
        sessionPauseResumeEvent = new SessionPauseResumeEvent(true);
        session.notifyObservers(sessionPauseResumeEvent2);
        session.clearChanged();
    }

    public void onResume() {
        SessionPauseResumeEvent sessionPauseResumeEvent;
        ((Session)((Object)sessionPauseResumeEvent2)).log.d("onResume() called", new Object[0]);
        BaseAudioDevice baseAudioDevice = AudioDeviceManager.getAudioDevice();
        if (baseAudioDevice != null) {
            baseAudioDevice.onResume();
        }
        Session session = sessionPauseResumeEvent2;
        session.setChanged();
        SessionPauseResumeEvent sessionPauseResumeEvent2 = sessionPauseResumeEvent;
        sessionPauseResumeEvent = new SessionPauseResumeEvent(false);
        session.notifyObservers(sessionPauseResumeEvent2);
        session.clearChanged();
    }

    public void publish(PublisherKit publisherKit) {
        this.log.d("publish(...) called", new Object[0]);
        if (publisherKit != null && publisherKit.getOtcPublisher() != null) {
            if (!this.isSessionConnected()) {
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionDisconnected.getErrorCode()));
                return;
            }
            int n = e.a(this.otc_session, publisherKit.getOtcPublisher());
            if (n == g.c.a()) {
                if (!(publisherKit.getCapturer() instanceof DefaultVideoCapturer) || !(publisherKit.getRenderer() instanceof DefaultVideoRenderer)) {
                    this.reportExternalDeviceUsage(0);
                }
                this.addObserver(publisherKit);
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
    }

    public void unpublish(PublisherKit publisherKit) {
        this.log.d("unpublish(...) called", new Object[0]);
        if (publisherKit != null && publisherKit.getOtcPublisher() != null) {
            if (!this.isSessionConnected()) {
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionDisconnected.getErrorCode()));
                return;
            }
            int n = e.b(this.otc_session, publisherKit.getOtcPublisher());
            if (n == g.c.a()) {
                this.deleteObserver(publisherKit);
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
    }

    public void subscribe(SubscriberKit subscriberKit) {
        this.log.d("subscribe(...) called", new Object[0]);
        if (subscriberKit != null && subscriberKit.getOtcSubscriber() != null) {
            if (!this.isSessionConnected()) {
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionDisconnected.getErrorCode()));
                return;
            }
            int n = e.a(this.otc_session, subscriberKit.getOtcSubscriber());
            if (n == g.c.a()) {
                SubscriberKit subscriberKit2 = subscriberKit;
                subscriberKit2.attachToSession(this);
                this.addObserver(subscriberKit2);
                if (!(subscriberKit.getRenderer() instanceof DefaultVideoRenderer)) {
                    this.reportExternalDeviceUsage(0);
                }
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
    }

    public void unsubscribe(SubscriberKit subscriberKit) {
        this.log.d("unsubscribe(...) called", new Object[0]);
        if (subscriberKit != null && subscriberKit.getOtcSubscriber() != null) {
            if (!this.isSessionConnected()) {
                this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionDisconnected.getErrorCode()));
                return;
            }
            int n = e.b(this.otc_session, subscriberKit.getOtcSubscriber());
            if (n == g.c.a()) {
                this.deleteObserver(subscriberKit);
                subscriberKit.detachFromSession(this);
                return;
            }
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
    }

    public void sendSignal(String string, String string2) {
        int n = e.b(this.otc_session, string, string2);
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void sendSignal(String string, String string2, boolean bl) {
        otc_signal_options otc_signal_options2;
        otc_signal_options otc_signal_options3 = otc_signal_options2;
        otc_signal_options3();
        otc_signal_options2.a(bl ? 1 : 0);
        int n = e.a(this.otc_session, string, string2, otc_signal_options3);
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void sendSignal(String string, String string2, Connection connection) {
        int n = e.a(this.otc_session, string, string2, connection.getOtcConnection());
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void sendSignal(String string, String string2, Connection connection, boolean bl) {
        otc_signal_options otc_signal_options2;
        otc_signal_options otc_signal_options3 = otc_signal_options2;
        otc_signal_options3();
        otc_signal_options2.a(bl ? 1 : 0);
        int n = e.a(this.otc_session, string, string2, connection.getOtcConnection(), otc_signal_options3);
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities;
        otc_session_capabilities otc_session_capabilities2 = e.d(((Session)((Object)otc_session_capabilities2)).otc_session);
        Capabilities capabilities2 = capabilities;
        capabilities2();
        capabilities2.canPublish = Utils.intToBoolean(otc_session_capabilities2.c());
        capabilities.canForceMute = Utils.intToBoolean(otc_session_capabilities2.b());
        return capabilities;
    }

    public String reportIssue() {
        String string = e.b(((Session)((Object)string)).otc_session, "");
        if (string == null && string.equals("")) {
            return null;
        }
        return string;
    }

    public void forceMuteStream(@NonNull Stream stream) {
        if (stream == null) {
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, OpentokError.ErrorCode.SessionNullOrInvalidParameter.getErrorCode()));
            return;
        }
        Session session = this;
        session.log.d("forceMuteStream() called with streamID = " + stream.getStreamId(), new Object[0]);
        int n = e.a(session.otc_session, stream.getStreamId());
        if (n != g.c.a()) {
            this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
        }
    }

    public void forceMuteAll(@Nullable Iterable<Stream> stringArray) {
        int n;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        if (stringArray != null) {
            stringArray = stringArray.iterator();
            while (stringArray.hasNext()) {
                arrayList2.add(((Stream)stringArray.next()).getStreamId());
            }
        }
        if ((n = e.a(this.otc_session, stringArray = (String[])Arrays.copyOf(arrayList2.toArray(), arrayList2.size(), String[].class), arrayList2.size())) == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    public void disableForceMute() {
        int n = e.b(this.otc_session);
        if (n == g.c.a()) {
            return;
        }
        this.throwError(new a(OpentokError.Domain.SessionErrorDomain, n));
    }

    void throwError(final OpentokError opentokError) {
        if (this.sessionListener != null) {
            this.handler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    2 v0 = this;
                    synchronized (v0) {
                        if (v0.Session.this.sessionListener != null) {
                            2 v1 = this;
                            Session session = v1.Session.this;
                            Session.this.sessionListener.onError(session, v1.opentokError);
                        }
                        // ** MonitorExit[this] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    protected void onArchiveStarted(String string, String string2) {
    }

    void onArchiveStartedJNI(String string, String string2) {
        Session session = this;
        session.handler.post(() -> this.onArchiveStarted(string, string2));
        if (session.archiveListener != null) {
            this.handler.post(() -> {
                ArchiveListener archiveListener = this.archiveListener;
                if (archiveListener != null) {
                    archiveListener.onArchiveStarted(this, string, string2);
                }
            });
        }
    }

    protected void onArchiveStopped(String string) {
    }

    void onArchiveStoppedJNI(String string) {
        Session session = this;
        session.handler.post(() -> this.onArchiveStopped(string));
        if (session.archiveListener != null) {
            this.handler.post(() -> {
                ArchiveListener archiveListener = this.archiveListener;
                if (archiveListener != null) {
                    archiveListener.onArchiveStopped(this, string);
                }
            });
        }
    }

    protected void onStreamHasAudioChanged(Stream stream, int n) {
    }

    void onStreamHasAudioChangedJNI(long l, int n) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l, true);
        session.handler.post(() -> this.onStreamHasAudioChanged(stream2, n));
        if (session.streamPropertiesListener != null) {
            this.handler.post(() -> {
                StreamPropertiesListener streamPropertiesListener = this.streamPropertiesListener;
                if (streamPropertiesListener != null) {
                    n = Utils.intToBoolean(n) ? 1 : 0;
                    streamPropertiesListener.onStreamHasAudioChanged(this, stream2, n != 0);
                }
            });
        }
    }

    protected void onStreamHasVideoChanged(Stream stream, int n) {
    }

    void onStreamHasVideoChangedJNI(long l, int n) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l, true);
        session.handler.post(() -> this.onStreamHasVideoChanged(stream2, n));
        if (session.streamPropertiesListener != null) {
            this.handler.post(() -> {
                StreamPropertiesListener streamPropertiesListener = this.streamPropertiesListener;
                if (streamPropertiesListener != null) {
                    n = Utils.intToBoolean(n) ? 1 : 0;
                    streamPropertiesListener.onStreamHasVideoChanged(this, stream2, n != 0);
                }
            });
        }
    }

    protected void onStreamVideoDimensionsChanged(Stream stream, int n, int n2) {
    }

    void onStreamVideoDimensionsChangedJNI(long l, int n, int n2) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l, true);
        session.handler.post(() -> this.onStreamVideoDimensionsChanged(stream2, n, n2));
        if (session.streamPropertiesListener != null) {
            this.handler.post(() -> {
                StreamPropertiesListener streamPropertiesListener = this.streamPropertiesListener;
                if (streamPropertiesListener != null) {
                    streamPropertiesListener.onStreamVideoDimensionsChanged(this, stream2, n, n2);
                }
            });
        }
    }

    protected void onStreamVideoTypeChanged(Stream stream, int n) {
    }

    void onStreamVideoTypeChangedJNI(long l, int n) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l, true);
        session.handler.post(() -> this.onStreamVideoTypeChanged(stream2, n));
        if (session.streamPropertiesListener != null) {
            this.handler.post(() -> {
                StreamPropertiesListener streamPropertiesListener = this.streamPropertiesListener;
                if (streamPropertiesListener != null) {
                    streamPropertiesListener.onStreamVideoTypeChanged(this, stream2, Stream.StreamVideoType.fromSwig(otc_stream_video_type.a(n)));
                }
            });
        }
    }

    protected void onConnectionCreated(Connection connection) {
    }

    void onConnectionCreatedJNI(long l) {
        Connection connection;
        Session session = this;
        Connection connection2 = connection;
        connection = new Connection(l, true);
        session.handler.post(() -> this.onConnectionCreated(connection2));
        if (session.connectionListener != null) {
            this.handler.post(() -> {
                ConnectionListener connectionListener = this.connectionListener;
                if (connectionListener != null) {
                    connectionListener.onConnectionCreated(this, connection2);
                }
            });
        }
    }

    protected void onConnectionDestroyed(Connection connection) {
    }

    void onConnectionDroppedJNI(long l) {
        Connection connection;
        Session session = this;
        Connection connection2 = connection;
        connection = new Connection(l, true);
        session.handler.post(() -> this.onConnectionDestroyed(connection2));
        if (session.connectionListener != null) {
            this.handler.post(() -> {
                ConnectionListener connectionListener = this.connectionListener;
                if (connectionListener != null) {
                    connectionListener.onConnectionDestroyed(this, connection2);
                }
            });
        }
    }

    protected void onSignalReceived(String string, String string2, Connection connection) {
    }

    void onSignalReceivedJNI(String string, String string2, long l) {
        Connection connection;
        Session session = this;
        Connection connection2 = connection;
        connection = new Connection(l, true);
        session.handler.post(() -> this.onSignalReceived(string, string2, connection2));
        if (session.signalListener != null) {
            this.handler.post(() -> {
                SignalListener signalListener = this.signalListener;
                if (signalListener != null) {
                    signalListener.onSignalReceived(this, string, string2, connection2);
                }
            });
        }
    }

    protected void onReconnecting() {
    }

    void onReconnectingJNI() {
        Session session = this;
        session.handler.post(() -> this.onReconnecting());
        if (session.reconnectionListener != null) {
            this.handler.post(() -> {
                ReconnectionListener reconnectionListener = this.reconnectionListener;
                if (reconnectionListener != null) {
                    reconnectionListener.onReconnecting(this);
                }
            });
        }
    }

    protected void onReconnected() {
    }

    void onReconnectedJNI() {
        Session session = this;
        session.handler.post(() -> this.onReconnected());
        if (session.reconnectionListener != null) {
            this.handler.post(() -> {
                ReconnectionListener reconnectionListener = this.reconnectionListener;
                if (reconnectionListener != null) {
                    reconnectionListener.onReconnected(this);
                }
            });
        }
    }

    protected void onConnected() {
    }

    void onConnectedJNI() {
        Session session = this;
        session.handler.post(() -> {
            block36: {
                JSONArray jSONArray;
                JSONArray jSONArray2;
                JSONObject jSONObject;
                if (Build.VERSION.SDK_INT < 19) break block36;
                Object object = jSONObject;
                jSONObject = new JSONObject();
                JSONArray jSONArray3 = jSONArray2;
                jSONArray2 = new JSONArray();
                JSONArray jSONArray4 = jSONArray;
                jSONArray = new JSONArray();
                jSONObject.put("encoders", (Object)jSONArray3);
                jSONObject.put("decoders", (Object)jSONArray4);
                int n = 0;
                while (true) {
                    block37: {
                        String string;
                        String string2;
                        int n2;
                        int n3;
                        String[] stringArray;
                        MediaCodecInfo mediaCodecInfo;
                        block35: {
                            if (n >= MediaCodecList.getCodecCount()) break;
                            mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)n);
                            if (mediaCodecInfo == null) break block35;
                            if (!mediaCodecInfo.isEncoder()) break block35;
                            stringArray = mediaCodecInfo.getSupportedTypes();
                            n3 = stringArray.length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                string2 = stringArray[n2];
                                if (!string2.equals("video/avc")) continue;
                                JSONArray jSONArray5 = jSONArray3;
                                string2 = mediaCodecInfo.getCapabilitiesForType(string2);
                                MediaCodecInfo mediaCodecInfo2 = mediaCodecInfo;
                                JSONObject jSONObject2 = new JSONObject();
                                string = "codec";
                                jSONObject2.put(string, (Object)mediaCodecInfo2.getName());
                                jSONObject2.put("color_format", (Object)Arrays.toString(((MediaCodecInfo.CodecCapabilities)string2).colorFormats));
                                jSONArray5.put((Object)jSONObject2);
                            }
                            break block37;
                        }
                        if (mediaCodecInfo != null) {
                            stringArray = mediaCodecInfo.getSupportedTypes();
                            n3 = stringArray.length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                string2 = stringArray[n2];
                                if (!string2.equals("video/avc")) continue;
                                JSONArray jSONArray6 = jSONArray4;
                                string2 = mediaCodecInfo.getCapabilitiesForType(string2);
                                MediaCodecInfo mediaCodecInfo3 = mediaCodecInfo;
                                JSONObject jSONObject3 = new JSONObject();
                                string = "codec";
                                jSONObject3.put(string, (Object)mediaCodecInfo3.getName());
                                jSONObject3.put("color_format", (Object)Arrays.toString(((MediaCodecInfo.CodecCapabilities)string2).colorFormats));
                                jSONArray6.put((Object)jSONObject3);
                            }
                        }
                    }
                    ++n;
                }
                Session session = this;
                session.log.i("Log custom client event: \"codec-avail\" " + object.toString(), new Object[0]);
                SWIGTYPE_p_otc_session sWIGTYPE_p_otc_session = session.otc_session;
                JSONObject jSONObject4 = object;
                object = "codec-avail";
                try {
                    e.a(sWIGTYPE_p_otc_session, (String)object, jSONObject4.toString());
                }
                catch (Exception exception) {
                    this.log.w("Failed to analyze codec list: " + exception.getMessage(), new Object[0]);
                    exception.printStackTrace();
                }
            }
        });
        session.handler.post(() -> this.onConnected());
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onConnected(this);
                }
            });
        }
        this.handler.post(() -> {
            String string;
            if (this.otc_session != null && (string = OpenTokConfig.getRTCStatsReportFilePath()) != null && string.length() > 0) {
                e.c(this.otc_session, string);
            }
        });
    }

    protected void onDisconnected() {
    }

    void onDisconnectedJNI() {
        Session session = this;
        session.handler.post(() -> this.onDisconnected());
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onDisconnected(this);
                }
            });
        }
    }

    protected void onStreamReceived(Stream stream) {
    }

    void onStreamReceivedJNI(long l) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l, true);
        session.handler.post(() -> this.onStreamReceived(stream2));
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onStreamReceived(this, stream2);
                }
            });
        }
    }

    protected void onStreamDropped(Stream stream) {
    }

    void onStreamDroppedJNI(long l) {
        Stream stream;
        Session session = this;
        Stream stream2 = stream;
        stream = new Stream(l, true);
        session.handler.post(() -> this.onStreamDropped(stream2));
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onStreamDropped(this, stream2);
                }
            });
        }
    }

    protected void onError(OpentokError opentokError) {
    }

    void onErrorJNI(String string, int n) {
        OpentokError opentokError;
        Session session = this;
        OpentokError opentokError2 = opentokError;
        opentokError = new OpentokError(OpentokError.Domain.SessionErrorDomain, n, string);
        session.handler.post(() -> this.onError(opentokError2));
        if (session.sessionListener != null) {
            this.handler.post(() -> {
                SessionListener sessionListener = this.sessionListener;
                if (sessionListener != null) {
                    sessionListener.onError(this, opentokError2);
                }
            });
        }
    }

    protected void onMuteForced(MuteForcedInfo muteForcedInfo) {
    }

    void onMuteForcedJNI(long l) {
        MuteForcedInfo muteForcedInfo;
        this.log.d("onMuteForcedJNI(long) called", new Object[0]);
        boolean bl = new swig_on_mute_forced_info(l).getActive() == 1;
        Session session = this;
        MuteForcedInfo muteForcedInfo2 = muteForcedInfo;
        muteForcedInfo = new MuteForcedInfo(bl);
        session.handler.post(() -> this.onMuteForced(muteForcedInfo2));
        if (session.muteListener != null) {
            this.handler.post(() -> {
                MuteListener muteListener = this.muteListener;
                if (muteListener != null) {
                    muteListener.onMuteForced(this, muteForcedInfo2);
                }
            });
        }
    }

    Builder.IceServer[] getIceServers() {
        int[] nArray = new int[1];
        if (e.b(stringArray.otc_session, nArray) != g.c.a()) {
            return new Builder.IceServer[0];
        }
        if (nArray[0] == 0) {
            return new Builder.IceServer[0];
        }
        String[] stringArray = e.c(stringArray.otc_session, nArray);
        String[] stringArray2 = e.d(stringArray.otc_session, nArray);
        String[] stringArray3 = e.a(stringArray.otc_session, nArray);
        Builder.IceServer[] iceServerArray = new Builder.IceServer[nArray[0]];
        for (int i2 = 0; i2 < nArray[0]; ++i2) {
            Builder.IceServer iceServer;
            Builder.IceServer iceServer2 = iceServer;
            String string = stringArray[i2];
            String string2 = stringArray2[i2];
            String string3 = stringArray3[i2];
            iceServer = new Builder.IceServer(string, string2, string3);
            iceServerArray[i2] = iceServer2;
        }
        return iceServerArray;
    }

    void simulateReconnect() {
        if (e.g(this.otc_session) != g.c.a()) {
            this.log.e("Error when simulating a client reconnection.", new Object[0]);
        }
    }

    void reportExternalDeviceUsage(int n) {
        e.a(this.otc_session, h.a(n));
    }

    protected void finalize() {
        Session session = this;
        session.log.d("finalize()", new Object[0]);
        Object object = session.otc_session;
        if (object != null && this.shouldDestroyOnFinalize) {
            e.a((SWIGTYPE_p_otc_session)object);
            this.otc_session = null;
            object = this.session_cb;
            if (object != null) {
                this.destroy_native_session_cb(((swig_otc_session_cb)object).getCPointer());
            }
        }
        super.finalize();
    }

    native long build_native_session_cb();

    native void destroy_native_session_cb(long var1);

    native void init_otc_engine(Context var1, BaseAudioDevice var2, boolean var3, boolean var4, boolean var5, boolean var6);

    native void set_prefer_h264(boolean var1);

    static class swig_on_mute_forced_info
    extends otc_on_mute_forced_info {
        public swig_on_mute_forced_info(long l) {
            super(l, false);
        }

        public long getCPointer() {
            return otc_on_mute_forced_info.getCPtr(this);
        }
    }

    static class swig_otc_session_cb
    extends otc_session_callbacks {
        public swig_otc_session_cb(long l) {
            super(l, true);
        }

        public long getCPointer() {
            return otc_session_callbacks.getCPtr(this);
        }
    }

    public static class Builder {
        Context context;
        String apiKey;
        String sessionId;
        URL apiUrl;
        boolean connectionEventsSuppressed = false;
        SessionOptions sessionOptions = new SessionOptions(){};
        TransportPolicy turnRouting = TransportPolicy.All;
        IceServer[] iceServers = new IceServer[0];
        IncludeServers turnServerConfig = IncludeServers.All;
        boolean ipWhitelist = false;
        String proxyUrl;

        public Builder(Context context, String string, String string2) {
            this.context = context;
            this.apiKey = string;
            this.sessionId = string2;
        }

        public Builder connectionEventsSuppressed(Boolean bl) {
            this.connectionEventsSuppressed = bl;
            return this;
        }

        public Builder sessionOptions(SessionOptions sessionOptions) {
            this.sessionOptions = sessionOptions;
            return this;
        }

        public Builder setCustomIceServers(List<IceServer> list, IncludeServers includeServers) {
            List<IceServer> list2 = list;
            this.iceServers = list2.toArray(new IceServer[list2.size()]);
            this.turnServerConfig = includeServers;
            return this;
        }

        public Builder setIceRouting(TransportPolicy transportPolicy) {
            this.turnRouting = transportPolicy;
            return this;
        }

        @Deprecated
        public Builder setApiUrl(URL uRL) {
            this.apiUrl = uRL;
            return this;
        }

        public Builder setIpWhitelist(boolean bl) {
            this.ipWhitelist = bl;
            return this;
        }

        public Builder setProxyUrl(String string) {
            this.proxyUrl = string;
            return this;
        }

        public Session build() {
            Builder builder = builder2;
            Builder builder2 = builder.context;
            String string = builder.apiKey;
            String string2 = builder.sessionId;
            boolean bl = builder.connectionEventsSuppressed;
            SessionOptions sessionOptions = builder.sessionOptions;
            TransportPolicy transportPolicy = builder.turnRouting;
            IncludeServers includeServers = builder.turnServerConfig;
            IceServer[] iceServerArray = builder.iceServers;
            URL uRL = builder.apiUrl;
            boolean bl2 = builder.ipWhitelist;
            String string3 = builder.proxyUrl;
            return new Session((Context)builder2, string, string2, bl, sessionOptions, transportPolicy, includeServers, iceServerArray, uRL, bl2, string3);
        }

        public static class IceServer {
            public String url = "";
            public String user = "";
            public String credential = "";

            public IceServer(String string, String string2, String string3) {
                this.url = string;
                this.user = string2;
                this.credential = string3;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object object) {
                if (!(object instanceof IceServer)) return false;
                object = (IceServer)object;
                if (!this.url.equals(((IceServer)object).url)) return false;
                if (!this.user.equals(((IceServer)object).user)) return false;
                if (!this.credential.equals(((IceServer)object).credential)) return false;
                return true;
            }

            public String toString() {
                return "[url: " + this.url + ", user: " + this.user + ", credential: " + this.credential + "]";
            }
        }

        public static final class TransportPolicy
        extends Enum<TransportPolicy> {
            public static final /* enum */ TransportPolicy All;
            public static final /* enum */ TransportPolicy Relay;
            private static final /* synthetic */ TransportPolicy[] $VALUES;
            private int val;

            public static TransportPolicy[] values() {
                return (TransportPolicy[])$VALUES.clone();
            }

            public static TransportPolicy valueOf(String string) {
                return Enum.valueOf(TransportPolicy.class, string);
            }

            private TransportPolicy(int n2) {
                this.val = n2;
            }

            static /* synthetic */ int access$000(TransportPolicy transportPolicy) {
                return transportPolicy.val;
            }

            static {
                TransportPolicy transportPolicy;
                All = new TransportPolicy(0);
                TransportPolicy transportPolicy2 = transportPolicy;
                Relay = new TransportPolicy(1);
                $VALUES = new TransportPolicy[]{All, transportPolicy2};
            }
        }

        public static final class IncludeServers
        extends Enum<IncludeServers> {
            public static final /* enum */ IncludeServers All;
            public static final /* enum */ IncludeServers Custom;
            private static final /* synthetic */ IncludeServers[] $VALUES;
            private int val;

            public static IncludeServers[] values() {
                return (IncludeServers[])$VALUES.clone();
            }

            public static IncludeServers valueOf(String string) {
                return Enum.valueOf(IncludeServers.class, string);
            }

            private IncludeServers(int n2) {
                this.val = n2;
            }

            static /* synthetic */ int access$100(IncludeServers includeServers) {
                return includeServers.val;
            }

            static {
                IncludeServers includeServers;
                All = new IncludeServers(0);
                IncludeServers includeServers2 = includeServers;
                Custom = new IncludeServers(1);
                $VALUES = new IncludeServers[]{All, includeServers2};
            }
        }
    }

    static class SessionPauseResumeEvent {
        boolean mIsSessionPaused;

        SessionPauseResumeEvent(boolean bl) {
            this.mIsSessionPaused = bl;
        }

        boolean isSessionPaused() {
            return this.mIsSessionPaused;
        }
    }

    protected static class ConfigurableSessionOptions
    extends SessionOptions {
        private boolean hwDecCapable = false;

        ConfigurableSessionOptions(boolean bl) {
            this.hwDecCapable = bl;
        }

        @Override
        public boolean isHwDecodingSupported() {
            return this.hwDecCapable;
        }
    }

    public static abstract class SessionOptions {
        private final Map<String, Boolean> cam2EnableList;

        public SessionOptions() {
            HashMap<String, Boolean> hashMap;
            HashMap<String, Boolean> hashMap2 = hashMap;
            hashMap = new HashMap<String, Boolean>(this){
                final /* synthetic */ SessionOptions this$0;
                {
                    1 v0 = this;
                    v0.this$0 = sessionOptions;
                    v0.put("nexus 4", Boolean.TRUE);
                    v0.put("nexus 5", Boolean.TRUE);
                    v0.put("nexus 5x", Boolean.TRUE);
                    v0.put("nexus 6", Boolean.TRUE);
                    v0.put("nexus 6p", Boolean.TRUE);
                    v0.put("nexus 7", Boolean.TRUE);
                    v0.put("nexus 10", Boolean.TRUE);
                    v0.put("pixel", Boolean.TRUE);
                    v0.put("pixel 4", Boolean.TRUE);
                    v0.put("gt-i9300", Boolean.TRUE);
                    v0.put("samsung-sm-g925a", Boolean.TRUE);
                    v0.put("samsung-sm-g935a", Boolean.TRUE);
                    v0.put("samsung-sm-t817a", Boolean.TRUE);
                    v0.put("sm-g900h", Boolean.TRUE);
                    v0.put("sm-j106h", Boolean.TRUE);
                    v0.put("lgus991", Boolean.TRUE);
                    v0.put("lg-h810", Boolean.TRUE);
                    v0.put("lg-k430", Boolean.TRUE);
                    v0.put("xt1058", Boolean.TRUE);
                    v0.put("aquaris e5", Boolean.TRUE);
                    v0.put("c6602", Boolean.TRUE);
                }
            };
            this.cam2EnableList = hashMap2;
        }

        @Deprecated
        public boolean isHwDecodingSupported() {
            return false;
        }

        public boolean isCamera2Capable() {
            return this.cam2EnableList.containsKey(Build.MODEL.toLowerCase(Locale.ROOT));
        }

        public boolean useTextureViews() {
            return false;
        }
    }

    @Deprecated
    public static interface SessionOptionsProvider {
        @Deprecated
        public boolean isHwDecodingSupported();
    }

    public static interface MuteListener {
        public void onMuteForced(Session var1, MuteForcedInfo var2);
    }

    public static interface ReconnectionListener {
        public void onReconnecting(Session var1);

        public void onReconnected(Session var1);
    }

    public static interface ArchiveListener {
        public void onArchiveStarted(Session var1, String var2, String var3);

        public void onArchiveStopped(Session var1, String var2);
    }

    public static interface SignalListener {
        public void onSignalReceived(Session var1, String var2, String var3, Connection var4);
    }

    public static interface StreamPropertiesListener {
        public void onStreamHasAudioChanged(Session var1, Stream var2, boolean var3);

        public void onStreamHasVideoChanged(Session var1, Stream var2, boolean var3);

        public void onStreamVideoDimensionsChanged(Session var1, Stream var2, int var3, int var4);

        public void onStreamVideoTypeChanged(Session var1, Stream var2, Stream.StreamVideoType var3);
    }

    public static interface ConnectionListener {
        public void onConnectionCreated(Session var1, Connection var2);

        public void onConnectionDestroyed(Session var1, Connection var2);
    }

    public static interface SessionListener {
        public void onConnected(Session var1);

        public void onDisconnected(Session var1);

        public void onStreamReceived(Session var1, Stream var2);

        public void onStreamDropped(Session var1, Stream var2);

        public void onError(Session var1, OpentokError var2);
    }

    public static class Capabilities {
        public boolean canPublish;
        public boolean canSubscribe;
        public boolean canForceMute;
        private final OtLog.LogToken log;

        public Capabilities() {
            OtLog.LogToken logToken;
            OtLog.LogToken logToken2 = logToken;
            logToken = new OtLog.LogToken(this);
            this.log = logToken2;
        }

        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder("[\n");
            for (Field field : Capabilities.class.getFields()) {
                Object[] objectArray = new Object[2];
                Object[] objectArray2 = objectArray;
                int n = 0;
                objectArray2[n] = field.getName();
                n = 1;
                try {
                    objectArray[n] = field.get(this);
                    stringBuilder2.append(String.format("\t%s = %b\n", objectArray));
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.log.e("Error converting Capabilities to String", new Object[0]);
                }
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            stringBuilder3.append(']');
            return stringBuilder3.toString();
        }
    }
}

