/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc.voiceengine;

import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.otwebrtc.Logging;
import org.otwebrtc.ThreadUtils;
import org.otwebrtc.voiceengine.WebRtcAudioEffects;
import org.otwebrtc.voiceengine.WebRtcAudioUtils;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_AUDIO_SOURCE;
    private static int audioSource;
    private static volatile boolean microphoneMute;
    @Nullable
    private static WebRtcAudioRecordErrorCallback errorCallback;
    @Nullable
    private static WebRtcAudioRecordSamplesReadyCallback audioSamplesReadyCallback;
    private final long nativeAudioRecord;
    @Nullable
    private WebRtcAudioEffects effects;
    private ByteBuffer byteBuffer;
    @Nullable
    private AudioRecord audioRecord;
    @Nullable
    private AudioRecordThread audioThread;
    private byte[] emptyBytes;

    public static void setErrorCallback(WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback) {
        Logging.d(TAG, "Set error callback");
        errorCallback = webRtcAudioRecordErrorCallback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioRecordSamplesReadyCallback webRtcAudioRecordSamplesReadyCallback) {
        audioSamplesReadyCallback = webRtcAudioRecordSamplesReadyCallback;
    }

    WebRtcAudioRecord(long l) {
        WebRtcAudioRecord webRtcAudioRecord = this;
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        webRtcAudioRecord.nativeAudioRecord = l;
        webRtcAudioRecord.effects = WebRtcAudioEffects.create();
    }

    private boolean enableBuiltInAEC(boolean bl) {
        Logging.d(TAG, "enableBuiltInAEC(" + bl + ')');
        WebRtcAudioEffects webRtcAudioEffects = ((WebRtcAudioRecord)((Object)webRtcAudioEffects)).effects;
        if (webRtcAudioEffects == null) {
            Logging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return webRtcAudioEffects.setAEC(bl);
    }

    private boolean enableBuiltInNS(boolean bl) {
        Logging.d(TAG, "enableBuiltInNS(" + bl + ')');
        WebRtcAudioEffects webRtcAudioEffects = ((WebRtcAudioRecord)((Object)webRtcAudioEffects)).effects;
        if (webRtcAudioEffects == null) {
            Logging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return webRtcAudioEffects.setNS(bl);
    }

    private int initRecording(int n, int n2) {
        Logging.d(TAG, "initRecording(sampleRate=" + n + ", channels=" + n2 + ")");
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int n3 = n2;
        WebRtcAudioRecord webRtcAudioRecord = this;
        int n4 = n2 * 2;
        n2 = n / 100;
        webRtcAudioRecord.byteBuffer = ByteBuffer.allocateDirect(n4 * n2);
        Logging.d(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        webRtcAudioRecord.emptyBytes = new byte[webRtcAudioRecord.byteBuffer.capacity()];
        ByteBuffer byteBuffer = webRtcAudioRecord.byteBuffer;
        long l = webRtcAudioRecord.nativeAudioRecord;
        webRtcAudioRecord.nativeCacheDirectBufferAddress(byteBuffer, l);
        int n5 = this.channelCountToConfiguration(n3);
        int n6 = AudioRecord.getMinBufferSize((int)n, (int)n5, (int)2);
        if (n6 != -1 && n6 != -2) {
            AudioRecord audioRecord;
            Logging.d(TAG, "AudioRecord.getMinBufferSize: " + n6);
            n6 = Math.max(n6 * 2, this.byteBuffer.capacity());
            Logging.d(TAG, "bufferSizeInBytes: " + n6);
            AudioRecord audioRecord2 = audioRecord;
            try {
                AudioRecord audioRecord3 = audioRecord2;
                audioRecord3(audioSource, n, n5, 2, n6);
                this.audioRecord = audioRecord3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                WebRtcAudioRecord webRtcAudioRecord2 = this;
                webRtcAudioRecord2.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + illegalArgumentException.getMessage());
                webRtcAudioRecord2.releaseAudioResources();
                return -1;
            }
            if (audioRecord != null && audioRecord2.getState() == 1) {
                WebRtcAudioEffects webRtcAudioEffects = this.effects;
                if (webRtcAudioEffects != null) {
                    webRtcAudioEffects.enable(this.audioRecord.getAudioSessionId());
                }
                WebRtcAudioRecord webRtcAudioRecord3 = this;
                webRtcAudioRecord3.logMainParameters();
                webRtcAudioRecord3.logMainParametersExtended();
                return n2;
            }
            WebRtcAudioRecord webRtcAudioRecord4 = this;
            webRtcAudioRecord4.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            webRtcAudioRecord4.releaseAudioResources();
            return -1;
        }
        this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + n6);
        return -1;
    }

    private boolean startRecording() {
        AudioRecordThread audioRecordThread;
        block2: {
            Logging.d(TAG, "startRecording");
            WebRtcAudioRecord.assertTrue(this.audioRecord != null);
            WebRtcAudioRecord.assertTrue(this.audioThread == null);
            try {
                WebRtcAudioRecord webRtcAudioRecord = this;
                webRtcAudioRecord.audioRecord.startRecording();
                if (webRtcAudioRecord.audioRecord.getRecordingState() == 3) break block2;
            }
            catch (IllegalStateException illegalStateException) {
                this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + illegalStateException.getMessage());
                return false;
            }
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            return false;
        }
        AudioRecordThread audioRecordThread2 = audioRecordThread;
        audioRecordThread2("AudioRecordJavaThread");
        this.audioThread = audioRecordThread2;
        audioRecordThread.start();
        return true;
    }

    private boolean stopRecording() {
        Logging.d(TAG, "stopRecording");
        WebRtcAudioRecord.assertTrue(this.audioThread != null);
        WebRtcAudioRecord webRtcAudioRecord = this;
        webRtcAudioRecord.audioThread.stopThread();
        if (!ThreadUtils.joinUninterruptibly(webRtcAudioRecord.audioThread, 2000L)) {
            Logging.e(TAG, "Join of AudioRecordJavaThread timed out");
            WebRtcAudioUtils.logAudioState(TAG);
        }
        this.audioThread = null;
        WebRtcAudioEffects webRtcAudioEffects = this.effects;
        if (webRtcAudioEffects != null) {
            webRtcAudioEffects.release();
        }
        this.releaseAudioResources();
        return true;
    }

    private void logMainParameters() {
        Logging.d(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            Logging.d(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    private int channelCountToConfiguration(int n) {
        return n == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    public static synchronized void setAudioSource(int n) {
        Logging.w(TAG, "Audio source is changed from: " + audioSource + " to " + n);
        audioSource = n;
    }

    private static int getDefaultAudioSource() {
        return 7;
    }

    public static void setMicrophoneMute(boolean bl) {
        Logging.w(TAG, "setMicrophoneMute(" + bl + ")");
        microphoneMute = bl;
    }

    private void releaseAudioResources() {
        Logging.d(TAG, "releaseAudioResources");
        AudioRecord audioRecord = this.audioRecord;
        if (audioRecord != null) {
            audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String string) {
        Logging.e(TAG, "Init recording error: " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordInitError(string);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode audioRecordStartErrorCode, String string) {
        Logging.e(TAG, "Start recording error: " + (Object)((Object)audioRecordStartErrorCode) + ". " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordStartError(audioRecordStartErrorCode, string);
        }
    }

    private void reportWebRtcAudioRecordError(String string) {
        Logging.e(TAG, "Run-time recording error: " + string);
        WebRtcAudioUtils.logAudioState(TAG);
        WebRtcAudioRecordErrorCallback webRtcAudioRecordErrorCallback = errorCallback;
        if (webRtcAudioRecordErrorCallback != null) {
            webRtcAudioRecordErrorCallback.onWebRtcAudioRecordError(string);
        }
    }

    static {
        audioSource = DEFAULT_AUDIO_SOURCE = WebRtcAudioRecord.getDefaultAudioSource();
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String string) {
            super(string);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            block7: {
                Process.setThreadPriority((int)-19);
                Logging.d(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
                WebRtcAudioRecord.assertTrue(WebRtcAudioRecord.this.audioRecord.getRecordingState() == 3);
                System.nanoTime();
                while (this.keepAlive) {
                    int n = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                    if (n == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                        if (microphoneMute) {
                            AudioRecordThread audioRecordThread = this;
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.clear();
                            audioRecordThread.WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                        }
                        if (this.keepAlive) {
                            WebRtcAudioRecord webRtcAudioRecord = WebRtcAudioRecord.this;
                            long l = webRtcAudioRecord.nativeAudioRecord;
                            webRtcAudioRecord.nativeDataIsRecorded(n, l);
                        }
                        if (audioSamplesReadyCallback == null) continue;
                        byte[] byArray = Arrays.copyOf(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.capacity());
                        audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new AudioSamples(WebRtcAudioRecord.this.audioRecord, byArray));
                        continue;
                    }
                    String string = "AudioRecord.read failed: " + n;
                    Logging.e(WebRtcAudioRecord.TAG, string);
                    if (n != -3) continue;
                    this.keepAlive = false;
                    WebRtcAudioRecord.this.reportWebRtcAudioRecordError(string);
                }
                if (WebRtcAudioRecord.this.audioRecord == null) break block7;
                try {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
                catch (IllegalStateException illegalStateException) {
                    Logging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + illegalStateException.getMessage());
                }
            }
        }

        public void stopThread() {
            Logging.d(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioRecordSamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        private AudioSamples(AudioRecord audioRecord, byte[] byArray) {
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = audioRecord.getSampleRate();
            this.data = byArray;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface WebRtcAudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static final class AudioRecordStartErrorCode
    extends Enum<AudioRecordStartErrorCode> {
        public static final /* enum */ AudioRecordStartErrorCode AUDIO_RECORD_START_EXCEPTION;
        public static final /* enum */ AudioRecordStartErrorCode AUDIO_RECORD_START_STATE_MISMATCH;
        private static final /* synthetic */ AudioRecordStartErrorCode[] $VALUES;

        public static AudioRecordStartErrorCode[] values() {
            return (AudioRecordStartErrorCode[])$VALUES.clone();
        }

        public static AudioRecordStartErrorCode valueOf(String string) {
            return Enum.valueOf(AudioRecordStartErrorCode.class, string);
        }

        static {
            AudioRecordStartErrorCode audioRecordStartErrorCode;
            AUDIO_RECORD_START_EXCEPTION = new AudioRecordStartErrorCode();
            AudioRecordStartErrorCode audioRecordStartErrorCode2 = audioRecordStartErrorCode;
            AUDIO_RECORD_START_STATE_MISMATCH = new AudioRecordStartErrorCode();
            $VALUES = new AudioRecordStartErrorCode[]{AUDIO_RECORD_START_EXCEPTION, audioRecordStartErrorCode2};
        }
    }
}

