/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc.audio;

import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.UUID;
import org.otwebrtc.Logging;
import org.otwebrtc.audio.WebRtcAudioUtils;

class WebRtcAudioEffects {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioEffectsExternal";
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    @Nullable
    private static AudioEffect.Descriptor[] cachedEffects;
    @Nullable
    private AcousticEchoCanceler aec;
    @Nullable
    private NoiseSuppressor ns;
    private boolean shouldEnableAec;
    private boolean shouldEnableNs;

    public static boolean isAcousticEchoCancelerSupported() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC, AOSP_ACOUSTIC_ECHO_CANCELER);
    }

    public static boolean isNoiseSuppressorSupported() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS, AOSP_NOISE_SUPPRESSOR);
    }

    public WebRtcAudioEffects() {
        Logging.d(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    private boolean effectTypeIsVoIP(UUID uUID) {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(uUID) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_NS.equals(uUID) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private static void assertTrue(boolean bl) {
        if (bl) {
            return;
        }
        throw new AssertionError((Object)"Expected condition to be true");
    }

    @Nullable
    private static AudioEffect.Descriptor[] getAvailableEffects() {
        AudioEffect.Descriptor[] descriptorArray = cachedEffects;
        if (cachedEffects != null) {
            return descriptorArray;
        }
        cachedEffects = AudioEffect.queryEffects();
        return cachedEffects;
    }

    private static boolean isEffectTypeAvailable(UUID uUID, UUID uUID2) {
        AudioEffect.Descriptor[] descriptorArray = WebRtcAudioEffects.getAvailableEffects();
        if (descriptorArray == null) {
            return false;
        }
        for (AudioEffect.Descriptor descriptor : descriptorArray) {
            if (!descriptor.type.equals(uUID)) continue;
            return descriptor.uuid.equals(uUID2) ^ true;
        }
        return false;
    }

    public boolean setAEC(boolean bl) {
        Logging.d(TAG, "setAEC(" + bl + ")");
        if (!WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            Logging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && bl != this.shouldEnableAec) {
            Logging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = bl;
        return true;
    }

    public boolean setNS(boolean bl) {
        Logging.d(TAG, "setNS(" + bl + ")");
        if (!WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            Logging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && bl != this.shouldEnableNs) {
            Logging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = bl;
        return true;
    }

    public void enable(int n) {
        StringBuilder stringBuilder;
        CharSequence charSequence;
        Logging.d(TAG, "enable(audioSession=" + n + ")");
        WebRtcAudioEffects.assertTrue(((WebRtcAudioEffects)((Object)stringBuilder2)).aec == null);
        WebRtcAudioEffects.assertTrue(((WebRtcAudioEffects)((Object)stringBuilder2)).ns == null);
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            Object object;
            ((WebRtcAudioEffects)((Object)stringBuilder2)).aec = object = AcousticEchoCanceler.create((int)n);
            if (object != null) {
                boolean bl = object.getEnabled();
                boolean bl2 = ((WebRtcAudioEffects)((Object)stringBuilder2)).shouldEnableAec && WebRtcAudioEffects.isAcousticEchoCancelerSupported();
                if (((WebRtcAudioEffects)((Object)stringBuilder2)).aec.setEnabled(bl2) != 0) {
                    Logging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                }
                object = TAG;
                charSequence = new StringBuilder().append("AcousticEchoCanceler: was ");
                String string = bl ? "enabled" : "disabled";
                stringBuilder = charSequence.append(string).append(", enable: ").append(bl2).append(", is now: ");
                charSequence = ((WebRtcAudioEffects)((Object)stringBuilder2)).aec.getEnabled() ? "enabled" : "disabled";
                Logging.d((String)object, stringBuilder.append((String)charSequence).toString());
            } else {
                Logging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            NoiseSuppressor noiseSuppressor;
            ((WebRtcAudioEffects)((Object)stringBuilder2)).ns = noiseSuppressor = NoiseSuppressor.create((int)n);
            if (noiseSuppressor != null) {
                boolean bl = noiseSuppressor.getEnabled();
                boolean bl3 = ((WebRtcAudioEffects)((Object)stringBuilder2)).shouldEnableNs && WebRtcAudioEffects.isNoiseSuppressorSupported();
                if (((WebRtcAudioEffects)((Object)stringBuilder2)).ns.setEnabled(bl3) != 0) {
                    Logging.e(TAG, "Failed to set the NoiseSuppressor state");
                }
                String string = TAG;
                stringBuilder = new StringBuilder().append("NoiseSuppressor: was ");
                charSequence = bl ? "enabled" : "disabled";
                WebRtcAudioEffects webRtcAudioEffects = stringBuilder2;
                StringBuilder stringBuilder2 = stringBuilder.append((String)charSequence).append(", enable: ").append(bl3).append(", is now: ");
                String string2 = webRtcAudioEffects.ns.getEnabled() ? "enabled" : "disabled";
                Logging.d(string, stringBuilder2.append(string2).toString());
            } else {
                Logging.e(TAG, "Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        Logging.d(TAG, "release");
        AcousticEchoCanceler acousticEchoCanceler = this.aec;
        if (acousticEchoCanceler != null) {
            acousticEchoCanceler.release();
            this.aec = null;
        }
        if ((acousticEchoCanceler = this.ns) != null) {
            acousticEchoCanceler.release();
            this.ns = null;
        }
    }
}

