/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import org.otwebrtc.BaseBitrateAdjuster;

class DynamicBitrateAdjuster
extends BaseBitrateAdjuster {
    private static final double BITRATE_ADJUSTMENT_SEC = 3.0;
    private static final double BITRATE_ADJUSTMENT_MAX_SCALE = 4.0;
    private static final int BITRATE_ADJUSTMENT_STEPS = 20;
    private static final double BITS_PER_BYTE = 8.0;
    private double deviationBytes;
    private double timeSinceLastAdjustmentMs;
    private int bitrateAdjustmentScaleExp;

    DynamicBitrateAdjuster() {
    }

    private double getBitrateAdjustmentScale() {
        double d2 = (double)this.bitrateAdjustmentScaleExp / 20.0;
        return Math.pow(4.0, d2);
    }

    @Override
    public void setTargets(int n, int n2) {
        int n3 = this.targetBitrateBps;
        if (n3 > 0 && n < n3) {
            this.deviationBytes = this.deviationBytes * (double)n / (double)n3;
        }
        super.setTargets(n, n2);
    }

    @Override
    public void reportEncodedFrame(int n) {
        double d2;
        int n2 = this.targetFps;
        if (n2 == 0) {
            return;
        }
        DynamicBitrateAdjuster dynamicBitrateAdjuster = this;
        int n3 = dynamicBitrateAdjuster.targetBitrateBps;
        double d3 = (double)n3 / 8.0 / (double)n2;
        double d4 = dynamicBitrateAdjuster.deviationBytes + ((double)n - d3);
        this.deviationBytes = d3 = d4;
        double d5 = n2;
        this.timeSinceLastAdjustmentMs += 1000.0 / d5;
        d5 = (double)n3 / 8.0;
        d3 = d5 * 3.0;
        this.deviationBytes = d2 = Math.min(d4, d3);
        dynamicBitrateAdjuster.deviationBytes = d3 = Math.max(d2, -d3);
        if (dynamicBitrateAdjuster.timeSinceLastAdjustmentMs <= 3000.0) {
            return;
        }
        if (d3 > d5) {
            n = (int)(d3 / d5 + 0.5);
            this.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp -= n, -20);
            this.deviationBytes = d5;
        } else {
            double d6;
            d2 = -d5;
            if (d3 < d6) {
                n = (int)(-d3 / d5 + 0.5);
                this.bitrateAdjustmentScaleExp = Math.min(this.bitrateAdjustmentScaleExp += n, 20);
                this.deviationBytes = d2;
            }
        }
        this.timeSinceLastAdjustmentMs = 0.0;
    }

    @Override
    public int getAdjustedBitrateBps() {
        return (int)((double)this.targetBitrateBps * this.getBitrateAdjustmentScale());
    }
}

