/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import java.nio.ByteBuffer;
import org.otwebrtc.CalledByNative;
import org.otwebrtc.JniCommon;

public class DataChannel {
    private long nativeDataChannel;
    private long nativeObserver;

    @CalledByNative
    public DataChannel(long l) {
        this.nativeDataChannel = l;
    }

    private void checkDataChannelExists() {
        if (this.nativeDataChannel != 0L) {
            return;
        }
        throw new IllegalStateException("DataChannel has been disposed.");
    }

    private native long nativeRegisterObserver(Observer var1);

    private native void nativeUnregisterObserver(long var1);

    private native String nativeLabel();

    private native int nativeId();

    private native State nativeState();

    private native long nativeBufferedAmount();

    private native void nativeClose();

    private native boolean nativeSend(byte[] var1, boolean var2);

    public void registerObserver(Observer observer) {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        long l = dataChannel.nativeObserver;
        if (l != 0L) {
            this.nativeUnregisterObserver(l);
        }
        this.nativeObserver = this.nativeRegisterObserver(observer);
    }

    public void unregisterObserver() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        dataChannel.nativeUnregisterObserver(dataChannel.nativeObserver);
    }

    public String label() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        return dataChannel.nativeLabel();
    }

    public int id() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        return dataChannel.nativeId();
    }

    public State state() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        return dataChannel.nativeState();
    }

    public long bufferedAmount() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        return dataChannel.nativeBufferedAmount();
    }

    public void close() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        dataChannel.nativeClose();
    }

    public boolean send(Buffer buffer) {
        DataChannel dataChannel = object;
        Buffer buffer2 = buffer;
        ((DataChannel)object).checkDataChannelExists();
        Object object = new byte[buffer2.data.remaining()];
        buffer2.data.get((byte[])object);
        return dataChannel.nativeSend((byte[])object, buffer2.binary);
    }

    public void dispose() {
        DataChannel dataChannel = this;
        dataChannel.checkDataChannelExists();
        JniCommon.nativeReleaseRef(dataChannel.nativeDataChannel);
        dataChannel.nativeDataChannel = 0L;
    }

    @CalledByNative
    long getNativeDataChannel() {
        return this.nativeDataChannel;
    }

    public static final class State
    extends Enum<State> {
        public static final /* enum */ State CONNECTING;
        public static final /* enum */ State OPEN;
        public static final /* enum */ State CLOSING;
        public static final /* enum */ State CLOSED;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        @CalledByNative(value="State")
        static State fromNativeIndex(int n) {
            return State.values()[n];
        }

        static {
            State state;
            CONNECTING = new State();
            OPEN = new State();
            CLOSING = new State();
            State state2 = state;
            CLOSED = new State();
            $VALUES = new State[]{CONNECTING, OPEN, CLOSING, state2};
        }
    }

    public static interface Observer {
        @CalledByNative(value="Observer")
        public void onBufferedAmountChange(long var1);

        @CalledByNative(value="Observer")
        public void onStateChange();

        @CalledByNative(value="Observer")
        public void onMessage(Buffer var1);
    }

    public static class Buffer {
        public final ByteBuffer data;
        public final boolean binary;

        @CalledByNative(value="Buffer")
        public Buffer(ByteBuffer byteBuffer, boolean bl) {
            this.data = byteBuffer;
            this.binary = bl;
        }
    }

    public static class Init {
        public boolean ordered = true;
        public int maxRetransmitTimeMs = -1;
        public int maxRetransmits = -1;
        public String protocol = "";
        public boolean negotiated;
        public int id = -1;

        @CalledByNative(value="Init")
        boolean getOrdered() {
            return this.ordered;
        }

        @CalledByNative(value="Init")
        int getMaxRetransmitTimeMs() {
            return this.maxRetransmitTimeMs;
        }

        @CalledByNative(value="Init")
        int getMaxRetransmits() {
            return this.maxRetransmits;
        }

        @CalledByNative(value="Init")
        String getProtocol() {
            return this.protocol;
        }

        @CalledByNative(value="Init")
        boolean getNegotiated() {
            return this.negotiated;
        }

        @CalledByNative(value="Init")
        int getId() {
            return this.id;
        }
    }
}

