/*
 * Decompiled with CFR 0.152.
 */
package org.otwebrtc;

import org.otwebrtc.CalledByNative;

public final class CryptoOptions {
    private final Srtp srtp;
    private final SFrame sframe;

    private CryptoOptions(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        SFrame sFrame;
        Srtp srtp;
        Srtp srtp2 = srtp;
        srtp = new Srtp(bl, bl2, bl3);
        this.srtp = srtp2;
        SFrame sFrame2 = sFrame;
        sFrame = new SFrame(bl4);
        this.sframe = sFrame2;
    }

    public static Builder builder() {
        return new Builder();
    }

    @CalledByNative
    public Srtp getSrtp() {
        return this.srtp;
    }

    @CalledByNative
    public SFrame getSFrame() {
        return this.sframe;
    }

    public static class Builder {
        private boolean enableGcmCryptoSuites;
        private boolean enableAes128Sha1_32CryptoCipher;
        private boolean enableEncryptedRtpHeaderExtensions;
        private boolean requireFrameEncryption;

        private Builder() {
        }

        public Builder setEnableGcmCryptoSuites(boolean bl) {
            this.enableGcmCryptoSuites = bl;
            return this;
        }

        public Builder setEnableAes128Sha1_32CryptoCipher(boolean bl) {
            this.enableAes128Sha1_32CryptoCipher = bl;
            return this;
        }

        public Builder setEnableEncryptedRtpHeaderExtensions(boolean bl) {
            this.enableEncryptedRtpHeaderExtensions = bl;
            return this;
        }

        public Builder setRequireFrameEncryption(boolean bl) {
            this.requireFrameEncryption = bl;
            return this;
        }

        public CryptoOptions createCryptoOptions() {
            Builder builder = this;
            boolean bl = builder.enableGcmCryptoSuites;
            boolean bl2 = builder.enableAes128Sha1_32CryptoCipher;
            boolean bl3 = builder.enableEncryptedRtpHeaderExtensions;
            boolean bl4 = builder.requireFrameEncryption;
            return new CryptoOptions(bl, bl2, bl3, bl4);
        }
    }

    public final class SFrame {
        private final boolean requireFrameEncryption;

        private SFrame(boolean bl) {
            this.requireFrameEncryption = bl;
        }

        @CalledByNative(value="SFrame")
        public boolean getRequireFrameEncryption() {
            return this.requireFrameEncryption;
        }
    }

    public final class Srtp {
        private final boolean enableGcmCryptoSuites;
        private final boolean enableAes128Sha1_32CryptoCipher;
        private final boolean enableEncryptedRtpHeaderExtensions;

        private Srtp(boolean bl, boolean bl2, boolean bl3) {
            this.enableGcmCryptoSuites = bl;
            this.enableAes128Sha1_32CryptoCipher = bl2;
            this.enableEncryptedRtpHeaderExtensions = bl3;
        }

        @CalledByNative(value="Srtp")
        public boolean getEnableGcmCryptoSuites() {
            return this.enableGcmCryptoSuites;
        }

        @CalledByNative(value="Srtp")
        public boolean getEnableAes128Sha1_32CryptoCipher() {
            return this.enableAes128Sha1_32CryptoCipher;
        }

        @CalledByNative(value="Srtp")
        public boolean getEnableEncryptedRtpHeaderExtensions() {
            return this.enableEncryptedRtpHeaderExtensions;
        }
    }
}

