/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.content.Context;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.view.View;
import com.opentok.android.BaseVideoRenderer;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

class DefaultVideoRenderer
extends BaseVideoRenderer {
    protected long nativeInstance;
    Context context;
    GLSurfaceView view;
    MyRenderer renderer;
    BaseVideoRenderer.Frame lastFrame;
    ReentrantLock frameLock;
    boolean isPillarBoxEnabled;
    boolean isVideoDisabled;

    public DefaultVideoRenderer(Context object) {
        MyRenderer myRenderer;
        DefaultVideoRenderer defaultVideoRenderer = this;
        this.frameLock = new ReentrantLock();
        this.isPillarBoxEnabled = true;
        this.isVideoDisabled = false;
        defaultVideoRenderer.context = object;
        this.view = new GLSurfaceView(object);
        this.view.setEGLContextClientVersion(2);
        object = myRenderer;
        defaultVideoRenderer.renderer = new MyRenderer();
        defaultVideoRenderer.view.setRenderer((GLSurfaceView.Renderer)object);
        defaultVideoRenderer.view.setRenderMode(0);
        defaultVideoRenderer.view.setZOrderMediaOverlay(true);
    }

    private native void nativeCreateRenderer();

    private native void nativeSetupRenderer(int var1, int var2);

    private native void nativeRenderFrame(ByteBuffer var1, int var2, int var3, int var4, int var5, boolean var6, boolean var7);

    @Override
    public void onPause() {
        this.view.onPause();
    }

    @Override
    public void onResume() {
        this.view.onResume();
    }

    @Override
    public void onFrame(BaseVideoRenderer.Frame frame) {
        DefaultVideoRenderer defaultVideoRenderer = this;
        defaultVideoRenderer.frameLock.lock();
        BaseVideoRenderer.Frame frame2 = defaultVideoRenderer.lastFrame;
        if (frame2 != null) {
            frame2.destroy();
        }
        DefaultVideoRenderer defaultVideoRenderer2 = this;
        defaultVideoRenderer2.lastFrame = frame;
        defaultVideoRenderer2.frameLock.unlock();
        defaultVideoRenderer2.view.requestRender();
    }

    @Override
    public void setStyle(String string, String string2) {
        if ("STYLE_VIDEO_SCALE".equals(string)) {
            if ("STYLE_VIDEO_FIT".equals(string2)) {
                this.isPillarBoxEnabled = true;
            } else if ("STYLE_VIDEO_FILL".equals(string2)) {
                this.isPillarBoxEnabled = false;
            }
        }
    }

    @Override
    public void onVideoPropertiesChanged(boolean bl) {
        DefaultVideoRenderer defaultVideoRenderer = this;
        this.frameLock.lock();
        defaultVideoRenderer.isVideoDisabled = bl ^ true;
        defaultVideoRenderer.frameLock.unlock();
        defaultVideoRenderer.view.requestRender();
    }

    @Override
    public View getView() {
        return this.view;
    }

    private class MyRenderer
    implements GLSurfaceView.Renderer {
        public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
            gL10.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
            GLES20.glClear((int)16384);
            DefaultVideoRenderer.this.nativeCreateRenderer();
        }

        public void onSurfaceChanged(GL10 gL10, int n, int n2) {
            DefaultVideoRenderer.this.nativeSetupRenderer(n, n2);
        }

        public void onDrawFrame(GL10 object) {
            BaseVideoRenderer.Frame frame;
            MyRenderer myRenderer = this;
            int n = 0;
            Object var3_5 = null;
            myRenderer.DefaultVideoRenderer.this.frameLock.lock();
            DefaultVideoRenderer defaultVideoRenderer = myRenderer.DefaultVideoRenderer.this;
            if (!defaultVideoRenderer.isVideoDisabled) {
                frame = defaultVideoRenderer.lastFrame;
                if (frame != null) {
                    defaultVideoRenderer.lastFrame = null;
                } else {
                    frame = var3_5;
                }
            } else {
                n = 1;
                frame = var3_5;
            }
            DefaultVideoRenderer.this.frameLock.unlock();
            if (n == 0) {
                if (frame != null) {
                    object = frame.getBuffer();
                    object.clear();
                    BaseVideoRenderer.Frame frame2 = frame;
                    int n2 = frame2.getWidth();
                    int n3 = frame2.getHeight();
                    n = frame2.getYstride();
                    int n4 = frame2.getUvStride();
                    boolean bl = frame2.isMirroredX();
                    boolean bl2 = DefaultVideoRenderer.this.isPillarBoxEnabled;
                    DefaultVideoRenderer.this.nativeRenderFrame((ByteBuffer)object, n2, n3, n, n4, bl, bl2);
                    frame.destroy();
                }
            } else {
                object.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                GLES20.glClear((int)16384);
            }
        }
    }
}

