/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.ObjectTypeDeterminer;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.conversion.impl.DefaultTypeConverter;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.XWorkList;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWorkBasicConverter
extends DefaultTypeConverter {
    private static String MILLISECOND_FORMAT = ".SSS";
    private ObjectTypeDeterminer objectTypeDeterminer;
    private XWorkConverter xworkConverter;
    private ObjectFactory objectFactory;

    @Inject
    public void setObjectTypeDeterminer(ObjectTypeDeterminer det) {
        this.objectTypeDeterminer = det;
    }

    @Inject
    public void setXWorkConverter(XWorkConverter conv) {
        this.xworkConverter = conv;
    }

    @Inject
    public void setObjectFactory(ObjectFactory fac) {
        this.objectFactory = fac;
    }

    @Override
    public Object convertValue(Map<String, Object> context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        if (value == null || toType.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (toType == String.class) {
            result = this.doConvertToString(context, value);
        } else if (toType == Boolean.TYPE) {
            result = this.doConvertToBoolean(value);
        } else if (toType == Boolean.class) {
            result = this.doConvertToBoolean(value);
        } else if (toType.isArray()) {
            result = this.doConvertToArray(context, o, member, s, value, toType);
        } else if (Date.class.isAssignableFrom(toType)) {
            result = this.doConvertToDate(context, value, toType);
        } else if (Calendar.class.isAssignableFrom(toType)) {
            Date dateResult = (Date)this.doConvertToDate(context, value, Date.class);
            if (dateResult != null) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(dateResult);
                result = calendar;
            }
        } else if (Collection.class.isAssignableFrom(toType)) {
            result = this.doConvertToCollection(context, o, member, s, value, toType);
        } else if (toType == Character.class) {
            result = this.doConvertToCharacter(value);
        } else if (toType == Character.TYPE) {
            result = this.doConvertToCharacter(value);
        } else if (Number.class.isAssignableFrom(toType) || toType.isPrimitive()) {
            result = this.doConvertToNumber(context, value, toType);
        } else if (toType == Class.class) {
            result = this.doConvertToClass(value);
        }
        if (result == null) {
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                if (array.length >= 1) {
                    value = array[0];
                }
                result = this.convertValue(context, o, member, s, value, toType);
            } else if (!"".equals(value)) {
                result = super.convertValue(context, value, toType);
            }
            if (result == null && value != null && !"".equals(value)) {
                throw new XWorkException("Cannot create type " + toType + " from value " + value);
            }
        }
        return result;
    }

    private Locale getLocale(Map<String, Object> context) {
        if (context == null) {
            return Locale.getDefault();
        }
        Locale locale = (Locale)context.get("com.opensymphony.xwork2.ActionContext.locale");
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private Collection createCollection(Object fromObject, String propertyName, Class toType, Class memberType, int size) {
        AbstractCollection result = toType == Set.class ? (size > 0 ? new HashSet(size) : new HashSet()) : (toType == SortedSet.class ? new TreeSet() : (size > 0 ? new XWorkList(this.objectFactory, this.xworkConverter, memberType, size) : new XWorkList(this.objectFactory, this.xworkConverter, memberType)));
        return result;
    }

    private Object doConvertToArray(Map<String, Object> context, Object o, Member member, String s, Object value, Class toType) {
        Object result = null;
        Class<?> componentType = toType.getComponentType();
        if (componentType != null) {
            TypeConverter converter = this.getTypeConverter(context);
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                result = Array.newInstance(componentType, length);
                for (int i = 0; i < length; ++i) {
                    Object valueItem = Array.get(value, i);
                    Array.set(result, i, converter.convertValue(context, o, member, s, valueItem, componentType));
                }
            } else {
                result = Array.newInstance(componentType, 1);
                Array.set(result, 0, converter.convertValue(context, o, member, s, value, componentType));
            }
        }
        return result;
    }

    private Object doConvertToCharacter(Object value) {
        if (value instanceof String) {
            String cStr = (String)value;
            return cStr.length() > 0 ? new Character(cStr.charAt(0)) : null;
        }
        return null;
    }

    private Object doConvertToBoolean(Object value) {
        if (value instanceof String) {
            String bStr = (String)value;
            return Boolean.valueOf(bStr);
        }
        return null;
    }

    private Class doConvertToClass(Object value) {
        Class<?> clazz = null;
        if (value instanceof String && value != null && ((String)value).length() > 0) {
            try {
                clazz = Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                throw new XWorkException(e.getLocalizedMessage(), e);
            }
        }
        return clazz;
    }

    private Collection doConvertToCollection(Map<String, Object> context, Object o, Member member, String prop, Object value, Class toType) {
        Collection result;
        Class<String> memberType = String.class;
        if (o != null && (memberType = this.objectTypeDeterminer.getElementClass(o.getClass(), prop, null)) == null) {
            memberType = String.class;
        }
        if (toType.isAssignableFrom(value.getClass())) {
            result = (Collection)value;
        } else if (value.getClass().isArray()) {
            Object[] objArray = (Object[])value;
            TypeConverter converter = this.getTypeConverter(context);
            result = this.createCollection(o, prop, toType, memberType, objArray.length);
            for (Object anObjArray : objArray) {
                result.add(converter.convertValue(context, o, member, prop, anObjArray, memberType));
            }
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            Collection col = (Collection)value;
            TypeConverter converter = this.getTypeConverter(context);
            result = this.createCollection(o, prop, toType, memberType, col.size());
            for (Object aCol : col) {
                result.add(converter.convertValue(context, o, member, prop, aCol, memberType));
            }
        } else {
            result = this.createCollection(o, prop, toType, memberType, -1);
            result.add(value);
        }
        return result;
    }

    private Object doConvertToDate(Map<String, Object> context, Object value, Class toType) {
        Date result;
        block20: {
            result = null;
            if (value instanceof String && value != null && ((String)value).length() > 0) {
                Date check;
                String sa = (String)value;
                Locale locale = this.getLocale(context);
                DateFormat df = null;
                if (Time.class == toType) {
                    df = DateFormat.getTimeInstance(2, locale);
                } else if (Timestamp.class == toType) {
                    SimpleDateFormat[] fmts;
                    check = null;
                    SimpleDateFormat dtfmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, locale);
                    SimpleDateFormat fullfmt = new SimpleDateFormat(dtfmt.toPattern() + MILLISECOND_FORMAT, locale);
                    SimpleDateFormat dfmt = (SimpleDateFormat)DateFormat.getDateInstance(3, locale);
                    for (SimpleDateFormat fmt : fmts = new SimpleDateFormat[]{fullfmt, dtfmt, dfmt}) {
                        try {
                            check = fmt.parse(sa);
                            df = fmt;
                            if (check == null) continue;
                            break;
                        }
                        catch (ParseException ignore) {
                            // empty catch block
                        }
                    }
                } else if (Date.class == toType) {
                    SimpleDateFormat[] dfs;
                    check = null;
                    SimpleDateFormat d1 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 1, locale);
                    SimpleDateFormat d2 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, locale);
                    SimpleDateFormat d3 = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, locale);
                    SimpleDateFormat rfc3399 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                    for (SimpleDateFormat df1 : dfs = new SimpleDateFormat[]{d1, d2, d3, rfc3399}) {
                        try {
                            check = df1.parse(sa);
                            df = df1;
                            if (check == null) continue;
                            break;
                        }
                        catch (ParseException ignore) {
                            // empty catch block
                        }
                    }
                }
                if (df == null) {
                    df = DateFormat.getDateInstance(3, locale);
                }
                try {
                    df.setLenient(false);
                    result = df.parse(sa);
                    if (Date.class != toType) {
                        try {
                            Constructor constructor = toType.getConstructor(Long.TYPE);
                            return constructor.newInstance(result.getTime());
                        }
                        catch (Exception e) {
                            throw new XWorkException("Couldn't create class " + toType + " using default (long) constructor", e);
                        }
                    }
                    break block20;
                }
                catch (ParseException e) {
                    throw new XWorkException("Could not parse date", e);
                }
            }
            if (Date.class.isAssignableFrom(value.getClass())) {
                result = (Date)value;
            }
        }
        return result;
    }

    private Object doConvertToNumber(Map<String, Object> context, Object value, Class toType) {
        Object[] objArray;
        if (value instanceof String) {
            if (toType == BigDecimal.class) {
                return new BigDecimal((String)value);
            }
            if (toType == BigInteger.class) {
                return new BigInteger((String)value);
            }
            if (toType.isPrimitive()) {
                String stringValue;
                Object convertedValue = super.convertValue(context, value, toType);
                if (!this.isInRange((Number)convertedValue, stringValue = (String)value, toType)) {
                    throw new XWorkException("Overflow or underflow casting: \"" + stringValue + "\" into class " + convertedValue.getClass().getName());
                }
                return convertedValue;
            }
            String stringValue = (String)value;
            if (!(toType.isPrimitive() || stringValue != null && stringValue.length() != 0)) {
                return null;
            }
            NumberFormat numFormat = NumberFormat.getInstance(this.getLocale(context));
            ParsePosition parsePos = new ParsePosition(0);
            if (this.isIntegerType(toType)) {
                numFormat.setParseIntegerOnly(true);
            }
            numFormat.setGroupingUsed(true);
            Number number = numFormat.parse(stringValue, parsePos);
            if (parsePos.getIndex() != stringValue.length()) {
                throw new XWorkException("Unparseable number: \"" + stringValue + "\" at position " + parsePos.getIndex());
            }
            if (!this.isInRange(number, stringValue, toType)) {
                throw new XWorkException("Overflow or underflow casting: \"" + stringValue + "\" into class " + number.getClass().getName());
            }
            value = super.convertValue(context, number, toType);
        } else if (value instanceof Object[] && (objArray = (Object[])value).length == 1) {
            return this.doConvertToNumber(context, objArray[0], toType);
        }
        return super.convertValue(context, value, toType);
    }

    protected boolean isInRange(Number value, String stringValue, Class toType) {
        Number bigValue = null;
        Number lowerBound = null;
        Number upperBound = null;
        try {
            if (Double.TYPE == toType || Double.class == toType) {
                bigValue = new BigDecimal(stringValue);
                lowerBound = BigDecimal.valueOf(Double.MIN_VALUE);
                upperBound = BigDecimal.valueOf(Double.MAX_VALUE);
            } else if (Float.TYPE == toType || Float.class == toType) {
                bigValue = new BigDecimal(stringValue);
                lowerBound = BigDecimal.valueOf(1.4E-45f);
                upperBound = BigDecimal.valueOf(3.4028234663852886E38);
            } else if (Byte.TYPE == toType || Byte.class == toType) {
                bigValue = new BigInteger(stringValue);
                lowerBound = BigInteger.valueOf(-128L);
                upperBound = BigInteger.valueOf(127L);
            } else if (Character.TYPE == toType || Character.class == toType) {
                bigValue = new BigInteger(stringValue);
                lowerBound = BigInteger.valueOf(0L);
                upperBound = BigInteger.valueOf(65535L);
            } else if (Short.TYPE == toType || Short.class == toType) {
                bigValue = new BigInteger(stringValue);
                lowerBound = BigInteger.valueOf(-32768L);
                upperBound = BigInteger.valueOf(32767L);
            } else if (Integer.TYPE == toType || Integer.class == toType) {
                bigValue = new BigInteger(stringValue);
                lowerBound = BigInteger.valueOf(Integer.MIN_VALUE);
                upperBound = BigInteger.valueOf(Integer.MAX_VALUE);
            } else if (Long.TYPE == toType || Long.class == toType) {
                bigValue = new BigInteger(stringValue);
                lowerBound = BigInteger.valueOf(Long.MIN_VALUE);
                upperBound = BigInteger.valueOf(Long.MAX_VALUE);
            }
        }
        catch (NumberFormatException e) {
            return true;
        }
        return ((Comparable)((Object)bigValue)).compareTo(lowerBound) >= 0 && ((Comparable)((Object)bigValue)).compareTo(upperBound) <= 0;
    }

    protected boolean isIntegerType(Class type) {
        return Double.TYPE != type && Float.TYPE != type && Double.class != type && Float.class != type && Character.TYPE != type && Character.class != type;
    }

    private String doConvertFromNumberToString(Map<String, Object> context, Object value, Class toType) {
        if (Number.class.isAssignableFrom(toType)) {
            NumberFormat numFormat = NumberFormat.getInstance(this.getLocale(context));
            if (this.isIntegerType(toType)) {
                numFormat.setParseIntegerOnly(true);
            }
            numFormat.setGroupingUsed(true);
            numFormat.setMaximumFractionDigits(99);
            String number = numFormat.format(value);
            if (number != null) {
                return number;
            }
        }
        return null;
    }

    private String doConvertToString(Map<String, Object> context, Object value) {
        String result = null;
        if (value instanceof int[]) {
            int[] x = (int[])value;
            ArrayList<Integer> intArray = new ArrayList<Integer>(x.length);
            for (int aX : x) {
                intArray.add(aX);
            }
            result = TextUtils.join(", ", intArray);
        } else if (value instanceof long[]) {
            long[] x = (long[])value;
            ArrayList<Long> longArray = new ArrayList<Long>(x.length);
            for (long aX : x) {
                longArray.add(aX);
            }
            result = TextUtils.join(", ", longArray);
        } else if (value instanceof double[]) {
            double[] x = (double[])value;
            ArrayList<Double> doubleArray = new ArrayList<Double>(x.length);
            for (double aX : x) {
                doubleArray.add(new Double(aX));
            }
            result = TextUtils.join(", ", doubleArray);
        } else if (value instanceof boolean[]) {
            boolean[] x = (boolean[])value;
            ArrayList<Boolean> booleanArray = new ArrayList<Boolean>(x.length);
            for (boolean aX : x) {
                booleanArray.add(new Boolean(aX));
            }
            result = TextUtils.join(", ", booleanArray);
        } else if (value instanceof Date) {
            DateFormat df = null;
            if (value instanceof Time) {
                df = DateFormat.getTimeInstance(2, this.getLocale(context));
            } else if (value instanceof Timestamp) {
                SimpleDateFormat dfmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 2, this.getLocale(context));
                df = new SimpleDateFormat(dfmt.toPattern() + MILLISECOND_FORMAT);
            } else {
                df = DateFormat.getDateInstance(3, this.getLocale(context));
            }
            result = df.format(value);
        } else if (value instanceof String[]) {
            result = TextUtils.join(", ", (String[])value);
        }
        return result;
    }
}

