/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AliasInterceptor
extends AbstractInterceptor {
    private static final Log log = LogFactory.getLog(AliasInterceptor.class);
    private static final String DEFAULT_ALIAS_KEY = "aliases";
    protected String aliasesKey = "aliases";

    public void setAliasesKey(String aliasesKey) {
        this.aliasesKey = aliasesKey;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        ActionConfig config = invocation.getProxy().getConfig();
        ActionContext ac = invocation.getInvocationContext();
        Map<String, Object> parameters = config.getParams();
        if (parameters.containsKey(this.aliasesKey)) {
            String aliasExpression = (String)parameters.get(this.aliasesKey);
            ValueStack stack = ac.getValueStack();
            Object obj = stack.findValue(aliasExpression);
            if (obj != null && obj instanceof Map) {
                Map aliases = (Map)obj;
                for (Map.Entry entry : aliases.entrySet()) {
                    Map contextParameters;
                    String name = entry.getKey().toString();
                    String alias = (String)entry.getValue();
                    Object value = stack.findValue(name);
                    if (null == value && null != (contextParameters = ac.getParameters())) {
                        value = contextParameters.get(name);
                    }
                    if (null == value) continue;
                    stack.setValue(alias, value);
                }
            } else {
                log.debug((Object)("invalid alias expression:" + this.aliasesKey));
            }
        }
        return invocation.invoke();
    }
}

