/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionEventListener;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.DefaultActionInvocation;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.UnknownHandler;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.profiling.UtilTimerStack;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultActionProxy
implements ActionProxy,
Serializable {
    private static final long serialVersionUID = 3293074152487468527L;
    private static final Log LOG = LogFactory.getLog(DefaultActionProxy.class);
    protected Configuration configuration;
    protected ActionConfig config;
    protected ActionInvocation invocation;
    protected UnknownHandler unknownHandler;
    protected Map extraContext;
    protected String actionName;
    protected String namespace;
    protected String method;
    protected boolean executeResult;
    protected boolean cleanupContext;
    protected ObjectFactory objectFactory;
    protected ActionEventListener actionEventListener;

    protected DefaultActionProxy(String namespace, String actionName, Map extraContext, boolean executeResult, boolean cleanupContext) throws Exception {
        this.cleanupContext = cleanupContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating an DefaultActionProxy for namespace " + namespace + " and action name " + actionName));
        }
        this.actionName = actionName;
        this.namespace = namespace;
        this.executeResult = executeResult;
        this.extraContext = extraContext;
    }

    @Inject
    public void setObjectFactory(ObjectFactory factory) {
        this.objectFactory = factory;
    }

    @Inject
    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    @Inject(required=false)
    public void setUnknownHandler(UnknownHandler handler) {
        this.unknownHandler = handler;
    }

    @Inject(required=false)
    public void setActionEventListener(ActionEventListener listener) {
        this.actionEventListener = listener;
    }

    public Object getAction() {
        return this.invocation.getAction();
    }

    public String getActionName() {
        return this.actionName;
    }

    public ActionConfig getConfig() {
        return this.config;
    }

    public void setExecuteResult(boolean executeResult) {
        this.executeResult = executeResult;
    }

    public boolean getExecuteResult() {
        return this.executeResult;
    }

    public ActionInvocation getInvocation() {
        return this.invocation;
    }

    public String getNamespace() {
        return this.namespace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        ActionContext nestedContext = ActionContext.getContext();
        ActionContext.setContext(this.invocation.getInvocationContext());
        String retCode = null;
        String profileKey = "execute: ";
        try {
            UtilTimerStack.push(profileKey);
            retCode = this.invocation.invoke();
        }
        finally {
            if (this.cleanupContext) {
                ActionContext.setContext(nestedContext);
            }
            UtilTimerStack.pop(profileKey);
        }
        return retCode;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
        this.resolveMethod();
    }

    private void resolveMethod() {
        if (!TextUtils.stringSet(this.method)) {
            this.method = this.config.getMethodName();
            if (!TextUtils.stringSet(this.method)) {
                this.method = "execute";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        String profileKey = "create DefaultActionProxy: ";
        try {
            UtilTimerStack.push(profileKey);
            this.config = this.configuration.getRuntimeConfiguration().getActionConfig(this.namespace, this.actionName);
            if (this.config == null && this.unknownHandler != null) {
                this.config = this.unknownHandler.handleUnknownAction(this.namespace, this.actionName);
            }
            if (this.config == null) {
                String message = this.namespace != null && this.namespace.trim().length() > 0 ? LocalizedTextUtil.findDefaultText("xwork.exception.missing-package-action", Locale.getDefault(), new String[]{this.namespace, this.actionName}) : LocalizedTextUtil.findDefaultText("xwork.exception.missing-action", Locale.getDefault(), new String[]{this.actionName});
                throw new ConfigurationException(message);
            }
            this.invocation = new DefaultActionInvocation(this.objectFactory, this.unknownHandler, this, this.extraContext, true, this.actionEventListener);
            this.resolveMethod();
        }
        finally {
            UtilTimerStack.pop(profileKey);
        }
    }
}

