/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.components;

import com.opensymphony.webwork.components.RemoteCallUIBean;
import com.opensymphony.webwork.views.util.UrlHelper;
import com.opensymphony.xwork.util.OgnlValueStack;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Div
extends RemoteCallUIBean {
    private static final Log _log = LogFactory.getLog((Class)Div.class);
    public static final String TEMPLATE = "div";
    public static final String TEMPLATE_CLOSE = "div-close";
    public static final String COMPONENT_NAME = Div.class.getName();
    protected String updateFreq;
    protected String delay;
    protected String loadingText;
    protected String listenTopics;

    public Div(OgnlValueStack stack, HttpServletRequest request, HttpServletResponse response) {
        super(stack, request, response);
    }

    public String getDefaultOpenTemplate() {
        return TEMPLATE;
    }

    protected String getDefaultTemplate() {
        return TEMPLATE_CLOSE;
    }

    public void evaluateExtraParams() {
        super.evaluateExtraParams();
        if (null != this.updateFreq && !"".equals(this.updateFreq)) {
            this.addParameter("updateFreq", this.findString(this.updateFreq));
        } else {
            this.addParameter("updateFreq", "0");
        }
        if (null != this.delay && !"".equals(this.delay)) {
            this.addParameter("delay", this.findString(this.delay));
        } else {
            this.addParameter("delay", "0");
        }
        String tmpUpdateFreq = (String)this.getParameters().get("delay");
        String tmpDelay = (String)this.getParameters().get("updateFreq");
        try {
            int _updateFreq = Integer.parseInt(tmpUpdateFreq);
            int _delay = Integer.parseInt(tmpDelay);
            if (_updateFreq <= 0 && _delay <= 0) {
                this.addParameter("autoStart", "false");
            }
        }
        catch (NumberFormatException e) {
            _log.info((Object)("error while parsing updateFreq [" + tmpUpdateFreq + "] or delay [" + tmpDelay + "] to integer, cannot determine autoStart mode"), (Throwable)e);
        }
        if (this.loadingText != null) {
            this.addParameter("loadingText", this.findString(this.loadingText));
        }
        if (this.listenTopics != null) {
            this.addParameter("listenTopics", this.findString(this.listenTopics));
        }
        if (this.href != null) {
            this.addParameter("href", null);
            this.addParameter("href", UrlHelper.buildUrl(this.findString(this.href), this.request, this.response, null));
        }
    }

    public void setUpdateFreq(String updateFreq) {
        this.updateFreq = updateFreq;
    }

    public void setDelay(String delay) {
        this.delay = delay;
    }

    public void setLoadingText(String loadingText) {
        this.loadingText = loadingText;
    }

    public void setListenTopics(String listenTopics) {
        this.listenTopics = listenTopics;
    }
}

