/*
 * Decompiled with CFR 0.152.
 */
package com.oneclickaway.opensource.placeautocomplete.utils;

import android.util.Log;
import com.oneclickaway.opensource.placeautocomplete.data.model.room.SearchSelectedItem;
import com.oneclickaway.opensource.placeautocomplete.utils.Commons;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0005\u000e\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\b0\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0002J$\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\f0\u0006j\b\u0012\u0004\u0012\u00020\f`\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\n\u00a8\u0006\u0013"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy;", "", "()V", "getHasMap", "Ljava/util/TreeMap;", "Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$TimeContainer;", "Ljava/util/ArrayList;", "Lcom/oneclickaway/opensource/placeautocomplete/data/model/room/SearchSelectedItem;", "Lkotlin/collections/ArrayList;", "listOfOptions", "", "groupDataByTime", "Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$ListItem;", "myOption", "DateItem", "GeneralItem", "GroupComparator", "ListItem", "TimeContainer", "place_autocomplete_release"})
public final class GroupStrategy {
    @NotNull
    public final ArrayList<ListItem> groupDataByTime(@NotNull List<SearchSelectedItem> myOption) {
        Intrinsics.checkParameterIsNotNull(myOption, (String)"myOption");
        ArrayList<ListItem> consolidatedList = new ArrayList<ListItem>();
        TreeMap<TimeContainer, ArrayList<SearchSelectedItem>> hashedMap = this.getHasMap(myOption);
        Map map = hashedMap;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            TimeContainer key = (TimeContainer)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            ArrayList value = (ArrayList)entry2.getValue();
            DateItem dateItem = new DateItem();
            dateItem.setDate(key.getNowTime());
            consolidatedList.add(dateItem);
            for (SearchSelectedItem itemList : value) {
                GeneralItem generalItem = new GeneralItem();
                SearchSelectedItem searchSelectedItem = itemList;
                Intrinsics.checkExpressionValueIsNotNull((Object)searchSelectedItem, (String)"itemList");
                generalItem.setSearchSelectedItem(searchSelectedItem);
                consolidatedList.add(generalItem);
            }
        }
        return consolidatedList;
    }

    private final TreeMap<TimeContainer, ArrayList<SearchSelectedItem>> getHasMap(List<SearchSelectedItem> listOfOptions) {
        HashMap hashedMap = new HashMap();
        for (SearchSelectedItem searchedItem : listOfOptions) {
            TimeContainer dateContainer = new TimeContainer(Commons.INSTANCE.getPrettyTime(searchedItem.getSearchCurrentMilliseconds()), searchedItem.getSearchCurrentMilliseconds());
            if (hashedMap.containsKey(dateContainer)) {
                ArrayList arrayList = (ArrayList)hashedMap.get(dateContainer);
                if (arrayList != null) {
                    arrayList.add(searchedItem);
                }
                continue;
            }
            ArrayList<SearchSelectedItem> item = new ArrayList<SearchSelectedItem>();
            item.add(searchedItem);
            ((Map)hashedMap).put(dateContainer, item);
        }
        TreeMap<TimeContainer, ArrayList<SearchSelectedItem>> blankTree = new TreeMap<TimeContainer, ArrayList<SearchSelectedItem>>(new GroupComparator());
        blankTree.putAll(hashedMap);
        return blankTree;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$TimeContainer;", "", "nowTime", "", "timeInMilliseconds", "", "(Ljava/lang/String;J)V", "getNowTime", "()Ljava/lang/String;", "setNowTime", "(Ljava/lang/String;)V", "getTimeInMilliseconds", "()J", "setTimeInMilliseconds", "(J)V", "equals", "", "other", "hashCode", "", "toString", "place_autocomplete_release"})
    public static final class TimeContainer {
        @NotNull
        private String nowTime;
        private long timeInMilliseconds;

        public boolean equals(@Nullable Object other) {
            return other instanceof TimeContainer ? Intrinsics.areEqual((Object)this.nowTime, (Object)((TimeContainer)other).nowTime) : false;
        }

        public int hashCode() {
            Log.d((String)"getHasMap", (String)("hashCode: " + this.nowTime.hashCode()));
            return this.nowTime.hashCode();
        }

        @NotNull
        public String toString() {
            return "TimeContainer(nowTime='" + this.nowTime + "', timeInMilliseconds=" + this.timeInMilliseconds + ')';
        }

        @NotNull
        public final String getNowTime() {
            return this.nowTime;
        }

        public final void setNowTime(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
            this.nowTime = string2;
        }

        public final long getTimeInMilliseconds() {
            return this.timeInMilliseconds;
        }

        public final void setTimeInMilliseconds(long l) {
            this.timeInMilliseconds = l;
        }

        public TimeContainer(@NotNull String nowTime, long timeInMilliseconds) {
            Intrinsics.checkParameterIsNotNull((Object)nowTime, (String)"nowTime");
            this.nowTime = nowTime;
            this.timeInMilliseconds = timeInMilliseconds;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b&\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H&\u00a8\u0006\u0006"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$ListItem;", "", "()V", "getType", "", "Companion", "place_autocomplete_release"})
    public static abstract class ListItem {
        public static final int TYPE_DATE = 101;
        public static final int TYPE_GENERAL_ITEM = 102;
        public static final Companion Companion = new Companion(null);

        public abstract int getType();

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$ListItem$Companion;", "", "()V", "TYPE_DATE", "", "TYPE_GENERAL_ITEM", "place_autocomplete_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$DateItem;", "Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$ListItem;", "()V", "date", "", "getDate", "()Ljava/lang/String;", "setDate", "(Ljava/lang/String;)V", "getType", "", "place_autocomplete_release"})
    public static final class DateItem
    extends ListItem {
        @NotNull
        public String date;

        @NotNull
        public final String getDate() {
            String string2 = this.date;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"date");
            }
            return string2;
        }

        public final void setDate(@NotNull String string2) {
            Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
            this.date = string2;
        }

        @Override
        public int getType() {
            return 101;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$GeneralItem;", "Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$ListItem;", "()V", "searchSelectedItem", "Lcom/oneclickaway/opensource/placeautocomplete/data/model/room/SearchSelectedItem;", "getSearchSelectedItem", "()Lcom/oneclickaway/opensource/placeautocomplete/data/model/room/SearchSelectedItem;", "setSearchSelectedItem", "(Lcom/oneclickaway/opensource/placeautocomplete/data/model/room/SearchSelectedItem;)V", "getType", "", "place_autocomplete_release"})
    public static final class GeneralItem
    extends ListItem {
        @NotNull
        public SearchSelectedItem searchSelectedItem;

        @NotNull
        public final SearchSelectedItem getSearchSelectedItem() {
            SearchSelectedItem searchSelectedItem = this.searchSelectedItem;
            if (searchSelectedItem == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"searchSelectedItem");
            }
            return searchSelectedItem;
        }

        public final void setSearchSelectedItem(@NotNull SearchSelectedItem searchSelectedItem) {
            Intrinsics.checkParameterIsNotNull((Object)searchSelectedItem, (String)"<set-?>");
            this.searchSelectedItem = searchSelectedItem;
        }

        @Override
        public int getType() {
            return 102;
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$GroupComparator;", "Ljava/util/Comparator;", "Lcom/oneclickaway/opensource/placeautocomplete/utils/GroupStrategy$TimeContainer;", "()V", "compare", "", "p0", "p1", "place_autocomplete_release"})
    public static final class GroupComparator
    implements Comparator<TimeContainer> {
        @Override
        public int compare(@Nullable TimeContainer p0, @Nullable TimeContainer p1) {
            TimeContainer timeContainer = p0;
            if (timeContainer == null) {
                Intrinsics.throwNpe();
            }
            long l = timeContainer.getTimeInMilliseconds();
            TimeContainer timeContainer2 = p1;
            if (timeContainer2 == null) {
                Intrinsics.throwNpe();
            }
            return l < timeContainer2.getTimeInMilliseconds() ? 1 : -1;
        }
    }
}

