/*
 * Decompiled with CFR 0.152.
 */
package com.oneclickaway.opensource.placeautocomplete.utils;

import android.content.Context;
import android.net.ConnectivityManager;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/utils/Commons;", "", "()V", "getPrettyTime", "", "milliSeconds", "", "isNetworkConnected", "", "mContext", "Landroid/content/Context;", "place_autocomplete_release"})
public final class Commons {
    public static final Commons INSTANCE;

    public final boolean isNetworkConnected(@NotNull Context mContext) {
        ConnectivityManager cm;
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        ConnectivityManager connectivityManager = cm = (ConnectivityManager)mContext.getSystemService("connectivity");
        if (connectivityManager == null) {
            Intrinsics.throwNpe();
        }
        return connectivityManager.getActiveNetworkInfo() != null;
    }

    @NotNull
    public final String getPrettyTime(long milliSeconds) {
        int n = 0;
        int minutesToYesterday = 1440;
        int minutesToWeek = 10080;
        float minutesToPost = (float)(System.currentTimeMillis() - milliSeconds) / 1000.0f / 60.0f;
        Calendar currentDateInstance = Calendar.getInstance();
        currentDateInstance.set(currentDateInstance.get(1), currentDateInstance.get(5), currentDateInstance.get(5));
        Calendar currentTimeCalender = Calendar.getInstance();
        currentTimeCalender.set(currentTimeCalender.get(1), currentTimeCalender.get(5), currentTimeCalender.get(5), n, n, n);
        Calendar calendar = currentDateInstance;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"currentDateInstance");
        long l = calendar.getTimeInMillis();
        Calendar calendar2 = currentTimeCalender;
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"currentTimeCalender");
        float minutesElapsedForToday = (float)(l - calendar2.getTimeInMillis()) / 1000.0f / 60.0f;
        return minutesToPost < minutesElapsedForToday ? "Today" : (minutesToPost - minutesElapsedForToday < (float)minutesToYesterday ? "Yesterday" : (minutesToPost - minutesElapsedForToday < (float)minutesToWeek ? "Earlier this week" : "Previous Searches"));
    }

    private Commons() {
    }

    static {
        Commons commons;
        INSTANCE = commons = new Commons();
    }
}

