/*
 * Decompiled with CFR 0.152.
 */
package com.oneclickaway.opensource.placeautocomplete.data.room;

import android.arch.persistence.db.SupportSQLiteQuery;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.EntityInsertionAdapter;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.database.Cursor;
import com.oneclickaway.opensource.placeautocomplete.data.model.room.SearchSelectedItem;
import com.oneclickaway.opensource.placeautocomplete.data.room.RecentSearchesDAO;
import java.util.ArrayList;
import java.util.List;

public class RecentSearchesDAO_Impl
implements RecentSearchesDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfSearchSelectedItem;

    public RecentSearchesDAO_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSearchSelectedItem = new EntityInsertionAdapter<SearchSelectedItem>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `SearchSelectedItem`(`placeId`,`mainText`,`secondaryText`,`searchCurrentMilliseconds`) VALUES (?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, SearchSelectedItem value) {
                if (value.getPlaceId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPlaceId());
                }
                if (value.getMainText() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMainText());
                }
                if (value.getSecondaryText() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getSecondaryText());
                }
                stmt.bindLong(4, value.getSearchCurrentMilliseconds());
            }
        };
    }

    @Override
    public void addSearchItem(SearchSelectedItem searchSelectedItem) {
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSearchSelectedItem.insert((Object)searchSelectedItem);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SearchSelectedItem> getRecentSearches() {
        String _sql = "SELECT * FROM SearchSelectedItem ORDER BY searchCurrentMilliseconds DESC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM SearchSelectedItem ORDER BY searchCurrentMilliseconds DESC", (int)0);
        Cursor _cursor = this.__db.query((SupportSQLiteQuery)_statement);
        try {
            int _cursorIndexOfPlaceId = _cursor.getColumnIndexOrThrow("placeId");
            int _cursorIndexOfMainText = _cursor.getColumnIndexOrThrow("mainText");
            int _cursorIndexOfSecondaryText = _cursor.getColumnIndexOrThrow("secondaryText");
            int _cursorIndexOfSearchCurrentMilliseconds = _cursor.getColumnIndexOrThrow("searchCurrentMilliseconds");
            ArrayList<SearchSelectedItem> _result = new ArrayList<SearchSelectedItem>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPlaceId = _cursor.getString(_cursorIndexOfPlaceId);
                String _tmpMainText = _cursor.getString(_cursorIndexOfMainText);
                String _tmpSecondaryText = _cursor.getString(_cursorIndexOfSecondaryText);
                long _tmpSearchCurrentMilliseconds = _cursor.getLong(_cursorIndexOfSearchCurrentMilliseconds);
                SearchSelectedItem _item = new SearchSelectedItem(_tmpPlaceId, _tmpMainText, _tmpSecondaryText, _tmpSearchCurrentMilliseconds);
                _result.add(_item);
            }
            ArrayList<SearchSelectedItem> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

