/*
 * Decompiled with CFR 0.152.
 */
package com.oneclickaway.opensource.placeautocomplete.data.repositories;

import android.annotation.SuppressLint;
import android.app.Application;
import android.arch.lifecycle.LiveData;
import android.arch.lifecycle.MutableLiveData;
import android.content.Context;
import android.util.Log;
import com.oneclickaway.opensource.placeautocomplete.data.api.base.RESTAPIManager;
import com.oneclickaway.opensource.placeautocomplete.data.api.bean.place_details.PlaceDetails;
import com.oneclickaway.opensource.placeautocomplete.data.api.bean.places_response.PredictionsItem;
import com.oneclickaway.opensource.placeautocomplete.data.api.bean.places_response.SearchResponse;
import com.oneclickaway.opensource.placeautocomplete.data.model.room.SearchSelectedItem;
import com.oneclickaway.opensource.placeautocomplete.data.repositories.SearchPlacesRepo;
import com.oneclickaway.opensource.placeautocomplete.data.room.RecentSearchesDB;
import com.oneclickaway.opensource.placeautocomplete.utils.Commons;
import com.oneclickaway.opensource.placeautocomplete.utils.LoadingManager;
import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010J\u0014\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u0018J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\r0\u0018J\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0018J\u0012\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n0\u0018J\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u0018J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"J&\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020%2\u0006\u0010(\u001a\u00020%J\u0016\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020%R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/data/repositories/SearchPlacesRepo;", "", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "getApplication", "()Landroid/app/Application;", "setApplication", "listOfSearchResults", "Landroid/arch/lifecycle/MutableLiveData;", "", "Lcom/oneclickaway/opensource/placeautocomplete/data/api/bean/places_response/PredictionsItem;", "loadingPlaceManager", "Lcom/oneclickaway/opensource/placeautocomplete/utils/LoadingManager;", "loadingPredictionManager", "placeDetails", "Lcom/oneclickaway/opensource/placeautocomplete/data/api/bean/place_details/PlaceDetails;", "recentSearches", "Lcom/oneclickaway/opensource/placeautocomplete/data/model/room/SearchSelectedItem;", "recentSearchesManager", "addSearchedItemToRecent", "", "it", "getLiveListOfSearchResultsStream", "Landroid/arch/lifecycle/LiveData;", "getLoadingPlaceManager", "getLoadingPredictionManager", "getPlaceDetailsLiveDataStream", "getRecentSearches", "getRecentSearchesManager", "initDb", "Lcom/oneclickaway/opensource/placeautocomplete/data/room/RecentSearchesDB;", "requestListOfRecentSearches", "mContext", "Landroid/content/Context;", "requestListOfSearchResults", "placeHint", "", "apiKey", "location", "radius", "requestPlaceDetails", "placeId", "place_autocomplete_release"})
@SuppressLint(value={"CheckResult"})
public final class SearchPlacesRepo {
    private final MutableLiveData<List<PredictionsItem>> listOfSearchResults;
    private final MutableLiveData<PlaceDetails> placeDetails;
    private final MutableLiveData<List<SearchSelectedItem>> recentSearches;
    private final MutableLiveData<LoadingManager> loadingPredictionManager;
    private final MutableLiveData<LoadingManager> loadingPlaceManager;
    private final MutableLiveData<LoadingManager> recentSearchesManager;
    @NotNull
    private Application application;

    @NotNull
    public final LiveData<List<PredictionsItem>> getLiveListOfSearchResultsStream() {
        return (LiveData)this.listOfSearchResults;
    }

    @NotNull
    public final LiveData<PlaceDetails> getPlaceDetailsLiveDataStream() {
        return (LiveData)this.placeDetails;
    }

    @NotNull
    public final LiveData<List<SearchSelectedItem>> getRecentSearches() {
        return (LiveData)this.recentSearches;
    }

    @NotNull
    public final LiveData<LoadingManager> getLoadingPredictionManager() {
        return (LiveData)this.loadingPredictionManager;
    }

    @NotNull
    public final LiveData<LoadingManager> getLoadingPlaceManager() {
        return (LiveData)this.loadingPlaceManager;
    }

    @NotNull
    public final LiveData<LoadingManager> getRecentSearchesManager() {
        return (LiveData)this.recentSearchesManager;
    }

    public final void requestListOfSearchResults(@NotNull String placeHint, @NotNull String apiKey, @NotNull String location, @NotNull String radius) {
        Intrinsics.checkParameterIsNotNull((Object)placeHint, (String)"placeHint");
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)radius, (String)"radius");
        this.loadingPredictionManager.postValue((Object)LoadingManager.STATE_REFRESHING);
        if (StringsKt.isBlank((CharSequence)placeHint)) {
            this.loadingPredictionManager.postValue((Object)LoadingManager.STATE_IDLE);
            return;
        }
        if (!Commons.INSTANCE.isNetworkConnected((Context)this.application)) {
            this.loadingPredictionManager.postValue((Object)LoadingManager.STATE_NO_INTERNET);
            return;
        }
        RESTAPIManager.INSTANCE.getInstance().getPlaceResults(placeHint, apiKey, location, radius).filter((Predicate)new Predicate<SearchResponse>(this){
            final /* synthetic */ SearchPlacesRepo this$0;

            public final boolean test(@NotNull SearchResponse it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (it.getPredictions() != null && it.getPredictions().isEmpty()) {
                    SearchPlacesRepo.access$getLoadingPredictionManager$p(this.this$0).postValue((Object)((Object)LoadingManager.STATE_NO_RESULT));
                    return false;
                }
                return true;
            }
            {
                this.this$0 = searchPlacesRepo;
            }
        }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).map((Function)requestListOfSearchResults.2.INSTANCE).subscribe((Observer)new DisposableObserver<List<? extends PredictionsItem>>(this){
            final /* synthetic */ SearchPlacesRepo this$0;

            public void onComplete() {
                SearchPlacesRepo.access$getLoadingPredictionManager$p(this.this$0).postValue((Object)((Object)LoadingManager.STATE_COMPLETED));
            }

            public void onNext(@NotNull List<PredictionsItem> t) {
                Intrinsics.checkParameterIsNotNull(t, (String)"t");
                SearchPlacesRepo.access$getListOfSearchResults$p(this.this$0).postValue(t);
            }

            public void onError(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SearchPlacesRepo.access$getLoadingPredictionManager$p(this.this$0).postValue((Object)((Object)LoadingManager.STATE_ERROR));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void requestPlaceDetails(@NotNull String placeId, @NotNull String apiKey) {
        Intrinsics.checkParameterIsNotNull((Object)placeId, (String)"placeId");
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        this.loadingPlaceManager.postValue((Object)LoadingManager.STATE_REFRESHING);
        if (!Commons.INSTANCE.isNetworkConnected((Context)this.application)) {
            this.loadingPlaceManager.postValue((Object)LoadingManager.STATE_NO_INTERNET);
            return;
        }
        RESTAPIManager.INSTANCE.getInstance().getPlaceDetailsFromPlaceId(placeId, apiKey).observeOn(Schedulers.io()).subscribeOn(Schedulers.io()).filter((Predicate)requestPlaceDetails.1.INSTANCE).map((Function)requestPlaceDetails.2.INSTANCE).subscribe((Observer)new DisposableObserver<PlaceDetails>(this){
            final /* synthetic */ SearchPlacesRepo this$0;

            public void onComplete() {
                SearchPlacesRepo.access$getLoadingPlaceManager$p(this.this$0).postValue((Object)((Object)LoadingManager.STATE_COMPLETED));
            }

            public void onNext(@NotNull PlaceDetails it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                SearchPlacesRepo.access$getPlaceDetails$p(this.this$0).postValue((Object)it);
                this.this$0.addSearchedItemToRecent(it);
            }

            public void onError(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                SearchPlacesRepo.access$getLoadingPlaceManager$p(this.this$0).postValue((Object)((Object)LoadingManager.STATE_ERROR));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public final void requestListOfRecentSearches(@NotNull Context mContext) {
        Intrinsics.checkParameterIsNotNull((Object)mContext, (String)"mContext");
        this.recentSearchesManager.postValue((Object)LoadingManager.STATE_REFRESHING);
        if (!Commons.INSTANCE.isNetworkConnected((Context)this.application)) {
            this.recentSearchesManager.postValue((Object)LoadingManager.STATE_NO_INTERNET);
            return;
        }
        Observable.fromCallable((Callable)new Callable<T>(mContext){
            final /* synthetic */ Context $mContext;

            @Nullable
            public final List<SearchSelectedItem> call() {
                Object object = RecentSearchesDB.Companion.getInstance(this.$mContext);
                return object != null && (object = object.repDao()) != null ? object.getRecentSearches() : null;
            }
            {
                this.$mContext = context;
            }
        }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe((Consumer)new Consumer<List<? extends SearchSelectedItem>>(this){
            final /* synthetic */ SearchPlacesRepo this$0;

            public final void accept(@Nullable List<SearchSelectedItem> it) {
                if (it != null && it.isEmpty()) {
                    SearchPlacesRepo.access$getRecentSearchesManager$p(this.this$0).postValue((Object)((Object)LoadingManager.STATE_NO_RESULT));
                } else {
                    SearchPlacesRepo.access$getRecentSearchesManager$p(this.this$0).postValue((Object)((Object)LoadingManager.STATE_COMPLETED));
                    Log.d((String)"arrayItems", (String)("" + String.valueOf(it)));
                    SearchPlacesRepo.access$getRecentSearches$p(this.this$0).postValue(it);
                }
            }
            {
                this.this$0 = searchPlacesRepo;
            }
        });
    }

    public final void addSearchedItemToRecent(@NotNull PlaceDetails it) {
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        Observable.fromCallable((Callable)new Callable<T>(this, it){
            final /* synthetic */ SearchPlacesRepo this$0;
            final /* synthetic */ PlaceDetails $it;

            @Nullable
            public final Unit call() {
                Unit unit;
                Object object = SearchPlacesRepo.access$initDb(this.this$0);
                if (object != null && (object = object.repDao()) != null) {
                    object.addSearchItem(new SearchSelectedItem(String.valueOf(this.$it.getPlaceId()), String.valueOf(this.$it.getName()), String.valueOf(this.$it.getFormattedAddress()), System.currentTimeMillis()));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.this$0 = searchPlacesRepo;
                this.$it = placeDetails;
            }
        }).subscribeOn(Schedulers.computation()).observeOn(Schedulers.io()).subscribe((Observer)new DisposableObserver<Unit>(){

            public void onNext(@NotNull Unit t) {
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"addSearchedItemToRecent: onNext");
            }

            public void onComplete() {
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"addSearchedItemToRecent: Completed");
            }

            public void onError(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                Log.e((String)((Object)((Object)this)).getClass().getSimpleName(), (String)"addSearchedItemToRecent: Error");
            }
        });
    }

    private final RecentSearchesDB initDb() {
        return RecentSearchesDB.Companion.getInstance((Context)this.application);
    }

    @NotNull
    public final Application getApplication() {
        return this.application;
    }

    public final void setApplication(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"<set-?>");
        this.application = application;
    }

    public SearchPlacesRepo(@NotNull Application application) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        this.application = application;
        this.listOfSearchResults = new MutableLiveData();
        this.placeDetails = new MutableLiveData();
        this.recentSearches = new MutableLiveData();
        this.loadingPredictionManager = new MutableLiveData();
        this.loadingPlaceManager = new MutableLiveData();
        this.recentSearchesManager = new MutableLiveData();
    }

    public static final /* synthetic */ MutableLiveData access$getLoadingPredictionManager$p(SearchPlacesRepo $this) {
        return $this.loadingPredictionManager;
    }

    public static final /* synthetic */ MutableLiveData access$getListOfSearchResults$p(SearchPlacesRepo $this) {
        return $this.listOfSearchResults;
    }

    public static final /* synthetic */ MutableLiveData access$getLoadingPlaceManager$p(SearchPlacesRepo $this) {
        return $this.loadingPlaceManager;
    }

    public static final /* synthetic */ MutableLiveData access$getPlaceDetails$p(SearchPlacesRepo $this) {
        return $this.placeDetails;
    }

    public static final /* synthetic */ MutableLiveData access$getRecentSearchesManager$p(SearchPlacesRepo $this) {
        return $this.recentSearchesManager;
    }

    public static final /* synthetic */ MutableLiveData access$getRecentSearches$p(SearchPlacesRepo $this) {
        return $this.recentSearches;
    }

    public static final /* synthetic */ RecentSearchesDB access$initDb(SearchPlacesRepo $this) {
        return $this.initDb();
    }
}

