/*
 * Decompiled with CFR 0.152.
 */
package com.oneclickaway.opensource.placeautocomplete.ui;

import android.app.Activity;
import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModel;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.jakewharton.rxbinding2.widget.RxTextView;
import com.oneclickaway.opensource.placeautocomplete.R;
import com.oneclickaway.opensource.placeautocomplete.api.bean.place_details.Geometry;
import com.oneclickaway.opensource.placeautocomplete.api.bean.place_details.Location;
import com.oneclickaway.opensource.placeautocomplete.api.bean.place_details.PlaceDetails;
import com.oneclickaway.opensource.placeautocomplete.api.bean.places_response.PredictionsItem;
import com.oneclickaway.opensource.placeautocomplete.components.SearchPlacesStatusCodes;
import com.oneclickaway.opensource.placeautocomplete.components.SearchPlacesViewModel;
import com.oneclickaway.opensource.placeautocomplete.databinding.ActivitySearchPlaceBinding;
import com.oneclickaway.opensource.placeautocomplete.interfaces.PlaceClickListerner;
import com.oneclickaway.opensource.placeautocomplete.ui.SearchPlaceActivity;
import com.oneclickaway.opensource.placeautocomplete.ui.SearchResultAdapter;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Predicate;
import io.reactivex.observers.DisposableObserver;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.android.parcel.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0012\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0012H\u0014J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0012H\u0002J\b\u0010 \u001a\u00020\u0012H\u0002J\b\u0010!\u001a\u00020\u0012H\u0002J\b\u0010\"\u001a\u00020\u0012H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/ui/SearchPlaceActivity;", "Landroid/support/v7/app/AppCompatActivity;", "Lcom/oneclickaway/opensource/placeautocomplete/interfaces/PlaceClickListerner;", "Landroid/view/View$OnClickListener;", "()V", "apiKey", "", "binding", "Lcom/oneclickaway/opensource/placeautocomplete/databinding/ActivitySearchPlaceBinding;", "compositeDisposable", "Lio/reactivex/disposables/CompositeDisposable;", "enclosingRadius", "location", "searchListAdapter", "Lcom/oneclickaway/opensource/placeautocomplete/ui/SearchResultAdapter;", "viewModel", "Lcom/oneclickaway/opensource/placeautocomplete/components/SearchPlacesViewModel;", "attachLiveObservers", "", "initializeDependency", "onBackPressed", "onClick", "p0", "Landroid/view/View;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPlaceClicked", "candidateItem", "Lcom/oneclickaway/opensource/placeautocomplete/api/bean/places_response/PredictionsItem;", "setOnClickListeners", "setOnQueryChangeListener", "setRecyclerView", "setViewModel", "Config", "place_autocomplete_release"})
public final class SearchPlaceActivity
extends AppCompatActivity
implements PlaceClickListerner,
View.OnClickListener {
    private SearchPlacesViewModel viewModel;
    private ActivitySearchPlaceBinding binding;
    private CompositeDisposable compositeDisposable = new CompositeDisposable();
    private SearchResultAdapter searchListAdapter;
    private String apiKey;
    private String location;
    private String enclosingRadius;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ViewDataBinding viewDataBinding = DataBindingUtil.setContentView((Activity)((Activity)this), (int)R.layout.activity_search_place);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewDataBinding, (String)"DataBindingUtil.setConte\u2026ut.activity_search_place)");
        this.binding = (ActivitySearchPlaceBinding)viewDataBinding;
        this.initializeDependency();
        this.setViewModel();
        this.setOnClickListeners();
        this.setRecyclerView();
        this.setOnQueryChangeListener();
        this.attachLiveObservers();
    }

    private final void setOnClickListeners() {
        ActivitySearchPlaceBinding activitySearchPlaceBinding = this.binding;
        if (activitySearchPlaceBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        activitySearchPlaceBinding.backImageBtn.setOnClickListener((View.OnClickListener)this);
    }

    private final void initializeDependency() {
        if (this.getIntent().hasExtra(SearchPlacesStatusCodes.INSTANCE.getCONFIG())) {
            Config configuration;
            Intent intent = this.getIntent();
            Intrinsics.checkExpressionValueIsNotNull((Object)intent, (String)"intent");
            Bundle bundle = intent.getExtras();
            Config config = configuration = bundle != null ? (Config)bundle.getParcelable(SearchPlacesStatusCodes.INSTANCE.getCONFIG()) : null;
            this.apiKey = config != null ? config.getApiKey() : null;
            Config config2 = configuration;
            this.location = config2 != null ? config2.getLocation() : null;
            Config config3 = configuration;
            this.enclosingRadius = config3 != null ? config3.getEnclosingRadius() : null;
            ActivitySearchPlaceBinding activitySearchPlaceBinding = this.binding;
            if (activitySearchPlaceBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            }
            TextView textView = activitySearchPlaceBinding.searchTitleTV;
            Intrinsics.checkExpressionValueIsNotNull((Object)textView, (String)"binding.searchTitleTV");
            Config config4 = configuration;
            textView.setText((CharSequence)(config4 != null ? config4.getSearchBarTitle() : null));
        } else {
            Toast.makeText((Context)((Context)this), (CharSequence)"Please mention the api key in put-extra", (int)1).show();
            this.finish();
        }
    }

    private final void attachLiveObservers() {
        SearchPlacesViewModel searchPlacesViewModel = this.viewModel;
        if (searchPlacesViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        searchPlacesViewModel.getLiveListOfSearchResultsStream().observe((LifecycleOwner)this, (Observer)new Observer<List<? extends PredictionsItem>>(this){
            final /* synthetic */ SearchPlaceActivity this$0;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void onChanged(@Nullable List<PredictionsItem> it) {
                ProgressBar progressBar = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0).searchProgressBar;
                Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"binding.searchProgressBar");
                progressBar.setVisibility(8);
                SearchPlaceActivity.access$getSearchListAdapter$p(this.this$0).setSearchCandidates(it);
                List<PredictionsItem> list = it;
                if (list != null) {
                    if (list.size() == 0) {
                        EditText editText = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0).placeNamET;
                        Intrinsics.checkExpressionValueIsNotNull((Object)editText, (String)"binding.placeNamET");
                        CharSequence charSequence = editText.getText().toString();
                        boolean bl = false;
                        if (charSequence.length() > 0) {
                            LinearLayout linearLayout = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0).noPlacesFoundLL;
                            Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"binding.noPlacesFoundLL");
                            linearLayout.setVisibility(0);
                            Log.i((String)this.this$0.getClass().getSimpleName(), (String)"attachLiveObservers: List is empty!");
                            return;
                        } else {
                            LinearLayout linearLayout = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0).noPlacesFoundLL;
                            Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"binding.noPlacesFoundLL");
                            linearLayout.setVisibility(8);
                        }
                        return;
                    }
                }
                LinearLayout linearLayout = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0).noPlacesFoundLL;
                Intrinsics.checkExpressionValueIsNotNull((Object)linearLayout, (String)"binding.noPlacesFoundLL");
                linearLayout.setVisibility(8);
                Log.i((String)this.this$0.getClass().getSimpleName(), (String)"attachLiveObservers: List has contents!");
            }
            {
                this.this$0 = searchPlaceActivity;
            }
        });
        SearchPlacesViewModel searchPlacesViewModel2 = this.viewModel;
        if (searchPlacesViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        searchPlacesViewModel2.getPlaceDetailsLiveDataStream().observe((LifecycleOwner)this, (Observer)new Observer<PlaceDetails>(this){
            final /* synthetic */ SearchPlaceActivity this$0;

            public final void onChanged(@Nullable PlaceDetails it) {
                Object object;
                ProgressBar progressBar = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0).searchProgressBar;
                Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"binding.searchProgressBar");
                progressBar.setVisibility(8);
                Log.d((String)this.this$0.getClass().getSimpleName(), (String)("attachLiveObservers:  " + ((object = it) != null && (object = ((PlaceDetails)object).getGeometry()) != null && (object = ((Geometry)object).getLocation()) != null ? ((Location)object).getLat() : null) + ' ' + it + ' '));
                Intent resultData = new Intent();
                resultData.putExtra(SearchPlacesStatusCodes.INSTANCE.getPLACE_DATA(), (Parcelable)it);
                this.this$0.setResult(-1, resultData);
                if (Build.VERSION.SDK_INT >= 21) {
                    this.this$0.finishAfterTransition();
                } else {
                    this.this$0.finish();
                    this.this$0.overridePendingTransition(R.anim.abc_fade_in, R.anim.abc_fade_out);
                }
            }
            {
                this.this$0 = searchPlaceActivity;
            }
        });
    }

    private final void setViewModel() {
        ViewModel viewModel = ViewModelProviders.of((FragmentActivity)((FragmentActivity)this)).get(SearchPlacesViewModel.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)viewModel, (String)"ViewModelProviders.of(th\u2026cesViewModel::class.java)");
        this.viewModel = (SearchPlacesViewModel)viewModel;
    }

    private final void setOnQueryChangeListener() {
        ActivitySearchPlaceBinding activitySearchPlaceBinding = this.binding;
        if (activitySearchPlaceBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        this.compositeDisposable.add((Disposable)RxTextView.textChanges((TextView)((TextView)activitySearchPlaceBinding.placeNamET)).debounce(500L, TimeUnit.MILLISECONDS).filter((Predicate)new Predicate<CharSequence>(this){
            final /* synthetic */ SearchPlaceActivity this$0;

            public final boolean test(@NotNull CharSequence it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.this$0.runOnUiThread(new Runnable(this, it){
                    final /* synthetic */ setOnQueryChangeListener.1 this$0;
                    final /* synthetic */ CharSequence $it;

                    public final void run() {
                        CharSequence charSequence = ((Object)this.$it).toString();
                        boolean bl = false;
                        if (!StringsKt.isBlank((CharSequence)charSequence)) {
                            RecyclerView recyclerView = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0.this$0).searchResultsRV;
                            Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"binding.searchResultsRV");
                            recyclerView.setVisibility(0);
                        } else {
                            RecyclerView recyclerView = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0.this$0).searchResultsRV;
                            Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"binding.searchResultsRV");
                            recyclerView.setVisibility(8);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$it = charSequence;
                    }
                });
                CharSequence charSequence = ((Object)it).toString();
                boolean bl = false;
                return !StringsKt.isBlank((CharSequence)charSequence);
            }
            {
                this.this$0 = searchPlaceActivity;
            }
        }).observeOn(AndroidSchedulers.mainThread()).subscribeOn(Schedulers.io()).subscribeWith((io.reactivex.Observer)new DisposableObserver<CharSequence>(this){
            final /* synthetic */ SearchPlaceActivity this$0;

            public void onComplete() {
            }

            public void onNext(@NotNull CharSequence t) {
                String string;
                String string2;
                Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                Log.d((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("setOnQueryChangeListener: " + t));
                ProgressBar progressBar = SearchPlaceActivity.access$getBinding$p((SearchPlaceActivity)this.this$0).searchProgressBar;
                Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"binding.searchProgressBar");
                progressBar.setVisibility(0);
                SearchPlacesViewModel searchPlacesViewModel = SearchPlaceActivity.access$getViewModel$p(this.this$0);
                String string3 = ((Object)t).toString();
                String string4 = SearchPlaceActivity.access$getApiKey$p(this.this$0);
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                if ((string2 = SearchPlaceActivity.access$getLocation$p(this.this$0)) == null) {
                    string2 = "";
                }
                if ((string = SearchPlaceActivity.access$getEnclosingRadius$p(this.this$0)) == null) {
                    string = "500";
                }
                searchPlacesViewModel.requestListOfSearchResults(string3, string4, string2, string);
            }

            public void onError(@NotNull Throwable e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            }
            {
                this.this$0 = $outer;
            }
        }));
    }

    private final void setRecyclerView() {
        ActivitySearchPlaceBinding activitySearchPlaceBinding = this.binding;
        if (activitySearchPlaceBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        RecyclerView recyclerView = activitySearchPlaceBinding.searchResultsRV;
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView, (String)"binding.searchResultsRV");
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.searchListAdapter = new SearchResultAdapter(null, this, 1, null);
        ActivitySearchPlaceBinding activitySearchPlaceBinding2 = this.binding;
        if (activitySearchPlaceBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        RecyclerView recyclerView2 = activitySearchPlaceBinding2.searchResultsRV;
        Intrinsics.checkExpressionValueIsNotNull((Object)recyclerView2, (String)"binding.searchResultsRV");
        SearchResultAdapter searchResultAdapter = this.searchListAdapter;
        if (searchResultAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchListAdapter");
        }
        recyclerView2.setAdapter((RecyclerView.Adapter)searchResultAdapter);
    }

    @Override
    public void onPlaceClicked(@Nullable PredictionsItem candidateItem) {
        ActivitySearchPlaceBinding activitySearchPlaceBinding = this.binding;
        if (activitySearchPlaceBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        ProgressBar progressBar = activitySearchPlaceBinding.searchProgressBar;
        Intrinsics.checkExpressionValueIsNotNull((Object)progressBar, (String)"binding.searchProgressBar");
        progressBar.setVisibility(0);
        SearchPlacesViewModel searchPlacesViewModel = this.viewModel;
        if (searchPlacesViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        PredictionsItem predictionsItem = candidateItem;
        String string = String.valueOf(predictionsItem != null ? predictionsItem.getPlaceId() : null);
        String string2 = this.apiKey;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        searchPlacesViewModel.requestPlaceDetails(string, string2);
    }

    protected void onDestroy() {
        super.onDestroy();
        SearchPlacesViewModel searchPlacesViewModel = this.viewModel;
        if (searchPlacesViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        searchPlacesViewModel.clear();
        this.compositeDisposable.clear();
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(R.anim.abc_fade_in, R.anim.abc_fade_out);
    }

    public void onClick(@Nullable View p0) {
        Integer n;
        View view = p0;
        Integer n2 = n = view != null ? Integer.valueOf(view.getId()) : null;
        int n3 = R.id.backImageBtn;
        if (n2 != null && n2 == n3) {
            this.onBackPressed();
        }
    }

    public static final /* synthetic */ ActivitySearchPlaceBinding access$getBinding$p(SearchPlaceActivity $this) {
        ActivitySearchPlaceBinding activitySearchPlaceBinding = $this.binding;
        if (activitySearchPlaceBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        return activitySearchPlaceBinding;
    }

    public static final /* synthetic */ void access$setBinding$p(SearchPlaceActivity $this, ActivitySearchPlaceBinding activitySearchPlaceBinding) {
        $this.binding = activitySearchPlaceBinding;
    }

    public static final /* synthetic */ SearchResultAdapter access$getSearchListAdapter$p(SearchPlaceActivity $this) {
        SearchResultAdapter searchResultAdapter = $this.searchListAdapter;
        if (searchResultAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"searchListAdapter");
        }
        return searchResultAdapter;
    }

    public static final /* synthetic */ void access$setSearchListAdapter$p(SearchPlaceActivity $this, SearchResultAdapter searchResultAdapter) {
        $this.searchListAdapter = searchResultAdapter;
    }

    public static final /* synthetic */ SearchPlacesViewModel access$getViewModel$p(SearchPlaceActivity $this) {
        SearchPlacesViewModel searchPlacesViewModel = $this.viewModel;
        if (searchPlacesViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        return searchPlacesViewModel;
    }

    public static final /* synthetic */ void access$setViewModel$p(SearchPlaceActivity $this, SearchPlacesViewModel searchPlacesViewModel) {
        $this.viewModel = searchPlacesViewModel;
    }

    public static final /* synthetic */ String access$getApiKey$p(SearchPlaceActivity $this) {
        return $this.apiKey;
    }

    public static final /* synthetic */ void access$setApiKey$p(SearchPlaceActivity $this, String string) {
        $this.apiKey = string;
    }

    public static final /* synthetic */ String access$getLocation$p(SearchPlaceActivity $this) {
        return $this.location;
    }

    public static final /* synthetic */ void access$setLocation$p(SearchPlaceActivity $this, String string) {
        $this.location = string;
    }

    public static final /* synthetic */ String access$getEnclosingRadius$p(SearchPlaceActivity $this) {
        return $this.enclosingRadius;
    }

    public static final /* synthetic */ void access$setEnclosingRadius$p(SearchPlaceActivity $this, String string) {
        $this.enclosingRadius = string;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0019\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0013H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\t\"\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lcom/oneclickaway/opensource/placeautocomplete/ui/SearchPlaceActivity$Config;", "Landroid/os/Parcelable;", "apiKey", "", "location", "enclosingRadius", "searchBarTitle", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "setApiKey", "(Ljava/lang/String;)V", "getEnclosingRadius", "setEnclosingRadius", "getLocation", "setLocation", "getSearchBarTitle", "setSearchBarTitle", "describeContents", "", "writeToParcel", "", "parcel", "Landroid/os/Parcel;", "flags", "place_autocomplete_release"})
    @Parcelize
    public static final class Config
    implements Parcelable {
        @NotNull
        private String apiKey;
        @NotNull
        private String location;
        @NotNull
        private String enclosingRadius;
        @NotNull
        private String searchBarTitle;
        public static final Parcelable.Creator CREATOR = new Creator();

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.apiKey = string;
        }

        @NotNull
        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.location = string;
        }

        @NotNull
        public final String getEnclosingRadius() {
            return this.enclosingRadius;
        }

        public final void setEnclosingRadius(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.enclosingRadius = string;
        }

        @NotNull
        public final String getSearchBarTitle() {
            return this.searchBarTitle;
        }

        public final void setSearchBarTitle(@NotNull String string) {
            Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
            this.searchBarTitle = string;
        }

        public Config(@NotNull String apiKey, @NotNull String location, @NotNull String enclosingRadius, @NotNull String searchBarTitle) {
            Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            Intrinsics.checkParameterIsNotNull((Object)enclosingRadius, (String)"enclosingRadius");
            Intrinsics.checkParameterIsNotNull((Object)searchBarTitle, (String)"searchBarTitle");
            this.apiKey = apiKey;
            this.location = location;
            this.enclosingRadius = enclosingRadius;
            this.searchBarTitle = searchBarTitle;
        }

        public /* synthetic */ Config(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                string3 = "";
            }
            if ((n & 8) != 0) {
                string4 = "Enter Location";
            }
            this(string, string2, string3, string4);
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NotNull Parcel parcel, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
            parcel.writeString(this.apiKey);
            parcel.writeString(this.location);
            parcel.writeString(this.enclosingRadius);
            parcel.writeString(this.searchBarTitle);
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=3)
        public static final class Creator
        implements Parcelable.Creator {
            @NotNull
            public final Object[] newArray(int size) {
                return new Config[size];
            }

            @NotNull
            public final Object createFromParcel(@NotNull Parcel in) {
                Intrinsics.checkParameterIsNotNull((Object)in, (String)"in");
                return new Config(in.readString(), in.readString(), in.readString(), in.readString());
            }
        }
    }
}

