/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmBranchParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.scm.ReleaseScmRepositoryException;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.apache.maven.shared.release.util.ReleaseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmBranchPhase
extends AbstractReleasePhase {
    private ScmRepositoryConfigurator scmRepositoryConfigurator;

    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        BranchScmResult result;
        ScmProvider provider;
        ScmRepository repository;
        ReleaseResult relResult = new ReleaseResult();
        ScmBranchPhase.validateConfiguration(releaseDescriptor);
        ReleaseDescriptor basedirAlignedReleaseDescriptor = ReleaseUtil.createBasedirAlignedReleaseDescriptor(releaseDescriptor, reactorProjects);
        this.logInfo(relResult, "Branching release with the label " + basedirAlignedReleaseDescriptor.getScmReleaseLabel() + "...");
        try {
            repository = this.scmRepositoryConfigurator.getConfiguredRepository(basedirAlignedReleaseDescriptor.getScmSourceUrl(), releaseDescriptor, releaseEnvironment.getSettings());
            repository.getProviderRepository().setPushChanges(releaseDescriptor.isPushChanges());
            provider = this.scmRepositoryConfigurator.getRepositoryProvider(repository);
        }
        catch (ScmRepositoryException e) {
            throw new ReleaseScmRepositoryException(e.getMessage(), e.getValidationMessages());
        }
        catch (NoSuchScmProviderException e) {
            throw new ReleaseExecutionException("Unable to configure SCM repository: " + e.getMessage(), e);
        }
        try {
            ScmFileSet fileSet = new ScmFileSet(new File(basedirAlignedReleaseDescriptor.getWorkingDirectory()));
            String branchName = releaseDescriptor.getScmReleaseLabel();
            ScmBranchParameters scmBranchParameters = new ScmBranchParameters();
            scmBranchParameters.setMessage(releaseDescriptor.getScmCommentPrefix() + " copy for branch " + branchName);
            scmBranchParameters.setRemoteBranching(releaseDescriptor.isRemoteTagging());
            scmBranchParameters.setScmRevision(releaseDescriptor.getScmReleasedPomRevision());
            result = provider.branch(repository, fileSet, branchName, scmBranchParameters);
        }
        catch (ScmException e) {
            throw new ReleaseExecutionException("An error is occurred in the branch process: " + e.getMessage(), e);
        }
        if (!result.isSuccess()) {
            throw new ReleaseScmCommandException("Unable to branch SCM", result);
        }
        relResult.setResultCode(0);
        return relResult;
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseResult result = new ReleaseResult();
        ScmBranchPhase.validateConfiguration(releaseDescriptor);
        ReleaseDescriptor basedirAlignedReleaseDescriptor = ReleaseUtil.createBasedirAlignedReleaseDescriptor(releaseDescriptor, reactorProjects);
        this.logInfo(result, "Full run would be branching " + basedirAlignedReleaseDescriptor.getWorkingDirectory());
        if (releaseDescriptor.getScmBranchBase() != null) {
            this.logInfo(result, "  To SCM URL: " + releaseDescriptor.getScmBranchBase());
        }
        this.logInfo(result, "  with label: '" + releaseDescriptor.getScmReleaseLabel() + "'");
        result.setResultCode(0);
        return result;
    }

    private static void validateConfiguration(ReleaseDescriptor releaseDescriptor) throws ReleaseFailureException {
        if (releaseDescriptor.getScmReleaseLabel() == null) {
            throw new ReleaseFailureException("A release label is required for committing");
        }
    }
}

