/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.phase.AbstractReleasePomsPhase;
import org.apache.maven.shared.release.scm.ReleaseScmCommandException;
import org.apache.maven.shared.release.util.ReleaseUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveReleasePomsPhase
extends AbstractReleasePomsPhase {
    @Override
    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseFailureException, ReleaseExecutionException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects, false);
    }

    @Override
    public ReleaseResult simulate(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects) throws ReleaseFailureException, ReleaseExecutionException {
        return this.execute(releaseDescriptor, releaseEnvironment, reactorProjects, true);
    }

    private ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, List<MavenProject> reactorProjects, boolean simulate) throws ReleaseFailureException, ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        if (releaseDescriptor.isGenerateReleasePoms()) {
            this.removeReleasePoms(releaseDescriptor, releaseEnvironment, simulate, result, reactorProjects);
        } else {
            this.logInfo(result, "Not removing release POMs");
        }
        result.setResultCode(0);
        return result;
    }

    private void removeReleasePoms(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, boolean simulate, ReleaseResult result, List<MavenProject> projects) throws ReleaseFailureException, ReleaseExecutionException {
        ArrayList<File> releasePoms = new ArrayList<File>();
        for (MavenProject project : projects) {
            this.logInfo(result, "Removing release POM for '" + project.getName() + "'...");
            releasePoms.add(ReleaseUtil.getReleasePom(project));
        }
        if (releaseDescriptor.isSuppressCommitBeforeTagOrBranch()) {
            this.removeReleasePomsFromFilesystem(simulate, result, releasePoms);
        } else {
            this.removeReleasePomsFromScm(releaseDescriptor, releaseEnvironment, simulate, result, releasePoms);
        }
    }

    private void removeReleasePomsFromFilesystem(boolean simulate, ReleaseResult result, List<File> releasePoms) {
        if (simulate) {
            this.logInfo(result, "Full run would be removing " + releasePoms);
        } else {
            for (File releasePom : releasePoms) {
                releasePom.delete();
            }
        }
    }

    private void removeReleasePomsFromScm(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, boolean simulate, ReleaseResult result, List<File> releasePoms) throws ReleaseFailureException, ReleaseExecutionException {
        if (simulate) {
            this.logInfo(result, "Full run would be removing " + releasePoms);
        } else {
            ScmRepository scmRepository = this.getScmRepository(releaseDescriptor, releaseEnvironment);
            ScmProvider scmProvider = this.getScmProvider(scmRepository);
            ScmFileSet scmFileSet = new ScmFileSet(new File(releaseDescriptor.getWorkingDirectory()), releasePoms);
            try {
                RemoveScmResult scmResult = scmProvider.remove(scmRepository, scmFileSet, "Removing for next development iteration.");
                if (!scmResult.isSuccess()) {
                    throw new ReleaseScmCommandException("Cannot remove release POMs from SCM", scmResult);
                }
            }
            catch (ScmException exception) {
                throw new ReleaseExecutionException("Cannot remove release POMs from SCM: " + exception.getMessage(), exception);
            }
        }
    }
}

