/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.InvokerLogger;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.AbstractMavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.cli.CommandLineUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokerMavenExecutor
extends AbstractMavenExecutor {
    private static final Options OPTIONS = new Options();
    private static final char SET_SYSTEM_PROPERTY = 'D';
    private static final char OFFLINE = 'o';
    private static final char REACTOR = 'r';
    private static final char QUIET = 'q';
    private static final char DEBUG = 'X';
    private static final char ERRORS = 'e';
    private static final char NON_RECURSIVE = 'N';
    private static final char UPDATE_SNAPSHOTS = 'U';
    private static final char ACTIVATE_PROFILES = 'P';
    private static final String FORCE_PLUGIN_UPDATES = "cpu";
    private static final String FORCE_PLUGIN_UPDATES2 = "up";
    private static final String SUPPRESS_PLUGIN_UPDATES = "npu";
    private static final String SUPPRESS_PLUGIN_REGISTRY = "npr";
    private static final char CHECKSUM_FAILURE_POLICY = 'C';
    private static final char CHECKSUM_WARNING_POLICY = 'c';
    private static final char ALTERNATE_USER_SETTINGS = 's';
    private static final String ALTERNATE_GLOBAL_SETTINGS = "gs";
    private static final String FAIL_FAST = "ff";
    private static final String FAIL_AT_END = "fae";
    private static final String FAIL_NEVER = "fn";
    private static final String ALTERNATE_POM_FILE = "f";
    private static final String THREADS = "T";

    protected void setupRequest(InvocationRequest req, InvokerLogger bridge, String additionalArguments) throws MavenExecutorException {
        try {
            String[] profiles;
            String[] args = CommandLineUtils.translateCommandline(additionalArguments);
            CommandLine cli = new PosixParser().parse(OPTIONS, args);
            if (cli.hasOption('D')) {
                String[] properties = cli.getOptionValues('D');
                Properties props = new Properties();
                for (int i = 0; i < properties.length; ++i) {
                    String value;
                    String name;
                    String property = properties[i];
                    int sep = property.indexOf("=");
                    if (sep <= 0) {
                        name = property.trim();
                        value = "true";
                    } else {
                        name = property.substring(0, sep).trim();
                        value = property.substring(sep + 1).trim();
                    }
                    props.setProperty(name, value);
                }
                req.setProperties(props);
            }
            if (cli.hasOption('o')) {
                req.setOffline(true);
            }
            if (cli.hasOption('q')) {
                req.setDebug(false);
            } else if (cli.hasOption('X')) {
                req.setDebug(true);
            } else if (cli.hasOption('e')) {
                req.setShowErrors(true);
            }
            if (cli.hasOption('r')) {
                req.setRecursive(true);
            } else if (cli.hasOption('N')) {
                req.setRecursive(false);
            }
            if (cli.hasOption('U')) {
                req.setUpdateSnapshots(true);
            }
            if (cli.hasOption('P') && (profiles = cli.getOptionValues('P')) != null) {
                req.setProfiles(Arrays.asList(profiles));
            }
            if (cli.hasOption(FORCE_PLUGIN_UPDATES) || cli.hasOption(FORCE_PLUGIN_UPDATES2)) {
                this.getLogger().warn("Forcing plugin updates is not supported currently.");
            } else if (cli.hasOption(SUPPRESS_PLUGIN_UPDATES)) {
                req.setNonPluginUpdates(true);
            }
            if (cli.hasOption(SUPPRESS_PLUGIN_REGISTRY)) {
                this.getLogger().warn("Explicit suppression of the plugin registry is not supported currently.");
            }
            if (cli.hasOption('C')) {
                req.setGlobalChecksumPolicy("fail");
            } else if (cli.hasOption('c')) {
                req.setGlobalChecksumPolicy("warn");
            }
            if (cli.hasOption('s')) {
                req.setUserSettingsFile(new File(cli.getOptionValue('s')));
            }
            if (cli.hasOption(ALTERNATE_GLOBAL_SETTINGS)) {
                req.setGlobalSettingsFile(new File(cli.getOptionValue(ALTERNATE_GLOBAL_SETTINGS)));
            }
            if (cli.hasOption(FAIL_AT_END)) {
                req.setFailureBehavior("fail-at-end");
            } else if (cli.hasOption(FAIL_FAST)) {
                req.setFailureBehavior("fail-fast");
            }
            if (cli.hasOption(FAIL_NEVER)) {
                req.setFailureBehavior("fail-never");
            }
            if (cli.hasOption(ALTERNATE_POM_FILE)) {
                if (req.getPomFileName() != null) {
                    this.getLogger().info("pomFileName is already set, ignoring the -f argument");
                } else {
                    req.setPomFileName(cli.getOptionValue(ALTERNATE_POM_FILE));
                }
            }
            if (cli.hasOption(THREADS)) {
                req.setThreads(cli.getOptionValue(THREADS));
            }
        }
        catch (Exception e) {
            throw new MavenExecutorException("Failed to re-parse additional arguments for Maven invocation.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeGoals(File workingDirectory, List<String> goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult result) throws MavenExecutorException {
        File settingsFile;
        InvocationRequest req;
        Invoker invoker;
        InvokerLogger bridge;
        block15: {
            InvocationOutputHandler handler = this.getOutputHandler();
            bridge = this.getInvokerLogger();
            invoker = new DefaultInvoker().setMavenHome(releaseEnvironment.getMavenHome()).setLogger(bridge).setOutputHandler(handler).setErrorHandler(handler);
            req = new DefaultInvocationRequest().setDebug(this.getLogger().isDebugEnabled()).setBaseDirectory(workingDirectory).setInteractive(interactive);
            if (pomFileName != null) {
                req.setPomFileName(pomFileName);
            }
            settingsFile = null;
            if (releaseEnvironment.getSettings() == null) break block15;
            try {
                settingsFile = File.createTempFile("release-settings", ".xml");
                SettingsXpp3Writer writer = this.getSettingsWriter();
                FileWriter fileWriter = null;
                try {
                    fileWriter = new FileWriter(settingsFile);
                    writer.write(fileWriter, this.encryptSettings(releaseEnvironment.getSettings()));
                }
                catch (Throwable throwable) {
                    IOUtil.close(fileWriter);
                    throw throwable;
                }
                IOUtil.close(fileWriter);
                req.setUserSettingsFile(settingsFile);
            }
            catch (IOException e) {
                throw new MavenExecutorException("Could not create temporary file for release settings.xml", e);
            }
        }
        try {
            File localRepoDir = releaseEnvironment.getLocalRepositoryDirectory();
            if (localRepoDir != null) {
                req.setLocalRepositoryDirectory(localRepoDir);
            }
            this.setupRequest(req, bridge, additionalArguments);
            req.setGoals(goals);
            try {
                InvocationResult invocationResult = invoker.execute(req);
                if (invocationResult.getExecutionException() != null) {
                    throw new MavenExecutorException("Error executing Maven.", invocationResult.getExecutionException());
                }
                if (invocationResult.getExitCode() != 0) {
                    throw new MavenExecutorException("Maven execution failed, exit code: '" + invocationResult.getExitCode() + "'", invocationResult.getExitCode(), "", "");
                }
            }
            catch (MavenInvocationException e) {
                throw new MavenExecutorException("Failed to invoke Maven build.", e);
            }
        }
        finally {
            if (settingsFile != null && settingsFile.exists() && !settingsFile.delete()) {
                settingsFile.deleteOnExit();
            }
        }
    }

    protected InvokerLogger getInvokerLogger() {
        return new LoggerBridge(this.getLogger());
    }

    protected InvocationOutputHandler getOutputHandler() {
        return new Handler(this.getLogger());
    }

    static {
        OptionBuilder.withLongOpt("define");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Define a system property");
        OPTIONS.addOption(OptionBuilder.create('D'));
        OptionBuilder.withLongOpt("offline");
        OptionBuilder.withDescription("Work offline");
        OPTIONS.addOption(OptionBuilder.create('o'));
        OptionBuilder.withLongOpt("quiet");
        OptionBuilder.withDescription("Quiet output - only show errors");
        OPTIONS.addOption(OptionBuilder.create('q'));
        OptionBuilder.withLongOpt("debug");
        OptionBuilder.withDescription("Produce execution debug output");
        OPTIONS.addOption(OptionBuilder.create('X'));
        OptionBuilder.withLongOpt("errors");
        OptionBuilder.withDescription("Produce execution error messages");
        OPTIONS.addOption(OptionBuilder.create('e'));
        OptionBuilder.withLongOpt("reactor");
        OptionBuilder.withDescription("Execute goals for project found in the reactor");
        OPTIONS.addOption(OptionBuilder.create('r'));
        OptionBuilder.withLongOpt("non-recursive");
        OptionBuilder.withDescription("Do not recurse into sub-projects");
        OPTIONS.addOption(OptionBuilder.create('N'));
        OptionBuilder.withLongOpt("update-snapshots");
        OptionBuilder.withDescription("Forces a check for updated releases and snapshots on remote repositories");
        OPTIONS.addOption(OptionBuilder.create('U'));
        OptionBuilder.withLongOpt("activate-profiles");
        OptionBuilder.withDescription("Comma-delimited list of profiles to activate");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create('P'));
        OptionBuilder.withLongOpt("check-plugin-updates");
        OptionBuilder.withDescription("Force upToDate check for any relevant registered plugins");
        OPTIONS.addOption(OptionBuilder.create(FORCE_PLUGIN_UPDATES));
        OptionBuilder.withLongOpt("update-plugins");
        OptionBuilder.withDescription("Synonym for cpu");
        OPTIONS.addOption(OptionBuilder.create(FORCE_PLUGIN_UPDATES2));
        OptionBuilder.withLongOpt("no-plugin-updates");
        OptionBuilder.withDescription("Suppress upToDate check for any relevant registered plugins");
        OPTIONS.addOption(OptionBuilder.create(SUPPRESS_PLUGIN_UPDATES));
        OptionBuilder.withLongOpt("no-plugin-registry");
        OptionBuilder.withDescription("Don't use ~/.m2/plugin-registry.xml for plugin versions");
        OPTIONS.addOption(OptionBuilder.create(SUPPRESS_PLUGIN_REGISTRY));
        OptionBuilder.withLongOpt("strict-checksums");
        OptionBuilder.withDescription("Fail the build if checksums don't match");
        OPTIONS.addOption(OptionBuilder.create('C'));
        OptionBuilder.withLongOpt("lax-checksums");
        OptionBuilder.withDescription("Warn if checksums don't match");
        OPTIONS.addOption(OptionBuilder.create('c'));
        OptionBuilder.withLongOpt("settings");
        OptionBuilder.withDescription("Alternate path for the user settings file");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create('s'));
        OptionBuilder.withLongOpt("global-settings");
        OptionBuilder.withDescription(" Alternate path for the global settings file");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create(ALTERNATE_GLOBAL_SETTINGS));
        OptionBuilder.withLongOpt("fail-fast");
        OptionBuilder.withDescription("Stop at first failure in reactorized builds");
        OPTIONS.addOption(OptionBuilder.create(FAIL_FAST));
        OptionBuilder.withLongOpt("fail-at-end");
        OptionBuilder.withDescription("Only fail the build afterwards; allow all non-impacted builds to continue");
        OPTIONS.addOption(OptionBuilder.create(FAIL_AT_END));
        OptionBuilder.withLongOpt("fail-never");
        OptionBuilder.withDescription("NEVER fail the build, regardless of project result");
        OPTIONS.addOption(OptionBuilder.create(FAIL_NEVER));
        OptionBuilder.withLongOpt("file");
        OptionBuilder.withDescription("Force the use of an alternate POM file.");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create(ALTERNATE_POM_FILE));
        OptionBuilder.withLongOpt("threads");
        OptionBuilder.withDescription("Thread count, for instance 2.0C where C is core multiplied");
        OptionBuilder.hasArg();
        OPTIONS.addOption(OptionBuilder.create(THREADS));
    }

    private static final class LoggerBridge
    implements InvokerLogger {
        private Logger logger;

        LoggerBridge(Logger logger) {
            this.logger = logger;
        }

        public void debug(String message, Throwable error) {
            this.logger.debug(message, error);
        }

        public void debug(String message) {
            this.logger.debug(message);
        }

        public void error(String message, Throwable error) {
            this.logger.error(message, error);
        }

        public void error(String message) {
            this.logger.error(message);
        }

        public void fatalError(String message, Throwable error) {
            this.logger.fatalError(message, error);
        }

        public void fatalError(String message) {
            this.logger.fatalError(message);
        }

        public Logger getChildLogger(String message) {
            return this.logger.getChildLogger(message);
        }

        public String getName() {
            return this.logger.getName();
        }

        public int getThreshold() {
            return this.logger.getThreshold();
        }

        public void info(String message, Throwable error) {
            this.logger.info(message, error);
        }

        public void info(String message) {
            this.logger.info(message);
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        public boolean isFatalErrorEnabled() {
            return this.logger.isFatalErrorEnabled();
        }

        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void setThreshold(int level) {
        }

        public void warn(String message, Throwable error) {
            this.logger.warn(message, error);
        }

        public void warn(String message) {
            this.logger.warn(message);
        }
    }

    private static final class Handler
    implements InvocationOutputHandler {
        private Logger logger;

        Handler(Logger logger) {
            this.logger = logger;
        }

        public void consumeLine(String line) {
            this.logger.info(line);
        }
    }
}

