/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.exec;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.codehaus.plexus.logging.LogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMavenExecutor
implements MavenExecutor,
LogEnabled {
    private Logger logger;
    private DefaultSecDispatcher secDispatcher;
    private PlexusCipher cipher;

    protected AbstractMavenExecutor() {
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult result) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, (ReleaseEnvironment)new DefaultReleaseEnvironment(), interactive, additionalArguments, pomFileName, result);
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, boolean interactive, String additionalArguments, ReleaseResult result) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, new DefaultReleaseEnvironment(), interactive, additionalArguments, result);
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String arguments, ReleaseResult result) throws MavenExecutorException {
        this.executeGoals(workingDirectory, goals, releaseEnvironment, interactive, arguments, null, result);
    }

    @Override
    public void executeGoals(File workingDirectory, String goals, ReleaseEnvironment releaseEnvironment, boolean interactive, String additionalArguments, String pomFileName, ReleaseResult result) throws MavenExecutorException {
        ArrayList<String> goalsList = new ArrayList<String>();
        if (goals != null) {
            String[] tokens = StringUtils.split(goals, ", \n\r\t");
            for (int i = 0; i < tokens.length; ++i) {
                goalsList.add(tokens[i]);
            }
        }
        this.executeGoals(workingDirectory, goalsList, releaseEnvironment, interactive, additionalArguments, pomFileName, result);
    }

    protected abstract void executeGoals(File var1, List<String> var2, ReleaseEnvironment var3, boolean var4, String var5, String var6, ReleaseResult var7) throws MavenExecutorException;

    protected final Logger getLogger() {
        return this.logger;
    }

    @Override
    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    protected Settings encryptSettings(Settings settings) {
        String password;
        Settings encryptedSettings = SettingsUtils.copySettings(settings);
        for (Server server : encryptedSettings.getServers()) {
            String passphrase;
            password = server.getPassword();
            if (password != null && !this.isEncryptedString(password)) {
                try {
                    server.setPassword(this.encryptAndDecorate(password));
                }
                catch (IllegalStateException e) {
                }
                catch (SecDispatcherException e) {
                }
                catch (PlexusCipherException e) {
                    // empty catch block
                }
            }
            if ((passphrase = server.getPassphrase()) == null || this.isEncryptedString(passphrase)) continue;
            try {
                server.setPassphrase(this.encryptAndDecorate(passphrase));
            }
            catch (IllegalStateException e) {
            }
            catch (SecDispatcherException e) {
            }
            catch (PlexusCipherException e) {}
        }
        for (Proxy proxy : encryptedSettings.getProxies()) {
            password = proxy.getPassword();
            if (password == null || this.isEncryptedString(password)) continue;
            try {
                proxy.setPassword(this.encryptAndDecorate(password));
            }
            catch (IllegalStateException e) {
            }
            catch (SecDispatcherException e) {
            }
            catch (PlexusCipherException e) {}
        }
        return encryptedSettings;
    }

    private final String encryptAndDecorate(String passwd) throws IllegalStateException, SecDispatcherException, PlexusCipherException {
        String configurationFile = this.secDispatcher.getConfigurationFile();
        if (configurationFile.startsWith("~")) {
            configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
        }
        String file = System.getProperty("settings.security", configurationFile);
        String master = null;
        SettingsSecurity sec = SecUtil.read(file, true);
        if (sec != null) {
            master = sec.getMaster();
        }
        if (master == null) {
            throw new IllegalStateException("Master password is not set in the setting security file: " + file);
        }
        DefaultPlexusCipher cipher = new DefaultPlexusCipher();
        String masterPasswd = cipher.decryptDecorated(master, "settings.security");
        return cipher.encryptAndDecorate(passwd, masterPasswd);
    }

    private boolean isEncryptedString(String str) {
        return this.cipher.isEncryptedString(str);
    }

    protected SettingsXpp3Writer getSettingsWriter() {
        return new SettingsXpp3Writer();
    }
}

