/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater.task.executor;

import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.deployments.execution.DeploymentTaskContext;
import com.atlassian.bamboo.plugins.variable.updater.VariableUpdater;
import com.atlassian.bamboo.plugins.variable.updater.task.executor.VersionVariableTask;
import com.atlassian.bamboo.task.CommonTaskContext;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskException;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskResultBuilder;
import com.atlassian.bamboo.v2.build.agent.remote.RemoteAgent;
import com.atlassian.bamboo.variable.VariableContext;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ReadFileVariableTask
extends VersionVariableTask {
    public static final String FILENAME_CONFIG_KEY = "filename";

    @Override
    @NotNull
    public TaskResult executeTask(@NotNull CommonTaskContext taskContext) throws TaskException {
        ResultKey resultKey;
        String planKeyOrEnvironmentId;
        String variableName = (String)taskContext.getConfigurationMap().get((Object)"variable");
        VariableUpdater.SCOPE variableScope = VariableUpdater.SCOPE.valueOf(((String)taskContext.getConfigurationMap().get((Object)"variableScope")).toUpperCase());
        boolean includeGlobals = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"includeGlobals"));
        boolean useBranchVariables = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"branchVars"));
        String fileName = (String)taskContext.getConfigurationMap().get((Object)FILENAME_CONFIG_KEY);
        boolean keepCustomised = Boolean.parseBoolean((String)taskContext.getConfigurationMap().get((Object)"overrideCustomised"));
        BuildLogger buildLogger = taskContext.getBuildLogger();
        if (taskContext instanceof DeploymentTaskContext) {
            DeploymentTaskContext deploymentTaskContext = (DeploymentTaskContext)taskContext;
            long deploymentEnvironmentId = deploymentTaskContext.getDeploymentContext().getEnvironmentId();
            planKeyOrEnvironmentId = String.valueOf(deploymentEnvironmentId);
            resultKey = deploymentTaskContext.getDeploymentContext().getResultKey();
        } else if (taskContext instanceof TaskContext) {
            TaskContext tContext = (TaskContext)taskContext;
            planKeyOrEnvironmentId = tContext.getBuildContext().getParentBuildContext().getPlanKey();
            resultKey = tContext.getBuildContext().getResultKey();
        } else {
            throw new TaskException("TaskContext not defined: " + taskContext.getClass().getName());
        }
        Map buildCustomVariables = taskContext.getCommonContext().getCurrentResult().getCustomBuildData();
        VariableContext variableContext = taskContext.getCommonContext().getVariableContext();
        String currentValue = this.retrieveCurrentValue(variableName, buildCustomVariables, variableContext, taskContext.getBuildLogger());
        VariableUpdater.SAVE_STRATEGY strategy = this.retrieveStrategy(variableName, keepCustomised, variableContext);
        if (strategy == VariableUpdater.SAVE_STRATEGY.SKIP) {
            return this.skipUpdatingIfConflictWithCustomVariables(taskContext, variableName);
        }
        VariableUpdater updater = new VariableUpdater(resultKey, taskContext.getWorkingDirectory().getAbsolutePath(), buildCustomVariables);
        updater.readFromFile(planKeyOrEnvironmentId, variableName, currentValue, includeGlobals, variableScope, strategy, fileName, RemoteAgent.getContext() != null, buildLogger, variableContext, useBranchVariables);
        return TaskResultBuilder.newBuilder((CommonTaskContext)taskContext).success().build();
    }
}

