/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.variable.updater.task.configuration;

import com.atlassian.bamboo.collections.ActionParametersMap;
import com.atlassian.bamboo.plugins.variable.updater.VariableUpdater;
import com.atlassian.bamboo.task.AbstractTaskConfigurator;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VersionVariableTaskConfigurator
extends AbstractTaskConfigurator {
    void populateLists(@NotNull Map<String, Object> context) {
        ImmutableMap variableScopeOptions = new ImmutableMap.Builder().put((Object)VariableUpdater.SCOPE.JOB.name(), (Object)this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.scope.job")).put((Object)VariableUpdater.SCOPE.RESULT.name(), (Object)this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.scope.result")).put((Object)VariableUpdater.SCOPE.PLAN.name(), (Object)this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.scope.plan")).build();
        context.put("variableScopeOptions", variableScopeOptions);
    }

    @NotNull
    public Map<String, String> generateTaskConfigMap(@NotNull ActionParametersMap params, @Nullable TaskDefinition previousTaskDefinition) {
        Map config = super.generateTaskConfigMap(params, previousTaskDefinition);
        config.put("variable", params.getString("variable"));
        config.put("includeGlobals", params.getString("includeGlobals"));
        config.put("overrideCustomised", params.getString("overrideCustomised"));
        config.put("variableScope", params.getString("variableScope"));
        config.put("branchVars", params.getString("branchVars"));
        return config;
    }

    public void populateContextForCreate(@NotNull Map<String, Object> context) {
        super.populateContextForCreate(context);
        context.put("variable", "");
        context.put("includeGlobals", false);
        context.put("branchVars", false);
        context.put("overrideCustomised", false);
        context.put("variableScope", (Object)VariableUpdater.SCOPE.JOB);
        this.populateLists(context);
    }

    public void populateContextForEdit(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForEdit(context, taskDefinition);
        context.put("variable", taskDefinition.getConfiguration().get("variable"));
        context.put("includeGlobals", taskDefinition.getConfiguration().get("includeGlobals"));
        context.put("branchVars", taskDefinition.getConfiguration().get("branchVars"));
        context.put("overrideCustomised", taskDefinition.getConfiguration().get("overrideCustomised"));
        context.put("variableScope", taskDefinition.getConfiguration().get("variableScope"));
        this.populateLists(context);
    }

    public void populateContextForView(@NotNull Map<String, Object> context, @NotNull TaskDefinition taskDefinition) {
        super.populateContextForView(context, taskDefinition);
        context.put("variable", taskDefinition.getConfiguration().get("variable"));
        context.put("includeGlobals", taskDefinition.getConfiguration().get("includeGlobals"));
        context.put("branchVars", taskDefinition.getConfiguration().get("branchVars"));
        context.put("overrideCustomised", taskDefinition.getConfiguration().get("overrideCustomised"));
        context.put("variableScope", taskDefinition.getConfiguration().get("variableScope"));
    }

    public void validate(@NotNull ActionParametersMap params, @NotNull ErrorCollection errorCollection) {
        super.validate(params, errorCollection);
        if (params.getString("variable") == null || params.getString("variable").isEmpty()) {
            errorCollection.addError("variable", this.getI18nBean().getText("com.atlassian.bamboo.plugins.variable.updater.empty.error"));
        }
    }
}

