/*
 * Decompiled with CFR 0.152.
 */
package com.opensooq.pluto.listeners;

import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import com.opensooq.pluto.listeners.ListUtils;
import com.opensooq.pluto.listeners.OnSnapPositionChangeListener;

public class SnapOnScrollListener
extends RecyclerView.OnScrollListener {
    private int snapPosition = -1;
    OnSnapPositionChangeListener mOnSnapPositionChangeListener;
    SnapHelper mSnapHelper;

    public SnapOnScrollListener(SnapHelper snapHelper, OnSnapPositionChangeListener onSnapPositionChangeListener) {
        this.mOnSnapPositionChangeListener = onSnapPositionChangeListener;
        this.mSnapHelper = snapHelper;
    }

    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        boolean snapPositionChanged;
        int snapPosition = ListUtils.getSnapPosition(recyclerView, this.mSnapHelper);
        boolean bl = snapPositionChanged = this.snapPosition != snapPosition && snapPosition != -1;
        if (snapPositionChanged) {
            this.mOnSnapPositionChangeListener.onSnapPositionChange(snapPosition);
            this.snapPosition = snapPosition;
        }
    }
}

