/*
 * Decompiled with CFR 0.152.
 */
package com.opensooq.pluto;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SnapHelper;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.opensooq.pluto.R;
import com.opensooq.pluto.base.PlutoAdapter;
import com.opensooq.pluto.listeners.SnapOnScrollListener;
import java.util.ArrayList;

public class PlutoIndicator
extends LinearLayout {
    private Context mContext;
    private RecyclerView mRecyclerView;
    private ImageView mPreviousSelectedIndicator;
    private int mPreviousSelectedPosition;
    private int mUserSetUnSelectedIndicatorResId;
    private int mUserSetSelectedIndicatorResId;
    private Drawable mSelectedDrawable;
    private Drawable mUnselectedDrawable;
    SnapOnScrollListener snapOnScrollListener;
    private int mItemCount = 0;
    private boolean isVisible = true;
    boolean indicatorVisibility;
    private GradientDrawable mUnSelectedGradientDrawable;
    private GradientDrawable mSelectedGradientDrawable;
    private LayerDrawable mSelectedLayerDrawable;
    private LayerDrawable mUnSelectedLayerDrawable;
    private float mSelectedPadding_Left;
    private float mSelectedPadding_Right;
    private float mSelectedPadding_Top;
    private float mSelectedPadding_Bottom;
    private float mUnSelectedPadding_Left;
    private float mUnSelectedPadding_Right;
    private float mUnSelectedPadding_Top;
    private float mUnSelectedPadding_Bottom;
    private ArrayList<ImageView> mIndicators = new ArrayList();
    private RecyclerView.AdapterDataObserver mDataObserver;

    public PlutoIndicator(Context context) {
        this(context, null);
    }

    public PlutoIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.PlutoIndicator, 0, 0);
        this.indicatorVisibility = attributes.getBoolean(R.styleable.PlutoIndicator_visibility, true);
        int shape = attributes.getInt(R.styleable.PlutoIndicator_shape, Shape.Oval.ordinal());
        Shape indicatorShape = Shape.Oval;
        for (Shape s : Shape.values()) {
            if (s.ordinal() != shape) continue;
            indicatorShape = s;
            break;
        }
        this.mUserSetSelectedIndicatorResId = attributes.getResourceId(R.styleable.PlutoIndicator_selected_drawable, 0);
        this.mUserSetUnSelectedIndicatorResId = attributes.getResourceId(R.styleable.PlutoIndicator_unselected_drawable, 0);
        int defaultSelectedColor = attributes.getColor(R.styleable.PlutoIndicator_selected_color, Color.rgb((int)255, (int)255, (int)255));
        int defaultUnSelectedColor = attributes.getColor(R.styleable.PlutoIndicator_unselected_color, Color.argb((int)33, (int)255, (int)255, (int)255));
        float defaultSelectedWidth = attributes.getDimension(R.styleable.PlutoIndicator_selected_width, (float)((int)this.pxFromDp(6.0f)));
        float defaultSelectedHeight = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_selected_height, (int)this.pxFromDp(6.0f));
        float defaultUnSelectedWidth = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_unselected_width, (int)this.pxFromDp(6.0f));
        float defaultUnSelectedHeight = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_unselected_height, (int)this.pxFromDp(6.0f));
        this.mSelectedGradientDrawable = new GradientDrawable();
        this.mUnSelectedGradientDrawable = new GradientDrawable();
        float padding_left = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_padding_left, (int)this.pxFromDp(3.0f));
        float padding_right = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_padding_right, (int)this.pxFromDp(3.0f));
        float padding_top = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_padding_top, (int)this.pxFromDp(0.0f));
        float padding_bottom = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_padding_bottom, (int)this.pxFromDp(0.0f));
        this.mSelectedPadding_Left = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_selected_padding_left, (int)padding_left);
        this.mSelectedPadding_Right = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_selected_padding_right, (int)padding_right);
        this.mSelectedPadding_Top = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_selected_padding_top, (int)padding_top);
        this.mSelectedPadding_Bottom = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_selected_padding_bottom, (int)padding_bottom);
        this.mUnSelectedPadding_Left = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_unselected_padding_left, (int)padding_left);
        this.mUnSelectedPadding_Right = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_unselected_padding_right, (int)padding_right);
        this.mUnSelectedPadding_Top = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_unselected_padding_top, (int)padding_top);
        this.mUnSelectedPadding_Bottom = attributes.getDimensionPixelSize(R.styleable.PlutoIndicator_unselected_padding_bottom, (int)padding_bottom);
        this.mSelectedLayerDrawable = new LayerDrawable(new Drawable[]{this.mSelectedGradientDrawable});
        this.mUnSelectedLayerDrawable = new LayerDrawable(new Drawable[]{this.mUnSelectedGradientDrawable});
        this.initObserver();
        this.setIndicatorDrawableRes(this.mUserSetSelectedIndicatorResId, this.mUserSetUnSelectedIndicatorResId);
        this.setDefaultIndicatorShape(indicatorShape);
        this.setDefaultSelectedIndicatorSize(defaultSelectedWidth, defaultSelectedHeight, Unit.Px);
        this.setDefaultUnselectedIndicatorSize(defaultUnSelectedWidth, defaultUnSelectedHeight, Unit.Px);
        this.setDefaultIndicatorColor(defaultSelectedColor, defaultUnSelectedColor);
        this.setVisibility(this.isVisible);
    }

    private void initObserver() {
        this.mDataObserver = new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                PlutoIndicator.this.redraw();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                PlutoIndicator.this.redraw();
            }

            public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
                PlutoIndicator.this.redraw();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                PlutoIndicator.this.redraw();
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                PlutoIndicator.this.redraw();
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                PlutoIndicator.this.redraw();
            }
        };
    }

    public void setDefaultIndicatorShape(Shape shape) {
        if (this.mUserSetSelectedIndicatorResId == 0) {
            if (shape == Shape.Oval) {
                this.mSelectedGradientDrawable.setShape(1);
            } else {
                this.mSelectedGradientDrawable.setShape(0);
            }
        }
        if (this.mUserSetUnSelectedIndicatorResId == 0) {
            if (shape == Shape.Oval) {
                this.mUnSelectedGradientDrawable.setShape(1);
            } else {
                this.mUnSelectedGradientDrawable.setShape(0);
            }
        }
        this.resetDrawable();
    }

    public void setIndicatorDrawableRes(@DrawableRes int selectedDrawable, @DrawableRes int unselectedDrawable) {
        this.mUserSetSelectedIndicatorResId = selectedDrawable;
        this.mUserSetUnSelectedIndicatorResId = unselectedDrawable;
        this.mSelectedDrawable = selectedDrawable == 0 ? this.mSelectedLayerDrawable : this.mContext.getResources().getDrawable(this.mUserSetSelectedIndicatorResId);
        this.mUnselectedDrawable = unselectedDrawable == 0 ? this.mUnSelectedLayerDrawable : this.mContext.getResources().getDrawable(this.mUserSetUnSelectedIndicatorResId);
        this.resetDrawable();
    }

    public void setDefaultIndicatorColor(int selectedColor, int unselectedColor) {
        if (this.mUserSetSelectedIndicatorResId == 0) {
            this.mSelectedGradientDrawable.setColor(selectedColor);
        }
        if (this.mUserSetUnSelectedIndicatorResId == 0) {
            this.mUnSelectedGradientDrawable.setColor(unselectedColor);
        }
        this.resetDrawable();
    }

    public void setDefaultSelectedIndicatorSize(float width, float height, Unit unit) {
        if (this.mUserSetSelectedIndicatorResId == 0) {
            float w = width;
            float h = height;
            if (unit == Unit.DP) {
                w = this.pxFromDp(width);
                h = this.pxFromDp(height);
            }
            this.mSelectedGradientDrawable.setSize((int)w, (int)h);
            this.resetDrawable();
        }
    }

    public void setDefaultUnselectedIndicatorSize(float width, float height, Unit unit) {
        if (this.mUserSetUnSelectedIndicatorResId == 0) {
            float w = width;
            float h = height;
            if (unit == Unit.DP) {
                w = this.pxFromDp(width);
                h = this.pxFromDp(height);
            }
            this.mUnSelectedGradientDrawable.setSize((int)w, (int)h);
            this.resetDrawable();
        }
    }

    public void setDefaultIndicatorSize(float width, float height, Unit unit) {
        this.setDefaultSelectedIndicatorSize(width, height, unit);
        this.setDefaultUnselectedIndicatorSize(width, height, unit);
    }

    private float dpFromPx(float px) {
        return px / this.getContext().getResources().getDisplayMetrics().density;
    }

    private float pxFromDp(float dp) {
        return dp * this.getContext().getResources().getDisplayMetrics().density;
    }

    public void setVisibility(boolean visibility) {
        this.setVisibility(visibility ? 0 : 4);
        this.resetDrawable();
    }

    public void destroySelf() {
        RecyclerView.Adapter adapter;
        if (this.mRecyclerView == null || this.mRecyclerView.getAdapter() == null) {
            return;
        }
        if (this.snapOnScrollListener != null) {
            this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.snapOnScrollListener);
            this.snapOnScrollListener = null;
        }
        if ((adapter = this.mRecyclerView.getAdapter()) != null && this.mDataObserver != null) {
            adapter.unregisterAdapterDataObserver(this.mDataObserver);
            this.mDataObserver = null;
        }
        this.removeAllViews();
    }

    void setRecyclerView(RecyclerView recyclerView, SnapHelper helper) {
        this.mRecyclerView = recyclerView;
        RecyclerView.Adapter adapter = this.mRecyclerView.getAdapter();
        if (adapter == null) {
            throw new IllegalStateException("Viewpager does not have adapter instance");
        }
        this.mRecyclerView = recyclerView;
        if (this.mDataObserver == null) {
            this.initObserver();
        }
        adapter.registerAdapterDataObserver(this.mDataObserver);
        if (this.snapOnScrollListener != null) {
            this.mRecyclerView.removeOnScrollListener((RecyclerView.OnScrollListener)this.snapOnScrollListener);
        }
        this.initScrollListener(helper, adapter);
        this.mRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)this.snapOnScrollListener);
    }

    private void initScrollListener(SnapHelper helper, RecyclerView.Adapter adapter) {
        this.snapOnScrollListener = new SnapOnScrollListener(helper, position -> {
            if (this.mItemCount == 0) {
                return;
            }
            if (adapter instanceof PlutoAdapter) {
                if (((PlutoAdapter)adapter).getRealCount() == 0) {
                    return;
                }
                position %= ((PlutoAdapter)adapter).getRealCount();
            }
            this.setItemAsSelected(position - 1);
        });
    }

    private void resetDrawable() {
        for (View view : this.mIndicators) {
            if (this.mPreviousSelectedIndicator != null && this.mPreviousSelectedIndicator.equals(view)) {
                ((ImageView)view).setImageDrawable(this.mSelectedDrawable);
                continue;
            }
            ((ImageView)view).setImageDrawable(this.mUnselectedDrawable);
        }
    }

    public void redraw() {
        this.mItemCount = this.getShouldDrawCount();
        this.mPreviousSelectedIndicator = null;
        for (View view : this.mIndicators) {
            this.removeView(view);
        }
        for (int i = 0; i < this.mItemCount; ++i) {
            ImageView imageView = new ImageView(this.mContext);
            imageView.setImageDrawable(this.mUnselectedDrawable);
            imageView.setPadding((int)this.mUnSelectedPadding_Left, (int)this.mUnSelectedPadding_Top, (int)this.mUnSelectedPadding_Right, (int)this.mUnSelectedPadding_Bottom);
            this.addView((View)imageView);
            this.mIndicators.add(imageView);
        }
        this.setItemAsSelected(this.mPreviousSelectedPosition);
    }

    private int getShouldDrawCount() {
        if (this.mRecyclerView.getAdapter() instanceof PlutoAdapter) {
            return ((PlutoAdapter)this.mRecyclerView.getAdapter()).getRealCount();
        }
        return this.mRecyclerView.getAdapter().getItemCount();
    }

    private void setItemAsSelected(int position) {
        ImageView currentSelected;
        if (this.mPreviousSelectedIndicator != null) {
            this.mPreviousSelectedIndicator.setImageDrawable(this.mUnselectedDrawable);
            this.mPreviousSelectedIndicator.setPadding((int)this.mUnSelectedPadding_Left, (int)this.mUnSelectedPadding_Top, (int)this.mUnSelectedPadding_Right, (int)this.mUnSelectedPadding_Bottom);
        }
        if ((currentSelected = (ImageView)this.getChildAt(position + 1)) != null) {
            currentSelected.setImageDrawable(this.mSelectedDrawable);
            currentSelected.setPadding((int)this.mSelectedPadding_Left, (int)this.mSelectedPadding_Top, (int)this.mSelectedPadding_Right, (int)this.mSelectedPadding_Bottom);
            this.mPreviousSelectedIndicator = currentSelected;
        }
        this.mPreviousSelectedPosition = position;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public int getSelectedIndicatorResId() {
        return this.mUserSetSelectedIndicatorResId;
    }

    public int getUnSelectedIndicatorResId() {
        return this.mUserSetUnSelectedIndicatorResId;
    }

    protected void onDetachedFromWindow() {
        this.destroySelf();
        super.onDetachedFromWindow();
    }

    public static enum Unit {
        DP,
        Px;

    }

    public static enum Shape {
        Oval,
        Rectangle;

    }
}

