/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.authorization;

import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.ObjectReference;
import com.openshift.restclient.IClient;
import com.openshift.restclient.model.IObjectReference;
import com.openshift.restclient.model.authorization.IRoleBinding;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class RoleBinding
extends KubernetesResource
implements IRoleBinding {
    private static final String ROLE_REF = "roleRef";
    private static final String USER_NAMES = "userNames";
    private static final String GROUP_NAMES = "groupNames";

    public RoleBinding(ModelNode node, IClient client, Map<String, String[]> propertyKeys) {
        super(node, client, propertyKeys);
    }

    @Override
    public void setUserNames(Set<String> names) {
        if (names == null) {
            names = Collections.emptySet();
        }
        this.set(USER_NAMES, names);
    }

    @Override
    public Set<String> getUserNames() {
        return this.asSet(USER_NAMES, ModelType.STRING);
    }

    @Override
    public void addUserName(String name) {
        this.get(USER_NAMES).add(name);
    }

    @Override
    public void setGroupNames(Set<String> names) {
        if (names == null) {
            names = Collections.emptySet();
        }
        this.set(GROUP_NAMES, names);
    }

    @Override
    public Set<String> getGroupNames() {
        return this.asSet(GROUP_NAMES, ModelType.STRING);
    }

    @Override
    public void addGroupName(String name) {
        this.get(GROUP_NAMES).add(name);
    }

    @Override
    public void setSubjects(Set<IObjectReference> subjects) {
        if (subjects == null) {
            subjects = Collections.emptySet();
        }
        ModelNode node = this.get("subjects");
        node.clear();
        for (IObjectReference ref : subjects) {
            node.add(ModelNode.fromJSONString((String)ref.toJson()));
        }
    }

    @Override
    public Set<IObjectReference> getSubjects() {
        HashSet<IObjectReference> set = new HashSet<IObjectReference>();
        ModelNode node = this.get("subjects");
        if (node.isDefined()) {
            for (ModelNode ref : node.asList()) {
                set.add(new ObjectReference(ref));
            }
        }
        return set;
    }

    @Override
    public IObjectReference getRoleRef() {
        return new ObjectReference(this.get(ROLE_REF));
    }

    @Override
    public void setRoleRef(IObjectReference roleRef) {
        ModelNode node = this.get(ROLE_REF);
        node.set(ModelNode.fromJSONString((String)roleRef.toJson()));
    }
}

