/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.jenkins.plugins.pipeline.Auth;
import com.openshift.jenkins.plugins.pipeline.ParamVerify;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftParameterOverrides;
import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.ISSLCertificateCallback;
import hudson.EnvVars;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;

public interface IOpenShiftPluginDescriptor
extends IOpenShiftParameterOverrides {
    public static final Logger LOGGER = Logger.getLogger(IOpenShiftPluginDescriptor.class.getName());

    default public FormValidation doCheckApiURL(@QueryParameter String value) throws IOException, ServletException {
        return ParamVerify.doCheckApiURL(value);
    }

    default public FormValidation doCheckNamespace(@QueryParameter String value) throws IOException, ServletException {
        return ParamVerify.doCheckNamespace(value);
    }

    default public FormValidation doCheckAuthToken(@QueryParameter String value) {
        return ParamVerify.doCheckToken(value);
    }

    default public FormValidation doCheckWaitTime(@QueryParameter String value) {
        return ParamVerify.doCheckForWaitTime(value);
    }

    default public ListBoxModel doFillWaitUnitItems() {
        ListBoxModel items = new ListBoxModel();
        items.add("Seconds", "sec");
        items.add("Minutes", "min");
        items.add("Milliseconds", "milli");
        return items;
    }

    default public EnvVars buildEnvVars() {
        String[] reqPieces;
        EnvVars allOverrides = new EnvVars(EnvVars.masterEnvVars);
        if (Jenkins.getInstance().getGlobalNodeProperties() != null && Jenkins.getInstance().getGlobalNodeProperties().get(EnvironmentVariablesNodeProperty.class) != null && ((EnvironmentVariablesNodeProperty)Jenkins.getInstance().getGlobalNodeProperties().get(EnvironmentVariablesNodeProperty.class)).getEnvVars() != null) {
            allOverrides.putAll((Map)((EnvironmentVariablesNodeProperty)Jenkins.getInstance().getGlobalNodeProperties().get(EnvironmentVariablesNodeProperty.class)).getEnvVars());
        }
        if ((reqPieces = Stapler.getCurrentRequest().getRequestURI().split("/")) != null && reqPieces.length > 2) {
            for (Job j : Jenkins.getInstance().getAllItems(Job.class)) {
                if (!j.getName().equals(reqPieces[2])) continue;
                List jps = j.getAllProperties();
                for (JobProperty jp : jps) {
                    if (!(jp instanceof ParametersDefinitionProperty)) continue;
                    ParametersDefinitionProperty prop = (ParametersDefinitionProperty)jp;
                    for (ParameterDefinition param : prop.getParameterDefinitions()) {
                        allOverrides.put(param.getName(), param.getDefaultParameterValue().getValue().toString());
                    }
                }
            }
        }
        return allOverrides;
    }

    default public FormValidation doTestConnection(@QueryParameter String apiURL, @QueryParameter String authToken) {
        EnvVars allOverrides = this.buildEnvVars();
        if (apiURL == null || StringUtils.isEmpty((String)apiURL)) {
            if (allOverrides.containsKey((Object)"KUBERNETES_SERVICE_HOST") && !StringUtils.isEmpty((String)((String)allOverrides.get((Object)"KUBERNETES_SERVICE_HOST")))) {
                apiURL = "https://" + (String)allOverrides.get((Object)"KUBERNETES_SERVICE_HOST");
                if (allOverrides.containsKey((Object)"KUBERNETES_SERVICE_PORT")) {
                    apiURL = apiURL + ":" + (String)allOverrides.get((Object)"KUBERNETES_SERVICE_PORT");
                }
            } else if (allOverrides.containsKey((Object)"KUBERNETES_MASTER") && !StringUtils.isEmpty((String)((String)allOverrides.get((Object)"KUBERNETES_MASTER")))) {
                apiURL = (String)allOverrides.get((Object)"KUBERNETES_MASTER");
            } else {
                return FormValidation.error((String)"Required fields not provided");
            }
        }
        try {
            Auth auth = Auth.createInstance(null, this.getOverride(apiURL, (Map<String, String>)allOverrides), (Map<String, String>)allOverrides);
            ClientBuilder cb = new ClientBuilder(this.getOverride(apiURL, (Map<String, String>)allOverrides)).sslCertificateCallback((ISSLCertificateCallback)auth).usingToken(Auth.deriveBearerToken(this.getOverride(authToken, (Map<String, String>)allOverrides), null, false, (Map<String, String>)allOverrides)).sslCertificateCollection(this.getOverride(apiURL, (Map<String, String>)allOverrides), auth.getCerts());
            if (auth.useCert()) {
                cb.sslCertCallbackWithDefaultHostnameVerifier(true);
            }
            LOGGER.info("OpenShift Pipeline Plugin: testing connection for " + this.getOverride(apiURL, (Map<String, String>)allOverrides));
            DefaultClient client = (DefaultClient)cb.build();
            if (client == null) {
                return FormValidation.error((String)"Connection unsuccessful");
            }
            String status = client.getServerReadyStatus();
            LOGGER.info("OpenShift Pipeline Plugin: server ready status: " + status);
            if (status == null || !status.equalsIgnoreCase("ok")) {
                return FormValidation.error((String)("Connection made but server status is:  " + status));
            }
            Request request = client.newRequestBuilderTo(this.getOverride(apiURL, (Map<String, String>)allOverrides) + "/apis").get().build();
            Response result = ((OkHttpClient)client.adapt(OkHttpClient.class)).newCall(request).execute();
            if (result != null) {
                LOGGER.info("OpenShift Pipeline Plugin: HTTP get to " + this.getOverride(apiURL, (Map<String, String>)allOverrides) + "/apis returned HTTP code " + result.code() + " and message " + result.message());
            } else {
                LOGGER.info("OpenShift Pipeline Plugin: HTTP get to " + this.getOverride(apiURL, (Map<String, String>)allOverrides) + "/apis got a null response");
            }
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "doTestConnection", e);
            return FormValidation.error((String)("Connection unsuccessful: " + e.getClass().getName()));
        }
        return FormValidation.ok((String)"Connection successful");
    }
}

