/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.jenkins.plugins.pipeline.model;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.internal.restclient.authorization.AuthorizationContext;
import com.openshift.internal.restclient.model.DeploymentConfig;
import com.openshift.internal.restclient.okhttp.OpenShiftAuthenticator;
import com.openshift.internal.restclient.okhttp.ResponseCodeInterceptor;
import com.openshift.jenkins.plugins.pipeline.Auth;
import com.openshift.jenkins.plugins.pipeline.OpenShiftBuildCanceller;
import com.openshift.jenkins.plugins.pipeline.model.IOpenShiftParameterOverrides;
import com.openshift.jenkins.plugins.pipeline.model.RetryIClient;
import com.openshift.restclient.ClientBuilder;
import com.openshift.restclient.IClient;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IDeploymentConfig;
import com.openshift.restclient.model.IReplicationController;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.deploy.IDeploymentImageChangeTrigger;
import com.openshift.restclient.model.deploy.IDeploymentTrigger;
import com.openshift.restclient.model.route.IRoute;
import com.openshift.restclient.utils.SSLUtils;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Computer;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.fabric8.jenkins.openshiftsync.BuildCause;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import okhttp3.Authenticator;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jboss.dmr.ModelNode;

public interface IOpenShiftPlugin
extends IOpenShiftParameterOverrides {
    public static final String ANNOTATION_FAILURE = "\nWARNING: Failed to annotate %s %s with job information.";
    public static final String BUILD_URL_ENV_KEY = "BUILD_URL";
    public static final String JOB_NAME = "JOB_NAME";
    public static final String BUILD_NUMBER = "BUILD_NUMBER";
    public static final String BUILD_URL_ANNOTATION = "openshift.io/jenkins-build-uri";
    public static final String KUBERNETES_SERVICE_HOST_ENV_KEY = "KUBERNETES_SERVICE_HOST";
    public static final String KUBERNETES_SERVICE_PORT_ENV_KEY = "KUBERNETES_SERVICE_PORT";
    public static final String KUBERNETES_MASTER_ENV_KEY = "KUBERNETES_MASTER";
    public static final String NAMESPACE_FILE = "/run/secrets/kubernetes.io/serviceaccount/namespace";
    public static final String NAMESPACE_ENV_VAR = "PROJECT_NAME";
    public static final String NAMESPACE_SYNC_BUILD_CAUSE = "NAMESPACE_SYNC_BUILD_CAUSE";
    public static final String STATE_RUNNING = "Running";
    public static final String STATE_COMPLETE = "Complete";
    public static final String STATE_CANCELLED = "Cancelled";
    public static final String STATE_ERROR = "Error";
    public static final String STATE_FAILED = "Failed";

    public String getBaseClassName();

    public String getAuthToken();

    default public String getAuthToken(Map<String, String> overrides) {
        return this.getOverride(this.getAuthToken(), overrides);
    }

    public String getVerbose();

    default public String getVerbose(Map<String, String> overrides) {
        return this.getOverride(this.getVerbose(), overrides);
    }

    public Auth getAuth();

    public void setAuth(Auth var1);

    public String getApiURL();

    default public String getApiURL(Map<String, String> overrides) {
        String val = this.getOverride(this.getApiURL(), overrides);
        if ((val == null || val.length() == 0) && overrides != null && overrides.containsKey(KUBERNETES_SERVICE_HOST_ENV_KEY)) {
            val = overrides.get(KUBERNETES_SERVICE_HOST_ENV_KEY);
        }
        if (val != null && val.length() > 0 && !val.startsWith("https://")) {
            val = "https://" + val;
        }
        if (val == null || val.length() == 0) {
            val = "https://openshift.default.svc.cluster.local";
        }
        return val;
    }

    public String getNamespace();

    default public String getNamespace(Map<String, String> overrides) {
        String val = this.getOverride(this.getNamespace(), overrides);
        if (val.length() == 0) {
            if (overrides != null && overrides.containsKey(NAMESPACE_SYNC_BUILD_CAUSE)) {
                val = overrides.get(NAMESPACE_SYNC_BUILD_CAUSE);
            } else if (overrides != null && overrides.containsKey(NAMESPACE_ENV_VAR)) {
                val = overrides.get(NAMESPACE_ENV_VAR);
            } else {
                File f = new File(NAMESPACE_FILE);
                if (f.exists()) {
                    val = Auth.pullTokenFromFile(f, null);
                }
            }
        }
        return val;
    }

    public boolean coreLogic(Launcher var1, TaskListener var2, Map<String, String> var3) throws InterruptedException;

    default public IClient getClient(TaskListener listener, String displayName, Map<String, String> overrides) {
        return this.getClient(listener, displayName, overrides, Auth.deriveBearerToken(this.getAuthToken(overrides), listener, Boolean.getBoolean(this.getVerbose(overrides)), overrides));
    }

    default public IClient getClient(TaskListener listener, String displayName, Map<String, String> overrides, String token) {
        IClient client;
        Auth auth = this.getAuth();
        ClientBuilder cb = new ClientBuilder(this.getApiURL(overrides)).sslCertificateCallback((ISSLCertificateCallback)auth).usingToken(token).sslCertificateCollection(this.getApiURL(overrides), auth.getCerts());
        if (auth.useCert()) {
            cb.sslCertCallbackWithDefaultHostnameVerifier(true);
        }
        if ((client = cb.build()) == null) {
            listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; a client connection to \"%s\" could not be obtained.", displayName, this.getApiURL(overrides)));
        }
        return new RetryIClient(client, listener);
    }

    default public String getReplicationControllerState(IReplicationController rc) {
        return rc.getAnnotation("openshift.io/deployment.phase");
    }

    default public boolean isReplicationControllerScaledAppropriately(IReplicationController rc, boolean checkCount, int count) {
        boolean scaledAppropriately = false;
        if (rc == null) {
            return scaledAppropriately;
        }
        if (this.getReplicationControllerState(rc).equalsIgnoreCase(STATE_COMPLETE)) {
            if (!checkCount) {
                scaledAppropriately = true;
            } else if (rc.getCurrentReplicaCount() == count) {
                scaledAppropriately = true;
            }
        }
        return scaledAppropriately;
    }

    default public Map<String, String> consolidateEnvVars(TaskListener listener, EnvVars env, Run<?, ?> run, AbstractBuild<?, ?> build, Launcher launcher, boolean chatty) {
        TreeMap<String, String> overrides;
        block19: {
            block18: {
                block17: {
                    overrides = new TreeMap<String, String>();
                    if (run != null) {
                        try {
                            EnvVars runEnv = run.getEnvironment(listener);
                            if (chatty) {
                                listener.getLogger().println("run env vars:  " + runEnv);
                            }
                            overrides.putAll((Map<String, String>)runEnv);
                        }
                        catch (IOException | InterruptedException e) {
                            if (!chatty) break block17;
                            e.printStackTrace(listener.getLogger());
                        }
                    }
                }
                if (build != null) {
                    try {
                        EnvVars buildEnv = build.getEnvironment(listener);
                        if (chatty) {
                            listener.getLogger().println("build env vars:  " + buildEnv);
                        }
                        overrides.putAll((Map<String, String>)buildEnv);
                    }
                    catch (IOException | InterruptedException e) {
                        if (!chatty) break block18;
                        e.printStackTrace(listener.getLogger());
                    }
                }
            }
            try {
                EnvVars computerEnv = null;
                Computer computer = Computer.currentComputer();
                if (computer != null) {
                    computerEnv = computer.getEnvironment();
                } else {
                    computer = launcher.getComputer();
                    if (computer != null) {
                        computerEnv = computer.getEnvironment();
                    }
                }
                if (chatty) {
                    listener.getLogger().println("computer env vars:  " + computerEnv);
                }
                if (computerEnv != null) {
                    overrides.putAll((Map<String, String>)computerEnv);
                }
            }
            catch (IOException | InterruptedException e2) {
                if (!chatty) break block19;
                e2.printStackTrace(listener.getLogger());
            }
        }
        if (env != null) {
            if (chatty) {
                listener.getLogger().println("DSL injected env vars: " + env);
            }
            overrides.putAll((Map<String, String>)env);
        }
        return overrides;
    }

    default public Map<String, String> constructBuildUrl(TaskListener listener, Map<String, String> overrides, boolean chatty) {
        String jobName = overrides.get(JOB_NAME);
        String buildNum = overrides.get(BUILD_NUMBER);
        if (jobName != null && buildNum != null) {
            List routes;
            block8: {
                jobName = jobName.replace(" ", "%20");
                IClient client = this.getClient(listener, this.getDisplayName(), overrides);
                routes = new ArrayList();
                try {
                    routes = client.list("Route", this.getNamespace(overrides));
                }
                catch (Throwable t) {
                    if (!chatty) break block8;
                    t.printStackTrace(listener.getLogger());
                }
            }
            for (IRoute route : routes) {
                if (!route.getServiceName().equals("jenkins")) continue;
                String base = route.getURL();
                if (!base.endsWith("/")) {
                    base = base + "/";
                }
                overrides.put(BUILD_URL_ENV_KEY, base + "job/" + jobName + "/" + buildNum + "/");
                break;
            }
            if (!overrides.containsKey(BUILD_URL_ENV_KEY)) {
                overrides.put(BUILD_URL_ENV_KEY, Jenkins.getInstance().getRootUrl() + "job/" + jobName + "/" + buildNum + "/");
            }
        } else if (chatty) {
            listener.getLogger().printf("\n missing jenkins job/build info: job %s build %s \n", jobName, buildNum);
        }
        return overrides;
    }

    default public boolean doItCore(TaskListener listener, EnvVars env, Run<?, ?> run, AbstractBuild<?, ?> build, Launcher launcher) throws InterruptedException {
        BuildCause cause;
        boolean chatty = Boolean.parseBoolean(this.getVerbose());
        listener.getLogger().println("NOTE: steps like this one from the OpenShift Pipeline Plugin will not be supported against OpenShift API Servers later than v3.11");
        if (run == null && build == null) {
            throw new RuntimeException("Either the run or build parameter must be set");
        }
        BuildCause buildCause = cause = run != null ? (BuildCause)run.getCause(BuildCause.class) : null;
        if (cause != null) {
            if (chatty) {
                listener.getLogger().println("build cause namespace from sync plugin is " + cause.getNamespace());
            }
            env.put(NAMESPACE_SYNC_BUILD_CAUSE, cause.getNamespace());
        }
        Map<String, String> overrides = this.consolidateEnvVars(listener, env, run, build, launcher, chatty);
        this.setAuth(Auth.createInstance((TaskListener)(chatty ? listener : null), this.getApiURL(overrides), overrides));
        if (!overrides.containsKey(BUILD_URL_ENV_KEY)) {
            overrides = this.constructBuildUrl(listener, overrides, chatty);
        }
        if (chatty) {
            listener.getLogger().println("\n\nOpenShift Pipeline Plugin: env vars for this job:  " + overrides);
        }
        try {
            boolean rc = this.coreLogic(launcher, listener, overrides);
            return rc;
        }
        catch (Throwable t) {
            t.printStackTrace(listener.getLogger());
            return false;
        }
    }

    public String getDisplayName();

    default public void doIt(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        boolean successful = this.doItCore(listener, null, run, null, launcher);
        if (!successful) {
            throw new AbortException("\"" + this.getDisplayName() + "\" failed");
        }
    }

    default public boolean doIt(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        boolean successful = this.doItCore((TaskListener)listener, null, null, build, launcher);
        if (!successful) {
            throw new AbortException("\"" + this.getDisplayName() + "\" failed");
        }
        return successful;
    }

    default public boolean isBuildRunning(String bldState) {
        return bldState != null && bldState.equals(STATE_RUNNING);
    }

    default public boolean isBuildFinished(String bldState) {
        return bldState != null && (bldState.equals(STATE_COMPLETE) || bldState.equals(STATE_FAILED) || bldState.equals(STATE_ERROR) || bldState.equals(STATE_CANCELLED));
    }

    default public boolean isDeployFinished(String deployState) {
        return deployState != null && (deployState.equals(STATE_FAILED) || deployState.equals(STATE_COMPLETE));
    }

    default public boolean verifyBuild(long startTime, long wait, IClient client, String bldCfg, String bldId, String namespace, boolean chatty, TaskListener listener, String displayName, boolean checkDeps, boolean annotateRC, Map<String, String> env) throws InterruptedException {
        String bldState = null;
        while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) < startTime + wait) {
            IBuild bld = (IBuild)client.get("Build", bldId, namespace);
            bldState = bld.getStatus();
            if (chatty) {
                listener.getLogger().println("\nOpenShiftBuilder post bld launch bld state:  " + bldState);
            }
            if (this.isBuildFinished(bldState)) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                OpenShiftBuildCanceller canceller = new OpenShiftBuildCanceller(this.getApiURL(env), this.getNamespace(env), this.getAuthToken(env), this.getVerbose(env), bldCfg);
                canceller.setAuth(this.getAuth());
                canceller.coreLogic(null, listener, env);
                throw e;
            }
        }
        if (bldState == null || !bldState.equals(STATE_COMPLETE)) {
            String displayState = bldState;
            if (displayState == null) {
                displayState = "NotStarted";
            }
            listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; build \"%s\" did not complete successfully within the configured timeout of \"%s\" ms; last reported status:  [%s].", displayName, bldId, wait, displayState));
            return false;
        }
        if (checkDeps) {
            boolean triggerSuccess = this.didAllImagesChangeIfNeeded(bldCfg, listener, chatty, client, namespace, wait, annotateRC, env);
            if (triggerSuccess) {
                listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully; build \"%s\" has completed with status:  [Complete].  All deployments with ImageChange triggers in automatic mode based on this build's output triggered off of the new image.", displayName, bldId));
                return true;
            }
            listener.getLogger().println(String.format("\n\nExiting \"%s\" unsuccessfully; build \"%s\" has completed with status:  [Complete]. However, not all deployments with ImageChange triggers based on this build's output triggered off of the new image.", displayName, bldId));
            return false;
        }
        listener.getLogger().println(String.format("\n\nExiting \"%s\" successfully; build \"%s\" has completed with status:  [Complete].", displayName, bldId));
        return true;
    }

    default public boolean doesDCTriggerOnImageTag(IClient client, IDeploymentConfig dc, String imageTag, boolean chatty, TaskListener listener) {
        if (dc == null || imageTag == null) {
            throw new RuntimeException("needed param null for doesDCTriggerOnImageTag");
        }
        if (listener == null) {
            chatty = false;
        }
        Collection triggers = dc.getTriggers();
        for (IDeploymentTrigger trigger : triggers) {
            if (!(trigger instanceof IDeploymentImageChangeTrigger)) continue;
            IDeploymentImageChangeTrigger ict = (IDeploymentImageChangeTrigger)trigger;
            if (chatty) {
                listener.getLogger().println("\n\n found ict " + ict.toString() + " with from " + ict.getFrom().getNameAndTag() + ", auto: " + ict.isAutomatic());
            }
            if (!ict.getFrom().getNameAndTag().contains(imageTag) || !ict.isAutomatic()) continue;
            if (chatty) {
                listener.getLogger().println("\n\n ict  triggers off of " + imageTag);
            }
            return true;
        }
        return false;
    }

    default public boolean didICTCauseDeployment(IClient client, IDeploymentConfig dc, String imageTag, boolean chatty, TaskListener listener, long wait) throws InterruptedException {
        long currTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime()) - wait / 3L <= currTime) {
            if (!(dc = (IDeploymentConfig)client.get("DeploymentConfig", dc.getName(), dc.getNamespace())).didImageTrigger(imageTag)) {
                if (chatty) {
                    listener.getLogger().println("\n ICT did not fire");
                }
                Thread.sleep(10000L);
                continue;
            }
            if (chatty) {
                listener.getLogger().println("\n ICT fired for deployment " + dc.toJson(false));
            }
            return true;
        }
        if (chatty) {
            listener.getLogger().println("\n done checking dc " + dc.toJson(false));
        }
        return false;
    }

    default public boolean didImageChangeFromPreviousVersion(IClient client, int latestVersion, boolean chatty, TaskListener listener, String depCfg, String namespace, String latestImageHexID, String imageTag) {
        IReplicationController prevRC;
        block10: {
            int previousVersion = latestVersion - 1;
            if (previousVersion < 1) {
                if (chatty) {
                    listener.getLogger().println("\n first version skip image compare");
                }
                return true;
            }
            prevRC = null;
            try {
                prevRC = (IReplicationController)client.get("ReplicationController", depCfg + "-" + previousVersion, namespace);
            }
            catch (Throwable t) {
                if (!chatty) break block10;
                t.printStackTrace(listener.getLogger());
            }
        }
        if (prevRC == null) {
            listener.getLogger().println("\n\n could not obtain previous replication controller");
            return false;
        }
        String dcJson = prevRC.getAnnotation("openshift.io/encoded-deployment-config");
        if (dcJson == null || dcJson.length() == 0) {
            listener.getLogger().println("\n\n associated DeploymentConfig for previous ReplicationController missing");
            return false;
        }
        ModelNode dcNode = ModelNode.fromJSONString((String)dcJson);
        DeploymentConfig dc = new DeploymentConfig(dcNode, client, null);
        String previousImageHexID = dc.getImageHexIDForImageNameAndTag(imageTag);
        if (previousImageHexID == null || previousImageHexID.length() == 0) {
            listener.getLogger().println("\n\n could not obtain hex image ID for previous deployment");
            return false;
        }
        if (latestImageHexID.equals(previousImageHexID)) {
            if (chatty) {
                listener.getLogger().println("\n images still the same " + latestImageHexID);
            }
            return false;
        }
        if (chatty) {
            listener.getLogger().println("\n image did change, new image " + latestImageHexID + " old image " + previousImageHexID);
        }
        return true;
    }

    default public boolean didAllImagesChangeIfNeeded(String buildConfig, TaskListener listener, boolean chatty, IClient client, String namespace, long wait, boolean annotateRC, Map<String, String> env) throws InterruptedException {
        List allDC;
        IBuildConfig bc;
        if (chatty) {
            listener.getLogger().println("\n checking if the build config " + buildConfig + " got the image changes it needed");
        }
        if ((bc = (IBuildConfig)client.get("BuildConfig", buildConfig, namespace)) == null && chatty) {
            listener.getLogger().println("\n bc null for " + buildConfig);
        }
        String imageTag = null;
        try {
            imageTag = bc.getOutputRepositoryName();
            if (chatty) {
                listener.getLogger().println("\n\n build config output image tag " + imageTag);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (imageTag == null) {
            if (chatty) {
                listener.getLogger().println("\n\n build config " + bc.getName() + " does not output an image");
            }
            return true;
        }
        if (chatty) {
            listener.getLogger().println("\n\n build config " + bc.getName() + " generates image " + imageTag);
        }
        if ((allDC = client.list("DeploymentConfig", namespace)) == null || allDC.size() == 0) {
            if (chatty) {
                listener.getLogger().println("\n\n no deployment configs present");
            }
            return true;
        }
        ArrayList<IDeploymentConfig> dcsToCheck = new ArrayList<IDeploymentConfig>();
        for (IDeploymentConfig dc : allDC) {
            if (chatty) {
                listener.getLogger().println("\n checking triggers on dc " + dc.getName());
            }
            if (!this.doesDCTriggerOnImageTag(client, dc, imageTag, chatty, listener)) continue;
            if (chatty) {
                listener.getLogger().println("\n adding dc to check " + dc.getName());
            }
            dcsToCheck.add(dc);
        }
        for (IDeploymentConfig dc : dcsToCheck) {
            if (chatty) {
                listener.getLogger().println("\n looking at image ids for " + dc.getName() + " with json " + dc.toJson(false));
            }
            if (dc.getLatestVersionNumber() == 1) {
                if (annotateRC) {
                    IReplicationController rc = this.getLatestReplicationController(dc, namespace, client, (TaskListener)(chatty ? listener : null));
                    this.annotateJobInfoToResource(client, listener, chatty, env, (IResource)rc);
                }
                return true;
            }
            if (this.didICTCauseDeployment(client, dc, imageTag, chatty, listener, wait)) {
                String latestImageHexID = dc.getImageHexIDForImageNameAndTag(imageTag);
                if (latestImageHexID == null) {
                    if (!chatty) continue;
                    listener.getLogger().println("\n dc " + dc.getName() + " did not have a reference to " + imageTag);
                    continue;
                }
                if (this.didImageChangeFromPreviousVersion(client, dc.getLatestVersionNumber(), chatty, listener, dc.getName(), namespace, latestImageHexID, imageTag)) {
                    if (annotateRC) {
                        IReplicationController rc = this.getLatestReplicationController(dc, namespace, client, (TaskListener)(chatty ? listener : null));
                        this.annotateJobInfoToResource(client, listener, chatty, env, (IResource)rc);
                    }
                    if (!chatty) continue;
                    listener.getLogger().println("\n dc " + dc.getName() + " did trigger based on image change as expected");
                    continue;
                }
                if (chatty) {
                    listener.getLogger().println("\n dc " + dc.getName() + " did not trigger based on image change as expected");
                }
                return false;
            }
            return false;
        }
        return true;
    }

    default public IReplicationController getLatestReplicationController(IDeploymentConfig dc, String namespace, IClient client, TaskListener listener) {
        int latestVersion = dc.getLatestVersionNumber();
        if (latestVersion == 0) {
            return null;
        }
        IReplicationController rc = null;
        while (latestVersion > 0) {
            block4: {
                String repId = dc.getName() + "-" + latestVersion;
                try {
                    rc = (IReplicationController)client.get("ReplicationController", repId, namespace);
                }
                catch (Throwable t) {
                    if (listener == null) break block4;
                    t.printStackTrace(listener.getLogger());
                }
            }
            if (rc == null) continue;
            if (!"true".equalsIgnoreCase(rc.getAnnotation("openshift.io/deployment.cancelled"))) break;
            rc = null;
            --latestVersion;
        }
        return rc;
    }

    default public boolean annotateJobInfoToResource(IClient client, TaskListener listener, boolean chatty, Map<String, String> env, IResource resource) {
        boolean annotated = false;
        String buildURL = env.get(BUILD_URL_ENV_KEY);
        if (buildURL == null) {
            buildURL = "job/" + env.get(JOB_NAME) + "/" + env.get(BUILD_NUMBER);
        }
        for (int i = 0; i < 3; ++i) {
            IResource annotatedResource = client.get(resource.getKind(), resource.getName(), resource.getNamespace());
            annotatedResource.setAnnotation(BUILD_URL_ANNOTATION, buildURL);
            try {
                client.update(annotatedResource);
                annotated = true;
                break;
            }
            catch (OpenShiftException e) {
                if (chatty) {
                    e.printStackTrace(listener.getLogger());
                }
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        if (!annotated) {
            listener.getLogger().println(String.format(ANNOTATION_FAILURE, resource.getKind(), resource.getName()));
        }
        return annotated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    default public String httpGet(boolean chatty, TaskListener listener, Map<String, String> overrides, String urlString) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace(listener.getLogger());
            return null;
        }
        try {
            AuthorizationContext authContext = new AuthorizationContext(this.getAuthToken(overrides), null, null);
            ResponseCodeInterceptor responseCodeInterceptor = new ResponseCodeInterceptor();
            OpenShiftAuthenticator authenticator = new OpenShiftAuthenticator();
            Dispatcher dispatcher = new Dispatcher();
            RetryIClient iclient = (RetryIClient)this.getClient(listener, this.getDisplayName(), overrides);
            DefaultClient client = iclient.getDefaultClient();
            OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor((Interceptor)responseCodeInterceptor).authenticator((Authenticator)authenticator).dispatcher(dispatcher).readTimeout(120000L, TimeUnit.MILLISECONDS).writeTimeout(120000L, TimeUnit.MILLISECONDS).connectTimeout(120000L, TimeUnit.MILLISECONDS);
            X509TrustManager trustManager = null;
            trustManager = this.getAuth().useCert() ? Auth.createLocalTrustStore(this.getAuth(), this.getApiURL(overrides)) : new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslContext = null;
            try {
                sslContext = SSLUtils.getSSLContext((TrustManager)trustManager);
            }
            catch (KeyManagementException e) {
                if (chatty) {
                    e.printStackTrace(listener.getLogger());
                }
                String string = null;
                Auth.resetLocalTrustStore();
                return string;
            }
            catch (NoSuchAlgorithmException e) {
                if (chatty) {
                    e.printStackTrace(listener.getLogger());
                }
                String string = null;
                Auth.resetLocalTrustStore();
                return string;
            }
            builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            OkHttpClient okClient = builder.build();
            authContext.setClient((IClient)client);
            responseCodeInterceptor.setClient(client);
            authenticator.setClient(client);
            authenticator.setOkClient(okClient);
            Request request = client.newRequestBuilderTo(url.toString()).get().build();
            try {
                String response;
                Response result = okClient.newCall(request).execute();
                String string = response = result.body().string();
                return string;
            }
            catch (IOException e) {
                if (chatty) {
                    e.printStackTrace(listener.getLogger());
                }
                String string = null;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                Auth.resetLocalTrustStore();
                return string;
            }
        }
        finally {
            Auth.resetLocalTrustStore();
        }
    }
}

